/*
 * Decompiled with CFR 0.152.
 */
package com.xyeidc.xyeidc_ad;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="xyeidc_ad", bus=Mod.EventBusSubscriber.Bus.MOD)
public class XyeidcAdConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.ConfigValue<String> RESOURCE_ID = BUILDER.comment("ResourceId").define("resourceId", (Object)"1");
    public static final ForgeConfigSpec.ConfigValue<String> ENCODE = BUILDER.comment("encode").define("encode", (Object)"UTF-8");
    public static Resource resource;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        Gson gson = new Gson();
        String resourceId = (String)RESOURCE_ID.get();
        Map resourceMap = (Map)gson.fromJson(XyeidcAdConfig.getResourceData(resourceId), HashMap.class);
        if (resourceMap != null) {
            resource = new Resource();
            resource.setId(resourceId).setName((String)((Map)resourceMap.get("data")).get("name"));
        }
    }

    private static String getResourceData(String resourceId) {
        try {
            String url = "https://resource-api.xyeidc.com/client/resources/" + resourceId;
            URL obj = new URL(url);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("GET");
            int responseCode = con.getResponseCode();
            System.out.println("Response Code: " + responseCode);
            if (responseCode == 200) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                String jsonResponse = response.toString();
                System.out.println("JSON Response: " + jsonResponse);
                return jsonResponse;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static class Resource {
        private String id;
        private String name;

        public String getId() {
            return this.id;
        }

        public Resource setId(String id) {
            this.id = id;
            return this;
        }

        public String getName() {
            byte[] bytes = this.name.getBytes();
            try {
                return new String(bytes, (String)ENCODE.get());
            }
            catch (UnsupportedEncodingException e) {
                return this.name;
            }
        }

        public Resource setName(String name) {
            this.name = name;
            return this;
        }
    }
}

