/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.block;

import com.google.common.collect.ImmutableMap;
import com.renyigesai.immortalers_delight.block.RotatingRoastMeatBlockEntity;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightBlocks;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightItems;
import com.renyigesai.immortalers_delight.util.task.TimekeepingTask;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class RotatingRoastMeatBlock
extends BaseEntityBlock {
    public static final IntegerProperty BITES = IntegerProperty.m_61631_((String)"bites", (int)0, (int)4);
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final VoxelShape BOX = RotatingRoastMeatBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)18.0, (double)15.0);

    public RotatingRoastMeatBlock(BlockBehaviour.Properties p_54120_) {
        super(p_54120_);
        super.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BITES, (Comparable)Integer.valueOf(0))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return BOX;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel.f_46443_ ? null : RotatingRoastMeatBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)ImmortalersDelightBlocks.ROTATING_ROAST_MEAT_ENTITY.get()), RotatingRoastMeatBlockEntity::tick);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack hand_stack = player.m_21120_(hand);
        if (hand_stack.m_204117_(ModTags.KNIVES)) {
            return this.cut(state, level, pos, player);
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }

    public InteractionResult cut(BlockState state, Level level, BlockPos pos, Player player) {
        int bites = (Integer)state.m_61143_((Property)BITES);
        Direction direction = player.m_6350_().m_122424_();
        if (bites < 4) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
            ItemUtils.spawnItemEntity((Level)level, (ItemStack)new ItemStack((ItemLike)ImmortalersDelightItems.RAW_SNIFFER_SLICE.get(), 2), (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.3), (double)((double)pos.m_123343_() + 0.5), (double)((double)direction.m_122429_() * 0.15), (double)0.05, (double)((double)direction.m_122431_() * 0.15));
        } else {
            level.m_7471_(pos, false);
            ItemUtils.spawnItemEntity((Level)level, (ItemStack)new ItemStack((ItemLike)Items.f_42025_), (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.3), (double)((double)pos.m_123343_() + 0.5), (double)((double)direction.m_122429_() * 0.15), (double)0.05, (double)((double)direction.m_122431_() * 0.15));
        }
        level.m_5594_(null, pos, SoundEvents.f_12639_, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    public boolean m_6724_(BlockState pState) {
        return true;
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!((Boolean)pState.m_61143_((Property)LIT)).booleanValue() || TimekeepingTask.getImmortalTickTime() % 5000L < 1000L) {
            // empty if block
        }
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockPos blockpos;
        BlockState blockstate;
        super.m_214162_(pState, pLevel, pPos, pRandom);
        if (((Boolean)pState.m_61143_((Property)LIT)).booleanValue() && pRandom.m_188503_(10) == 0 && !RotatingRoastMeatBlock.m_49918_((VoxelShape)(blockstate = pLevel.m_8055_(blockpos = pPos.m_7494_())).m_60812_((BlockGetter)pLevel, blockpos), (Direction)Direction.UP)) {
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123777_, (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, (double)(pRandom.m_188501_() / 2.0f), 5.0E-5, (double)(pRandom.m_188501_() / 2.0f));
        }
    }

    private boolean isHeated(Level level, BlockPos pos) {
        ImmutableMap posMap = new ImmutableMap.Builder().put((Object)0, (Object)pos.m_122012_()).put((Object)1, (Object)pos.m_122019_()).put((Object)2, (Object)pos.m_122024_()).put((Object)3, (Object)pos.m_122029_()).build();
        for (int i = 0; i < 4 && posMap.get(i) != null; ++i) {
            BlockState stateFurtherBelow;
            BlockState stateBelow = level.m_8055_(Objects.requireNonNull((BlockPos)posMap.get(i)));
            if (stateBelow.m_204336_(ModTags.HEAT_SOURCES)) {
                return stateBelow.m_61138_((Property)BlockStateProperties.f_61443_) ? (Boolean)stateBelow.m_61143_((Property)BlockStateProperties.f_61443_) : true;
            }
            if (!stateBelow.m_204336_(ModTags.HEAT_CONDUCTORS) || !(stateFurtherBelow = level.m_8055_(pos.m_6625_(2))).m_204336_(ModTags.HEAT_SOURCES)) continue;
            if (stateFurtherBelow.m_61138_((Property)BlockStateProperties.f_61443_)) {
                return (Boolean)stateFurtherBelow.m_61143_((Property)BlockStateProperties.f_61443_);
            }
            return true;
        }
        return false;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_280296_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BITES, LIT});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new RotatingRoastMeatBlockEntity(pPos, pState);
    }
}

