/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.block.ancient_stove;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightBlocks;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.ChangeOverTimeBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ToolActions;
import vectorwing.farmersdelight.common.registry.ModDamageTypes;
import vectorwing.farmersdelight.common.registry.ModSounds;
import vectorwing.farmersdelight.common.utility.MathUtils;

public class WeatheringAncientStoveBlock
extends HorizontalDirectionalBlock
implements WeatheringCopper {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    private final WeatheringCopper.WeatherState weatherState;
    Supplier<BiMap<Block, Block>> NEXT_BY_BLOCK = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)((Block)ImmortalersDelightBlocks.ANCIENT_STOVE.get()), (Object)((Block)ImmortalersDelightBlocks.EXPOSED_ANCIENT_STOVE.get())).put((Object)((Block)ImmortalersDelightBlocks.EXPOSED_ANCIENT_STOVE.get()), (Object)((Block)ImmortalersDelightBlocks.WEATHERED_ANCIENT_STOVE.get())).put((Object)((Block)ImmortalersDelightBlocks.WEATHERED_ANCIENT_STOVE.get()), (Object)((Block)ImmortalersDelightBlocks.OXIDIZED_ANCIENT_STOVE.get())).build());

    public WeatheringAncientStoveBlock(BlockBehaviour.Properties pProperties, WeatheringCopper.WeatherState weatherState) {
        super(pProperties);
        this.weatherState = weatherState;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true));
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        this.m_220947_(pState, pLevel, pPos, pRandom);
    }

    public void m_220947_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pRandom.m_188501_() < 0.05688889f) {
            this.m_220952_(pState, pLevel, pPos, pRandom);
        }
    }

    public void m_220952_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockPos blockpos;
        int l;
        int i = this.getAge().ordinal();
        int j = 0;
        int k = 0;
        Iterator iterator = BlockPos.m_121925_((BlockPos)pPos, (int)4, (int)4, (int)4).iterator();
        while (iterator.hasNext() && (l = (blockpos = (BlockPos)iterator.next()).m_123333_((Vec3i)pPos)) <= 4) {
            BlockState blockstate;
            Block block;
            if (blockpos.equals((Object)pPos) || !((block = (blockstate = pLevel.m_8055_(blockpos)).m_60734_()) instanceof ChangeOverTimeBlock)) continue;
            Enum oenum = ((ChangeOverTimeBlock)block).m_142297_();
            if (this.getAge().getClass() != oenum.getClass()) continue;
            int i1 = oenum.ordinal();
            if (i1 < i) {
                return;
            }
            if (i1 > i) {
                ++k;
                continue;
            }
            ++j;
        }
        float f = (float)(k + 1) / (float)(k + j + 1);
        float f1 = f * f * this.m_142377_();
        if (pRandom.m_188501_() < f1) {
            this.m_142123_(pState).ifPresent(p_153039_ -> pLevel.m_46597_(pPos, p_153039_));
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldStack = player.m_21120_(hand);
        Item heldItem = heldStack.m_41720_();
        if (heldItem instanceof AxeItem) {
            Block scrape = this.getScrape(state.m_60734_());
            if (scrape != null) {
                BlockState newState = (BlockState)((BlockState)scrape.m_49966_().m_61124_((Property)LIT, (Comparable)((Boolean)state.m_61143_((Property)LIT)))).m_61124_((Property)f_54117_, (Comparable)((Direction)state.m_61143_((Property)f_54117_)));
                level.m_46597_(pos, newState);
                if (!player.m_150110_().f_35937_) {
                    heldStack.m_41622_(1, (LivingEntity)player, p_150686_ -> p_150686_.m_21190_(hand));
                }
                level.m_5594_(player, pos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_46796_(3005, pos, 0);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            if (heldStack.canPerformAction(ToolActions.SHOVEL_DIG)) {
                this.extinguish(state, level, pos);
                heldStack.m_41622_(1, (LivingEntity)player, action -> action.m_21190_(hand));
                return InteractionResult.SUCCESS;
            }
            if (heldItem == Items.f_42447_) {
                if (!level.m_5776_()) {
                    level.m_5594_(null, pos, SoundEvents.f_11914_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                this.extinguish(state, level, pos);
                if (!player.m_7500_()) {
                    player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
                }
                return InteractionResult.SUCCESS;
            }
        } else {
            if (heldItem instanceof FlintAndSteelItem) {
                level.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, MathUtils.RAND.nextFloat() * 0.4f + 0.8f);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.TRUE), 11);
                heldStack.m_41622_(1, (LivingEntity)player, action -> action.m_21190_(hand));
                return InteractionResult.SUCCESS;
            }
            if (heldItem instanceof FireChargeItem) {
                level.m_5594_(null, pos, SoundEvents.f_11874_, SoundSource.BLOCKS, 1.0f, (MathUtils.RAND.nextFloat() - MathUtils.RAND.nextFloat()) * 0.2f + 1.0f);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.TRUE), 11);
                if (!player.m_7500_()) {
                    heldStack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        boolean isLit = (Boolean)level.m_8055_(pos).m_61143_((Property)LIT);
        if (isLit && !entity.m_5825_() && entity instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)((LivingEntity)entity))) {
            entity.m_6469_(ModDamageTypes.getSimpleDamageSource((Level)level, (ResourceKey)ModDamageTypes.STOVE_BURN), 1.0f);
        }
        super.m_141947_(level, pos, state, entity);
    }

    public void extinguish(BlockState state, Level level, BlockPos pos) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
        double x = (double)pos.m_123341_() + 0.5;
        double y = pos.m_123342_();
        double z = (double)pos.m_123343_() + 0.5;
        level.m_7785_(x, y, z, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f, false);
    }

    public void m_214162_(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (((Boolean)stateIn.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
            double x = (double)pos.m_123341_() + 0.5;
            double y = pos.m_123342_();
            double z = (double)pos.m_123343_() + 0.5;
            if (rand.m_188503_(10) == 0) {
                level.m_7785_(x, y, z, (SoundEvent)ModSounds.BLOCK_STOVE_CRACKLE.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction direction = (Direction)stateIn.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            Direction.Axis direction$axis = direction.m_122434_();
            double horizontalOffset = rand.m_188500_() * 0.6 - 0.3;
            double xOffset = direction$axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : horizontalOffset;
            double yOffset = rand.m_188500_() * 6.0 / 16.0;
            double zOffset = direction$axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : horizontalOffset;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + xOffset, y + yOffset, z + zOffset, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x + xOffset, y + yOffset, z + zOffset, 0.0, 0.0, 0.0);
        }
    }

    public boolean m_6724_(BlockState pState) {
        return this.getNext(pState.m_60734_()).isPresent() && (Boolean)pState.m_61143_((Property)LIT) == false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{LIT, f_54117_});
    }

    public WeatheringCopper.WeatherState getAge() {
        return this.weatherState;
    }

    public Optional<Block> getNext(Block pBlock) {
        return Optional.ofNullable((Block)this.NEXT_BY_BLOCK.get().get((Object)pBlock));
    }

    public Optional<BlockState> m_142123_(BlockState pState) {
        return this.getNext(pState.m_60734_()).map(p_154896_ -> p_154896_.m_152465_(pState));
    }

    public Block getScrape(Block value) {
        for (Map.Entry entry : this.NEXT_BY_BLOCK.get().entrySet()) {
            if (!((Block)entry.getValue()).equals(value)) continue;
            return (Block)entry.getKey();
        }
        return null;
    }
}

