/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.WaterPatchModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.Boat;

public class AncientWoodBoatModel
extends ListModel<Boat>
implements WaterPatchModel {
    public static final ModelLayerLocation ANCIENT_BOAT = new ModelLayerLocation(new ResourceLocation("immortalers_delight", "ancient_wood_boat"), "main");
    private static final String PADDLE_LEFT = "paddle_left";
    private static final String PADDLE_RIGHT = "paddle_right";
    private static final String WATER_PATCH = "water_patch";
    private static final String BOTTOM = "bottom";
    private static final String BACK = "back";
    private static final String FRONT = "front";
    private static final String RIGHT = "right";
    private static final String LEFT = "left";
    private final ModelPart leftPaddle;
    private final ModelPart rightPaddle;
    private final ModelPart waterPatch;
    private final ImmutableList<ModelPart> parts;

    public AncientWoodBoatModel(ModelPart pRoot) {
        this.leftPaddle = pRoot.m_171324_(PADDLE_LEFT);
        this.rightPaddle = pRoot.m_171324_(PADDLE_RIGHT);
        this.waterPatch = pRoot.m_171324_(WATER_PATCH);
        this.parts = this.createPartsBuilder(pRoot).build();
    }

    protected ImmutableList.Builder<ModelPart> createPartsBuilder(ModelPart pRoot) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.add((Object[])new ModelPart[]{pRoot.m_171324_(BOTTOM), pRoot.m_171324_(BACK), pRoot.m_171324_(FRONT), pRoot.m_171324_(RIGHT), pRoot.m_171324_(LEFT), this.leftPaddle, this.rightPaddle});
        return builder;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition bottom = partdefinition.m_171599_(BOTTOM, CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-32.0f, -8.0f, 0.5f, 64.0f, 16.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(48, 114).m_171488_(-19.0f, -6.0f, -1.5f, 38.0f, 12.0f, 2.0f, new CubeDeformation(0.05f)), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition front = partdefinition.m_171599_(FRONT, CubeListBuilder.m_171558_().m_171514_(0, 76).m_171488_(-11.0f, -3.0f, -10.0f, 22.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 51).m_171488_(-12.0f, -3.0f, 8.0f, 24.0f, 2.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)15.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition front_r1 = front.m_171599_("front_r1", CubeListBuilder.m_171558_().m_171514_(0, 66).m_171488_(-12.0f, -4.0f, -1.0f, 24.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)19.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition back = partdefinition.m_171599_(BACK, CubeListBuilder.m_171558_().m_171514_(74, 70).m_171488_(-11.0f, -3.0f, 0.0f, 22.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(74, 51).m_171488_(-12.0f, -3.0f, 14.0f, 24.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-15.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition back_r1 = back.m_171599_("back_r1", CubeListBuilder.m_171558_().m_171514_(74, 60).m_171488_(-15.0f, -5.0f, -1.0f, 24.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)1.0f, (float)18.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition right = partdefinition.m_171599_(RIGHT, CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-39.0f, -4.0f, 2.0f, 78.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)-9.0f, (float)0.0f, (float)-3.1416f, (float)0.0f));
        PartDefinition right_r1 = right.m_171599_("right_r1", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-56.0f, -5.0f, -1.0f, 70.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)21.0f, (float)1.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition left = partdefinition.m_171599_(LEFT, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-39.0f, -4.0f, 2.0f, 78.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)9.0f));
        PartDefinition left_r1 = left.m_171599_("left_r1", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171488_(-56.0f, -5.0f, -1.0f, 70.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)21.0f, (float)1.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition paddle_left = partdefinition.m_171599_(PADDLE_LEFT, CubeListBuilder.m_171558_().m_171514_(200, 28).m_171488_(-1.0f, -1.0f, -13.0f, 2.0f, 2.0f, 26.0f, new CubeDeformation(0.0f)).m_171514_(170, 28).m_171488_(-0.01f, -4.0f, 9.0f, 1.0f, 6.0f, 14.0f, new CubeDeformation(0.1f)), PartPose.m_171423_((float)-13.5f, (float)-8.0f, (float)15.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition paddle_right = partdefinition.m_171599_(PADDLE_RIGHT, CubeListBuilder.m_171558_().m_171514_(200, 0).m_171488_(-1.0f, -1.0f, -13.0f, 2.0f, 2.0f, 26.0f, new CubeDeformation(0.0f)).m_171514_(170, 0).m_171488_(-0.99f, -4.0f, 9.0f, 1.0f, 6.0f, 14.0f, new CubeDeformation(0.1f)), PartPose.m_171423_((float)-13.5f, (float)-8.0f, (float)-15.0f, (float)-0.5236f, (float)3.1416f, (float)0.0f));
        PartDefinition water_patch = partdefinition.m_171599_(WATER_PATCH, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-32.0f, -10.0f, -3.0f, 64.0f, 20.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)1.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void setupAnim(Boat pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        AncientWoodBoatModel.animatePaddle(pEntity, 0, this.leftPaddle, pLimbSwing);
        AncientWoodBoatModel.animatePaddle(pEntity, 1, this.rightPaddle, pLimbSwing);
    }

    public ImmutableList<ModelPart> parts() {
        return this.parts;
    }

    public ModelPart m_102282_() {
        return this.waterPatch;
    }

    private static void animatePaddle(Boat pBoat, int pSide, ModelPart pPaddle, float pLimbSwing) {
        float f = pBoat.m_38315_(pSide, pLimbSwing);
        pPaddle.f_104203_ = Mth.m_144920_((float)-1.0471976f, (float)-0.2617994f, (float)((Mth.m_14031_((float)(-f)) + 1.0f) / 2.0f));
        pPaddle.f_104204_ = Mth.m_144920_((float)-0.7853982f, (float)0.7853982f, (float)((Mth.m_14031_((float)(-f + 1.0f)) + 1.0f) / 2.0f));
        if (pSide == 1) {
            pPaddle.f_104204_ = (float)Math.PI - pPaddle.f_104204_;
        }
    }
}

