/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.entities.ai;

import com.renyigesai.immortalers_delight.entities.living.SkelverfishThrasher;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import org.jetbrains.annotations.NotNull;

public class SkelverfishThrasherAttackGoal
extends MeleeAttackGoal {
    private final int ANIMATION_DURATION = 10;
    private final int ATTACK_DELAY = 3;
    private final int ATTACK_INTERVAL = 20;
    private final SkelverfishThrasher entity;
    private int attackTimer = 0;
    private boolean shouldCountAttackTiming = false;
    private int cooldown = 20;
    private boolean shouldCountTillNextAttack = false;

    public SkelverfishThrasherAttackGoal(PathfinderMob pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
        super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        this.entity = (SkelverfishThrasher)pMob;
    }

    public void m_8056_() {
        super.m_8056_();
        this.attackTimer = 0;
        this.cooldown = 3;
        this.f_25540_.m_21561_(false);
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.shouldCountTillNextAttack) {
            int n = this.cooldown = this.cooldown - 1 > 0 ? this.cooldown - 1 : 0;
        }
        if (this.shouldCountAttackTiming) {
            if (this.attackTimer != 10) {
                this.attackTimer = this.attackTimer + 1 > 10 ? 10 : this.attackTimer + 1;
            } else {
                this.shouldCountAttackTiming = false;
                this.attackTimer = 0;
                this.entity.m_21561_(false);
            }
        }
    }

    public void m_8041_() {
        super.m_8041_();
        this.entity.m_21561_(false);
    }

    protected void m_6739_(@NotNull LivingEntity target, double squaredDistance) {
        if (this.isEnemyWithinAttackDistanse(target, squaredDistance)) {
            this.shouldCountTillNextAttack = true;
            if (this.isTimeToStartAttackAnimation()) {
                this.entity.m_21561_(true);
                this.shouldCountAttackTiming = true;
            }
            if (this.delayedEnough()) {
                this.f_25540_.m_21563_().m_24946_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                this.preformAttack(target);
                this.resetAttackCoolDown();
            }
        } else {
            this.resetAttackCoolDown();
            this.shouldCountTillNextAttack = false;
        }
    }

    private void resetAttackCoolDown() {
        this.cooldown = this.m_183277_(20);
    }

    private void preformAttack(LivingEntity target) {
        this.resetAttackCoolDown();
        this.f_25540_.m_6674_(InteractionHand.MAIN_HAND);
        this.f_25540_.m_7327_((Entity)target);
    }

    private boolean delayedEnough() {
        return this.attackTimer == 3;
    }

    private boolean isTimeToStartAttackAnimation() {
        return this.cooldown <= 0;
    }

    private boolean isEnemyWithinAttackDistanse(LivingEntity target, double squaredDistance) {
        return squaredDistance <= this.m_6639_(target);
    }

    protected double m_6639_(@NotNull LivingEntity pAttackTarget) {
        return 4.0 + super.m_6639_(pAttackTarget) + (double)pAttackTarget.m_20205_();
    }
}

