/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.event;

import com.renyigesai.immortalers_delight.Config;
import com.renyigesai.immortalers_delight.api.mobbase.ImmortalersMob;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightMobEffect;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightTags;
import com.renyigesai.immortalers_delight.util.DifficultyModeUtil;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DifficultyModeEventHelper {
    private static final Map<UUID, Float> entityWithMinDamage = new ConcurrentHashMap<UUID, Float>();

    @SubscribeEvent
    public static void ImmortalrsMobAttackProgressDamage(LivingHurtEvent event) {
        LivingEntity hurtOne = event.getEntity();
        if (!hurtOne.m_9236_().f_46443_) {
            Entity entity = event.getSource().m_7639_();
            if (entity instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)entity;
                if (DifficultyModeUtil.isPowerBattleMode() && Config.powerBattleModeStrengthenTheEnemies && (attacker.m_6095_().m_204039_(ImmortalersDelightTags.IMMORTAL_NORMAL_MOBS) || attacker.m_6095_().m_204039_(ImmortalersDelightTags.IMMORTAL_ELITE_MOBS) || attacker.m_6095_().m_204039_(ImmortalersDelightTags.IMMORTAL_MINI_BOSS))) {
                    float oldDamage = event.getAmount();
                    float buffer = Math.min(3.0f, 1.0f + hurtOne.m_21233_() * 0.02f);
                    event.setAmount(Math.max(oldDamage * buffer, 0.0f));
                }
                if (attacker.m_9236_().m_46791_().m_19028_() >= 3) {
                    event.setAmount(event.getAmount() * 1.25f);
                }
            }
            if ((hurtOne.m_6095_().m_204039_(ImmortalersDelightTags.IMMORTAL_NORMAL_MOBS) || hurtOne.m_6095_().m_204039_(ImmortalersDelightTags.IMMORTAL_ELITE_MOBS) || hurtOne.m_6095_().m_204039_(ImmortalersDelightTags.IMMORTAL_MINI_BOSS)) && hurtOne.m_9236_().m_46791_().m_19028_() >= 3) {
                event.setAmount(event.getAmount() * 0.8f);
            }
        }
    }

    @SubscribeEvent
    public static void ImmortalrsMobAttackMinDamage(LivingAttackEvent event) {
        Entity entity;
        if (DifficultyModeUtil.isPowerBattleMode() && Config.powerBattleModeStrengthenTheEnemies && (entity = event.getSource().m_7639_()) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            if (!attacker.m_9236_().f_46443_) {
                ImmortalersMob immMob;
                float damageProgress;
                LivingEntity hurtOne = event.getEntity();
                if (hurtOne.m_21223_() < 1.0f) {
                    return;
                }
                float minDamage = event.getAmount() * 0.2f;
                if (hurtOne.m_21023_((MobEffect)ImmortalersDelightMobEffect.VULNERABLE.get())) {
                    int amplifier = Objects.requireNonNull(hurtOne.m_21124_((MobEffect)ImmortalersDelightMobEffect.VULNERABLE.get())).m_19564_();
                    minDamage *= (float)(amplifier + 2);
                }
                boolean needMinDamage = false;
                if (attacker.m_6095_().m_204039_(ImmortalersDelightTags.IMMORTAL_NORMAL_MOBS)) {
                    damageProgress = 0.0f;
                    if (attacker instanceof ImmortalersMob) {
                        immMob = (ImmortalersMob)attacker;
                        damageProgress = immMob.getAttackProportion();
                        minDamage += hurtOne.m_21233_() * damageProgress;
                    }
                    needMinDamage = true;
                }
                if (attacker.m_6095_().m_204039_(ImmortalersDelightTags.IMMORTAL_ELITE_MOBS)) {
                    float buffer;
                    damageProgress = 0.05f;
                    if (attacker instanceof ImmortalersMob) {
                        immMob = (ImmortalersMob)attacker;
                        damageProgress = immMob.getAttackProportion();
                    }
                    if (attacker.m_21133_(Attributes.f_22281_) > 0.0 && (buffer = (float)((double)event.getAmount() / attacker.m_21133_(Attributes.f_22281_))) < 1.0f) {
                        damageProgress *= buffer;
                    }
                    minDamage += hurtOne.m_21233_() * damageProgress;
                    needMinDamage = true;
                }
                if (attacker.m_6095_().m_204039_(ImmortalersDelightTags.IMMORTAL_MINI_BOSS)) {
                    damageProgress = 0.05f;
                    if (attacker instanceof ImmortalersMob) {
                        immMob = (ImmortalersMob)attacker;
                        damageProgress = immMob.getAttackProportion();
                    }
                    if (attacker.m_21133_(Attributes.f_22281_) > 0.0) {
                        float buffer = (float)((double)event.getAmount() / attacker.m_21133_(Attributes.f_22281_));
                        damageProgress *= buffer;
                    }
                    minDamage += hurtOne.m_21233_() * damageProgress;
                    needMinDamage = true;
                }
                if (needMinDamage) {
                    hurtOne.m_21153_(Math.max(hurtOne.m_21223_() - minDamage, 0.01f));
                }
            }
        }
    }

    @SubscribeEvent
    public static void ImmortalrsMobHurtDamageDecay(LivingDamageEvent event) {
        if (DifficultyModeUtil.isPowerBattleMode() && Config.powerBattleModeStrengthenTheEnemies) {
            LivingEntity hurtOne = event.getEntity();
            if (!hurtOne.m_9236_().f_46443_) {
                ImmortalersMob immMob;
                float oldDamage;
                float damage = oldDamage = event.getAmount();
                float damageDivisor = 0.0f;
                boolean needLimitDamage = false;
                if (hurtOne.m_6095_().m_204039_(ImmortalersDelightTags.IMMORTAL_NORMAL_MOBS)) {
                    damageDivisor = 0.04f;
                    if (hurtOne instanceof ImmortalersMob) {
                        immMob = (ImmortalersMob)hurtOne;
                        damageDivisor = immMob.getDamageDivisor();
                    }
                    if (oldDamage > 100.0f * damageDivisor) {
                        float buffer = Math.min(7.0f, 1.0f + damageDivisor * (oldDamage - 100.0f * damageDivisor));
                        damage = oldDamage / buffer;
                        needLimitDamage = true;
                    }
                }
                if (hurtOne.m_6095_().m_204039_(ImmortalersDelightTags.IMMORTAL_ELITE_MOBS)) {
                    damageDivisor = 0.05f;
                    if (hurtOne instanceof ImmortalersMob) {
                        immMob = (ImmortalersMob)hurtOne;
                        damageDivisor = immMob.getDamageDivisor();
                    }
                    if (oldDamage > 100.0f * damageDivisor) {
                        float buffer = Math.min(11.0f, 1.0f + damageDivisor * (oldDamage - 100.0f * damageDivisor));
                        damage = oldDamage / buffer;
                        needLimitDamage = true;
                    }
                }
                if (hurtOne.m_6095_().m_204039_(ImmortalersDelightTags.IMMORTAL_MINI_BOSS)) {
                    damageDivisor = 0.08f;
                    if (hurtOne instanceof ImmortalersMob) {
                        ImmortalersMob immMob2 = (ImmortalersMob)hurtOne;
                        damageDivisor = immMob2.getDamageDivisor();
                    }
                    if (oldDamage > 100.0f * damageDivisor) {
                        float buffer = Math.min(15.0f, 1.0f + damageDivisor * (oldDamage - 100.0f * damageDivisor));
                        damage = oldDamage / buffer;
                        needLimitDamage = true;
                    }
                }
                if (needLimitDamage) {
                    event.setAmount(damage);
                }
            }
        }
    }
}

