/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.renyigesai.immortalers_delight.client.model.BoneKnifeBakedModel;
import com.renyigesai.immortalers_delight.client.renderer.special_item.BoneKnifeItemRenderer;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightItems;
import com.renyigesai.immortalers_delight.item.ImmortalersKnifeItem;
import com.renyigesai.immortalers_delight.util.DifficultyModeUtil;
import com.renyigesai.immortalers_delight.util.task.TimekeepingTask;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

public class BoneKnifeItem
extends ImmortalersKnifeItem {
    public static final String TAG_USE_TIME = "UseTime";
    public static final String TAG_PREV_USE_TIME = "PrevUseTime";
    private static final Map<UUID, Long> entityLastUsed = new ConcurrentHashMap<UUID, Long>();

    public BoneKnifeItem(int type, Tier tier, float attackDamage, float attackSpeed, Item.Properties properties) {
        super(type, tier, attackDamage, attackSpeed, properties);
    }

    public BoneKnifeItem(int type, Tier tier, float attackDamage, float attackSpeed, float extra_attackDamage, float extra_attackSpeed, Item.Properties properties) {
        super(type, tier, attackDamage, attackSpeed, extra_attackDamage, extra_attackSpeed, properties);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        boolean isPowerful = DifficultyModeUtil.isPowerBattleMode();
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            int maxLoadTime;
            float baseDamage = this.attackDamage + (isPowerful ? this.extra_attackDamage : 0.0f);
            int useTime = BoneKnifeItem.getUseTime(stack);
            float buffer = 1.0f + Math.min((float)useTime / (float)(maxLoadTime = BoneKnifeItem.getMaxLoadTime()), 1.0f);
            double damage = buffer > 1.5f ? (double)((baseDamage + (buffer > 1.8f ? 0.5f : -0.5f)) * buffer) : (double)baseDamage;
            multimap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)this.attackSpeed + (double)(isPowerful ? this.extra_attackSpeed : 0.0f), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", damage, AttributeModifier.Operation.ADDITION));
            return multimap;
        }
        return super.m_7167_(equipmentSlot);
    }

    public float m_41008_() {
        boolean isPowerful = DifficultyModeUtil.isPowerBattleMode();
        return this.attackDamage + (isPowerful ? this.extra_attackDamage : 0.0f);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        boolean b = super.onLeftClickEntity(stack, player, entity);
        int useTime = BoneKnifeItem.getUseTime(stack);
        if (!b && (float)useTime > 0.0f) {
            BoneKnifeItem.setUseTime(stack, 0);
        }
        return b;
    }

    public boolean m_7579_(@NotNull ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        boolean b = super.m_7579_(stack, target, attacker);
        entityLastUsed.put(attacker.m_20148_(), TimekeepingTask.getImmortalTickTime());
        return b;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int i, boolean held) {
        LivingEntity living;
        super.m_6883_(stack, level, entity, i, held);
        boolean var10000 = entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21120_(InteractionHand.MAIN_HAND) == stack;
        boolean holding = var10000;
        int useTime = BoneKnifeItem.getUseTime(stack);
        if (level.m_5776_()) {
            CompoundTag tag = stack.m_41784_();
            if (tag.m_128451_(TAG_PREV_USE_TIME) != tag.m_128451_(TAG_USE_TIME)) {
                tag.m_128405_(TAG_PREV_USE_TIME, BoneKnifeItem.getUseTime(stack));
            }
            int maxLoadTime = BoneKnifeItem.getMaxLoadTime();
            if (holding && useTime < maxLoadTime) {
                int set = useTime + 1;
                BoneKnifeItem.setUseTime(stack, set);
            }
        }
        if (!holding && (float)useTime > 0.0f) {
            BoneKnifeItem.setUseTime(stack, Math.max(0, useTime - 5));
        }
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new BoneKnifeItemRenderer();
            }
        });
    }

    private static int getMaxLoadTime() {
        return 20;
    }

    public static int getUseTime(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        return compoundtag != null ? compoundtag.m_128451_(TAG_USE_TIME) : 0;
    }

    public static void setUseTime(ItemStack stack, int useTime) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_(TAG_PREV_USE_TIME, BoneKnifeItem.getUseTime(stack));
        tag.m_128405_(TAG_USE_TIME, useTime);
    }

    public static float getLerpedUseTime(ItemStack stack, float f) {
        CompoundTag compoundtag = stack.m_41783_();
        float prev = compoundtag != null ? (float)compoundtag.m_128451_(TAG_PREV_USE_TIME) : 0.0f;
        float current = compoundtag != null ? (float)compoundtag.m_128451_(TAG_USE_TIME) : 0.0f;
        return prev + f * (current - prev);
    }

    public static float getPullingAmount(ItemStack itemStack, float partialTicks) {
        if (BoneKnifeItem.getLerpedUseTime(itemStack, partialTicks) > 0.0f) {
            return Math.min(BoneKnifeItem.getLerpedUseTime(itemStack, partialTicks) / (float)BoneKnifeItem.getMaxLoadTime(), 1.0f);
        }
        return 0.0f;
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientEventBus {
        @SubscribeEvent
        public static void onModelBaked(ModelEvent.ModifyBakingResult event) {
            ModelResourceLocation location;
            Map modelRegistry = event.getModels();
            BakedModel existingModel = (BakedModel)modelRegistry.get(location = new ModelResourceLocation(BuiltInRegistries.f_257033_.m_7981_((Object)((Item)ImmortalersDelightItems.BONE_KNIFE.get())), "inventory"));
            if (existingModel == null) {
                throw new RuntimeException("Did not find Obsidian Hidden in registry");
            }
            if (existingModel instanceof BoneKnifeBakedModel) {
                throw new RuntimeException("Tried to replaceObsidian Hidden twice");
            }
            BoneKnifeBakedModel obsidianWrenchBakedModel = new BoneKnifeBakedModel(existingModel);
            event.getModels().put(location, obsidianWrenchBakedModel);
        }
    }

    @Mod.EventBusSubscriber(modid="immortalers_delight", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class BoneKnifeEvents {
        @SubscribeEvent
        public static void BoneKnifeAttack(LivingHurtEvent event) {
            Item item;
            LivingEntity attacker;
            ItemStack toolStack;
            if (event.isCanceled()) {
                return;
            }
            boolean isPowerful = DifficultyModeUtil.isPowerBattleMode();
            LivingEntity hurtOne = event.getEntity();
            if (hurtOne.m_9236_().f_46443_) {
                return;
            }
            Entity entity = event.getSource().m_7639_();
            if (entity instanceof LivingEntity && !(toolStack = (attacker = (LivingEntity)entity).m_21120_(InteractionHand.MAIN_HAND)).m_41619_() && (item = toolStack.m_41720_()) instanceof BoneKnifeItem) {
                BoneKnifeItem knife = (BoneKnifeItem)item;
                if (entityLastUsed.containsKey(attacker.m_20148_())) {
                    long lastUsedTime = entityLastUsed.get(attacker.m_20148_());
                    float buffer = 1.0f + Math.min((float)(TimekeepingTask.getImmortalTickTime() - lastUsedTime) / (float)BoneKnifeItem.getMaxLoadTime() * 50.0f, 1.0f);
                    float damage = buffer > 1.5f ? (event.getAmount() + (buffer > 1.8f ? 0.5f : 0.0f)) * buffer : event.getAmount();
                    event.setAmount(Math.min(event.getAmount() + 1.5f * knife.m_41008_(), damage));
                }
            }
        }
    }
}

