/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.item;

import com.renyigesai.immortalers_delight.item.ImmortalersHammerItem;
import com.renyigesai.immortalers_delight.screen.GrindstoneWithNoBlockMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class GrindstoneHammerItem
extends ImmortalersHammerItem {
    private static final Component CONTAINER_TITLE = Component.m_237115_((String)"container.grindstone_title");

    public GrindstoneHammerItem(Tier pTier, float pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
    }

    public GrindstoneHammerItem(int type, Tier pTier, float pAttackDamageModifier, float pAttackSpeedModifier, float pExtraAttackDamage, float pExtraAttackSpeed, Item.Properties pProperties) {
        super(type, pTier, pAttackDamageModifier, pAttackSpeedModifier, pExtraAttackDamage, pExtraAttackSpeed, pProperties);
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack pStack) {
        return 7200;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext pContext) {
        Player player = pContext.m_43723_();
        HitResult hitResult = this.calculateHitResult((LivingEntity)player);
        if (player != null && hitResult.m_6662_() == HitResult.Type.BLOCK) {
            if (player.m_9236_().m_8055_(pContext.m_8083_()).m_60734_() instanceof BaseEntityBlock) {
                return InteractionResult.PASS;
            }
            player.m_6672_(pContext.m_43724_());
        }
        return InteractionResult.CONSUME;
    }

    public InteractionResult m_6880_(ItemStack pStack, Player pPlayer, LivingEntity pInteractionTarget, InteractionHand pUsedHand) {
        if (this.calculateHitResult((LivingEntity)pPlayer).m_6662_() == HitResult.Type.ENTITY) {
            pPlayer.m_6672_(pUsedHand);
        }
        return InteractionResult.CONSUME;
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int time) {
        super.m_5929_(level, entity, stack, time);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int time) {
        Player player;
        HitResult hitresult;
        if (time < this.m_8105_(stack) - 32 && entity instanceof Player && (hitresult = this.calculateHitResult((LivingEntity)(player = (Player)entity))).m_6662_() == HitResult.Type.BLOCK && hitresult instanceof BlockHitResult) {
            BlockHitResult blockhitresult = (BlockHitResult)hitresult;
            BlockPos pos = blockhitresult.m_82425_();
            ItemStack heldStack = player.m_21211_();
            Item item = heldStack.m_41720_();
            if (item instanceof GrindstoneHammerItem) {
                GrindstoneHammerItem thisHammer = (GrindstoneHammerItem)item;
                if (!player.m_9236_().m_5776_()) {
                    stack.m_41622_(2, (LivingEntity)player, p_289501_ -> p_289501_.m_21190_(player.m_7655_()));
                    player.m_5893_(thisHammer.getMenuProvider(player.m_9236_(), pos));
                    player.m_36220_(Stats.f_12952_);
                }
            }
        }
    }

    public MenuProvider getMenuProvider(Level pLevel, BlockPos pPos) {
        return new SimpleMenuProvider((p_53812_, p_53813_, p_53814_) -> new GrindstoneWithNoBlockMenu(p_53812_, p_53813_, ContainerLevelAccess.m_39289_((Level)pLevel, (BlockPos)pPos)), CONTAINER_TITLE);
    }

    private HitResult calculateHitResult(LivingEntity pEntity) {
        return ProjectileUtil.m_278180_((Entity)pEntity, p_281111_ -> !p_281111_.m_5833_() && p_281111_.m_6087_(), (double)(Math.sqrt(ServerGamePacketListenerImpl.f_215198_) - 1.0));
    }
}

