/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.item;

import com.google.common.collect.Sets;
import com.renyigesai.immortalers_delight.item.ImmortalersKnifeItem;
import com.renyigesai.immortalers_delight.util.DifficultyModeUtil;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class PillagersKnifeItem
extends ImmortalersKnifeItem {
    public static final String MAX_POTION_COUNT = "potion_coating_count";
    public static final String USED_POTION_COUNT = "pillagers_knife_attack_count";

    public PillagersKnifeItem(int type, Tier tier, float attackDamage, float attackSpeed, Item.Properties properties) {
        super(type, tier, attackDamage, attackSpeed, properties);
    }

    public PillagersKnifeItem(int type, Tier tier, float attackDamage, float attackSpeed, float extra_attackDamage, float extra_attackSpeed, Item.Properties properties) {
        super(type, tier, attackDamage, attackSpeed, extra_attackDamage, extra_attackSpeed, properties);
    }

    @NotNull
    public ItemStack m_7968_() {
        return PotionUtils.m_43549_((ItemStack)super.m_7968_(), (Potion)Potions.f_43584_);
    }

    @Override
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        if (pStack.m_41784_().m_128441_(MAX_POTION_COUNT) && pStack.m_41784_().m_128451_(MAX_POTION_COUNT) > 0) {
            int max = pStack.m_41784_().m_128451_(MAX_POTION_COUNT);
            int progress = max - (pStack.m_41784_().m_128441_(USED_POTION_COUNT) ? pStack.m_41784_().m_128451_(USED_POTION_COUNT) : 0);
            MutableComponent textValue = Component.m_237110_((String)"tooltip.immortalers_delight.potion_coating_count", (Object[])new Object[]{progress, max});
            pTooltip.add((Component)textValue.m_130940_(ChatFormatting.YELLOW));
        }
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            MutableComponent textEmpty = TextUtils.getTranslation((String)("tooltip." + this), (Object[])new Object[0]);
            pTooltip.add((Component)textEmpty.m_130940_(ChatFormatting.DARK_PURPLE));
            PotionUtils.m_43555_((ItemStack)pStack, pTooltip, (float)0.125f);
        }
        if (this.type_id == 3) {
            MutableComponent textEmpty = TextUtils.getTranslation((String)("tooltip." + this + ".default_enchantment." + (Serializable)(DifficultyModeUtil.isPowerBattleMode() ? "power.1" : Integer.valueOf(1))), (Object[])new Object[0]);
            pTooltip.add((Component)textEmpty.m_130940_(ChatFormatting.GRAY));
        }
        super.m_7373_(pStack, pLevel, pTooltip, pFlag);
    }

    public boolean m_7579_(@NotNull ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        CompoundTag tag;
        int damageCount = stack.m_41773_();
        boolean b = super.m_7579_(stack, target, attacker);
        if (b && !target.m_9236_().m_5776_() && stack.m_41773_() != damageCount && (PotionUtils.m_43577_((CompoundTag)(tag = stack.m_41784_())) != Potions.f_43598_ || PotionUtils.m_43571_((ItemStack)stack).size() > 0)) {
            if (!tag.m_128441_(MAX_POTION_COUNT)) {
                tag.m_128405_(MAX_POTION_COUNT, 8);
            }
            if (tag.m_128441_(USED_POTION_COUNT)) {
                int count = tag.m_128451_(USED_POTION_COUNT);
                tag.m_128405_(USED_POTION_COUNT, count + 1);
                if (count >= tag.m_128451_(MAX_POTION_COUNT)) {
                    stack.m_41749_(USED_POTION_COUNT);
                    stack.m_41749_(MAX_POTION_COUNT);
                    PotionUtils.m_43549_((ItemStack)stack, (Potion)Potions.f_43598_);
                    stack.m_41749_("CustomPotionEffects");
                }
            } else {
                tag.m_128405_(USED_POTION_COUNT, 1);
            }
        }
        return b;
    }

    @Mod.EventBusSubscriber(modid="immortalers_delight", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ImmortalersKnifeEvents {
        @SubscribeEvent
        public static void PillagersKnifeAttack(LivingHurtEvent event) {
            Item item;
            LivingEntity attacker;
            ItemStack stack;
            if (event.isCanceled()) {
                return;
            }
            boolean isPowerful = DifficultyModeUtil.isPowerBattleMode();
            LivingEntity target = event.getEntity();
            if (target.m_9236_().f_46443_) {
                return;
            }
            Entity entity = event.getSource().m_7639_();
            if (entity instanceof LivingEntity && !(stack = (attacker = (LivingEntity)entity).m_21120_(InteractionHand.MAIN_HAND)).m_41619_() && (item = stack.m_41720_()) instanceof PillagersKnifeItem) {
                PillagersKnifeItem knife = (PillagersKnifeItem)item;
                Potion potion = Potions.f_43598_;
                HashSet effects = Sets.newHashSet();
                potion = PotionUtils.m_43579_((ItemStack)stack);
                List collection = PotionUtils.m_43571_((ItemStack)stack);
                if (!collection.isEmpty()) {
                    for (MobEffectInstance mobeffectinstance : collection) {
                        effects.add(new MobEffectInstance(mobeffectinstance));
                    }
                }
                for (MobEffectInstance mobeffectinstance : potion.m_43488_()) {
                    target.m_147207_(new MobEffectInstance(mobeffectinstance.m_19544_(), Math.max(mobeffectinstance.m_267696_(p_268168_ -> p_268168_ / 8), 1), mobeffectinstance.m_19564_(), mobeffectinstance.m_19571_(), mobeffectinstance.m_19572_()), (Entity)attacker);
                    if (!mobeffectinstance.m_19544_().m_8093_()) continue;
                    target.f_19802_ = 0;
                }
                if (!effects.isEmpty()) {
                    for (MobEffectInstance mobeffectinstance1 : effects) {
                        target.m_147207_(mobeffectinstance1, (Entity)attacker);
                        if (!mobeffectinstance1.m_19544_().m_8093_()) continue;
                        target.f_19802_ = 0;
                    }
                }
            }
        }
    }
}

