/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.potion;

import com.mojang.datafixers.util.Pair;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightMobEffect;
import com.renyigesai.immortalers_delight.util.DifficultyModeUtil;
import java.util.List;
import java.util.Objects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class IncandescencePotionEffect {
    @SubscribeEvent
    public static void onUseItemFinish(LivingEntityUseItemEvent.Finish event) {
        if (event != null && event.getEntity() != null) {
            ItemStack stack = event.getResultStack();
            LivingEntity entity = event.getEntity();
            if (stack.m_41720_().m_41472_() && entity.m_21023_((MobEffect)ImmortalersDelightMobEffect.INCANDESCENCE.get()) && IncandescencePotionEffect.noIncandescenceFood(stack, entity)) {
                int lv = entity.m_21023_((MobEffect)ImmortalersDelightMobEffect.INCANDESCENCE.get()) ? entity.m_21124_((MobEffect)ImmortalersDelightMobEffect.INCANDESCENCE.get()).m_19564_() : 0;
                int time = entity.m_21023_(MobEffects.f_19600_) ? entity.m_21124_(MobEffects.f_19600_).m_19557_() : 0;
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19600_, time + 100, lv));
            }
        }
    }

    @SubscribeEvent
    public static void onCreatureHurt(LivingHurtEvent evt) {
        if (evt.isCanceled() || evt.getSource().m_269533_(DamageTypeTags.f_268630_)) {
            return;
        }
        LivingEntity hurtOne = evt.getEntity();
        LivingEntity attacker = null;
        boolean isPowerful = DifficultyModeUtil.isPowerBattleMode();
        Entity entity = evt.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity;
            attacker = livingEntity = (LivingEntity)entity;
        }
        if (!hurtOne.m_9236_().f_46443_ && attacker != null && isPowerful && attacker.m_21023_((MobEffect)ImmortalersDelightMobEffect.INCANDESCENCE.get())) {
            if (hurtOne.m_21023_(MobEffects.f_19607_)) {
                hurtOne.m_21195_(MobEffects.f_19607_);
            }
            int lv = attacker.m_21124_((MobEffect)ImmortalersDelightMobEffect.INCANDESCENCE.get()).m_19564_();
            hurtOne.m_7311_((lv + 1) * 700 - 200);
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                FoodData foodData = player.m_36324_();
                if (foodData.m_38722_() >= 1.0f) {
                    foodData.m_38717_(foodData.m_38722_() - 1.0f);
                } else if (foodData.m_38702_() >= 1) {
                    foodData.m_38705_(foodData.m_38702_() - 1);
                }
            }
        }
    }

    public static boolean noIncandescenceFood(ItemStack stack, LivingEntity entity) {
        List effects = Objects.requireNonNull(stack.getFoodProperties(entity)).m_38749_();
        for (Pair effect : effects) {
            if (((MobEffectInstance)effect.getFirst()).m_19544_() != ImmortalersDelightMobEffect.INCANDESCENCE.get()) continue;
            return false;
        }
        return true;
    }
}

