/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.potion;

import com.renyigesai.immortalers_delight.init.ImmortalersDelightMobEffect;
import com.renyigesai.immortalers_delight.util.DifficultyModeUtil;
import com.renyigesai.immortalers_delight.util.task.TimekeepingTask;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

public class VulnerableMobEffect
extends MobEffect {
    private static boolean needClear = false;
    private static final Map<UUID, Byte> entitiesWithFrequencyLimit = new ConcurrentHashMap<UUID, Byte>();

    public static void isNeedClear(boolean pFirst) {
        needClear = pFirst;
    }

    public static boolean isVulnerableHasLimit(LivingEntity entity) {
        return entitiesWithFrequencyLimit.containsKey(entity.m_20148_());
    }

    public static void addVulnerableEntityWithFrequencyLimit(LivingEntity entity, Byte frequencyLimit) {
        entitiesWithFrequencyLimit.put(entity.m_20148_(), frequencyLimit);
    }

    public static void removeVulnerableEntityWithFrequencyLimit(LivingEntity entity) {
        entitiesWithFrequencyLimit.remove(entity.m_20148_());
    }

    public static Map<UUID, Byte> getEntitiesWithFrequencyLimit() {
        return entitiesWithFrequencyLimit;
    }

    public VulnerableMobEffect() {
        super(MobEffectCategory.HARMFUL, 11457405);
    }

    public static void addEffectWithFrequencyLimit(LivingEntity entity, MobEffectInstance effect, Byte frequencyLimit) {
        if (entity != null && !entity.m_9236_().m_5776_() && entity.m_6084_()) {
            VulnerableMobEffect.addVulnerableEntityWithFrequencyLimit(entity, frequencyLimit);
            entity.m_7292_(effect);
        }
    }

    public static void removeEffectWithFrequencyLimit(LivingEntity entity, MobEffect effect) {
        if (entity != null && !entity.m_9236_().m_5776_() && entity.m_6084_()) {
            VulnerableMobEffect.removeVulnerableEntityWithFrequencyLimit(entity);
            entity.m_21195_(effect);
        }
    }

    public void m_6386_(@NotNull LivingEntity pLivingEntity, @NotNull AttributeMap pAttributeMap, int pAmplifier) {
        if (pLivingEntity.m_9236_().f_46443_ || !entitiesWithFrequencyLimit.containsKey(pLivingEntity.m_20148_())) {
            super.m_6386_(pLivingEntity, pAttributeMap, pAmplifier);
            return;
        }
        if (pLivingEntity.m_6084_()) {
            VulnerableMobEffect.removeVulnerableEntityWithFrequencyLimit(pLivingEntity);
        }
        super.m_6386_(pLivingEntity, pAttributeMap, pAmplifier);
    }

    public void m_6385_(@NotNull LivingEntity pLivingEntity, @NotNull AttributeMap pAttributeMap, int pAmplifier) {
        if (pLivingEntity.m_9236_().f_46443_ || entitiesWithFrequencyLimit.containsKey(pLivingEntity.m_20148_())) {
            super.m_6385_(pLivingEntity, pAttributeMap, pAmplifier);
            return;
        }
        if (pLivingEntity.m_6084_()) {
            boolean isPowerful = DifficultyModeUtil.isPowerBattleMode();
            int lv = isPowerful || pAmplifier >= 255 ? 255 : pAmplifier + 1;
            VulnerableMobEffect.addVulnerableEntityWithFrequencyLimit(pLivingEntity, (byte)lv);
        }
        super.m_6385_(pLivingEntity, pAttributeMap, pAmplifier);
    }

    public void m_6742_(@NotNull LivingEntity pLivingEntity, int pAmplifier) {
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    @Mod.EventBusSubscriber(modid="immortalers_delight", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class VulnerablePotionEffect {
        @SubscribeEvent
        public static void onCreatureHurt(LivingHurtEvent evt) {
            if (evt.isCanceled() || evt.getSource().m_269533_(DamageTypeTags.f_268437_)) {
                return;
            }
            LivingEntity hurtOne = evt.getEntity();
            LivingEntity attacker = null;
            boolean isPowerful = DifficultyModeUtil.isPowerBattleMode();
            Entity entity = evt.getSource().m_7639_();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity;
                attacker = livingEntity = (LivingEntity)entity;
            }
            if (!hurtOne.m_9236_().f_46443_ && attacker != null && hurtOne.m_21023_((MobEffect)ImmortalersDelightMobEffect.VULNERABLE.get())) {
                int lv;
                int amplifier = Objects.requireNonNull(hurtOne.m_21124_((MobEffect)ImmortalersDelightMobEffect.VULNERABLE.get())).m_19564_();
                int n = lv = isPowerful || amplifier >= 255 ? 255 : amplifier + 1;
                if (VulnerableMobEffect.isVulnerableHasLimit(hurtOne)) {
                    if (VulnerableMobEffect.getEntitiesWithFrequencyLimit().get(hurtOne.m_20148_()) > 0) {
                        evt.setAmount(evt.getAmount() * ((float)lv * 0.5f + 1.0f));
                        VulnerableMobEffect.getEntitiesWithFrequencyLimit().put(hurtOne.m_20148_(), (byte)(entitiesWithFrequencyLimit.get(hurtOne.m_20148_()) - 1));
                    } else {
                        VulnerableMobEffect.isNeedClear(true);
                        hurtOne.m_21195_((MobEffect)ImmortalersDelightMobEffect.VULNERABLE.get());
                        VulnerableMobEffect.removeVulnerableEntityWithFrequencyLimit(hurtOne);
                    }
                } else {
                    VulnerableMobEffect.addVulnerableEntityWithFrequencyLimit(hurtOne, (byte)lv);
                }
            }
        }

        @SubscribeEvent
        public static void onTick(@Nonnull TickEvent.ServerTickEvent evt) {
            if (evt.phase.equals((Object)TickEvent.Phase.START) && entitiesWithFrequencyLimit.size() > 0 && needClear && TimekeepingTask.getImmortalTickTime() % 1000L <= 50L) {
                HashMap<UUID, Byte> entitiesNeedClear = new HashMap<UUID, Byte>();
                for (UUID uuid : entitiesWithFrequencyLimit.keySet()) {
                    if (entitiesWithFrequencyLimit.get(uuid) > 0) continue;
                    entitiesNeedClear.put(uuid, entitiesWithFrequencyLimit.get(uuid));
                }
                for (UUID uuid : entitiesNeedClear.keySet()) {
                    entitiesWithFrequencyLimit.remove(uuid);
                }
                VulnerableMobEffect.isNeedClear(false);
            }
        }
    }
}

