/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.world.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import org.jetbrains.annotations.Nullable;

public class BigOakTreeGrower
extends AbstractTreeGrower {
    BlockState logBlock = Blocks.f_49999_.m_49966_();
    BlockState leavesBlock = Blocks.f_50050_.m_49966_();
    BlockState saplingBlock = Blocks.f_50746_.m_49966_();
    BlockState placeOnBlock = Blocks.f_50493_.m_49966_();
    private Random rand;
    private Level world;
    private BlockPos basePos = BlockPos.f_121853_;
    int heightLimit;
    int height;
    double heightAttenuation = 0.618;
    double branchSlope = 0.381;
    double scaleWidth = 1.0;
    double leafDensity = 1.0;
    int trunkSize = 1;
    int heightLimitLimit = 12;
    int leafDistanceLimit = 4;
    List<FoliageCoordinates> foliageCoords;

    public BigOakTreeGrower() {
    }

    public BigOakTreeGrower(BlockState logBlockIn, BlockState leavesBlockIn, BlockState saplingBlockIn) {
        this.logBlock = logBlockIn;
        this.leavesBlock = leavesBlockIn;
        this.saplingBlock = saplingBlockIn;
    }

    public BigOakTreeGrower(BlockState logBlockIn, BlockState leavesBlockIn, BlockState saplingBlockIn, BlockState placeOnBlockIn) {
        this.logBlock = logBlockIn;
        this.leavesBlock = leavesBlockIn;
        this.saplingBlock = saplingBlockIn;
        this.placeOnBlock = placeOnBlockIn;
    }

    @Nullable
    protected ResourceKey<ConfiguredFeature<?, ?>> m_213888_(RandomSource pRandom, boolean pHasFlowers) {
        return null;
    }

    public void setHeight(int baseHeight, int extraHeight) {
        this.heightLimit = baseHeight;
        this.heightLimitLimit = extraHeight;
    }

    public void setBigTrunkSize(boolean isBig) {
        this.trunkSize = isBig ? 2 : 1;
    }

    public void setLeafDistanceLimit(int pLeafDistanceLimit) {
        this.leafDistanceLimit = pLeafDistanceLimit;
    }

    void generateLeafNodeList() {
        int k;
        int i;
        this.height = (int)((double)this.heightLimit * this.heightAttenuation);
        if (this.height >= this.heightLimit) {
            this.height = this.heightLimit - 1;
        }
        if ((i = (int)(1.382 + Math.pow(this.leafDensity * (double)this.heightLimit / 13.0, 2.0))) < 1) {
            i = 1;
        }
        int j = this.basePos.m_123342_() + this.height;
        this.foliageCoords = new ArrayList<FoliageCoordinates>();
        this.foliageCoords.add(new FoliageCoordinates(this.basePos.m_6630_(k), j));
        for (k = this.heightLimit - this.leafDistanceLimit; k >= 0; --k) {
            float f = this.layerSize(k);
            if (!(f >= 0.0f)) continue;
            for (int l = 0; l < i; ++l) {
                BlockPos blockpos1;
                double d3;
                double d1;
                double d0 = this.scaleWidth * (double)f * ((double)this.rand.nextFloat() + 0.328);
                double d2 = d0 * Math.sin(d1 = (double)(this.rand.nextFloat() * 2.0f) * Math.PI) + 0.5;
                BlockPos blockpos = this.basePos.m_7918_((int)d2, k - 1, (int)(d3 = d0 * Math.cos(d1) + 0.5));
                if (this.checkBlockLine(blockpos, blockpos1 = blockpos.m_6630_(this.leafDistanceLimit)) != -1) continue;
                int i1 = this.basePos.m_123341_() - blockpos.m_123341_();
                int j1 = this.basePos.m_123343_() - blockpos.m_123343_();
                double d4 = (double)blockpos.m_123342_() - Math.sqrt(i1 * i1 + j1 * j1) * this.branchSlope;
                int k1 = d4 > (double)j ? j : (int)d4;
                BlockPos blockpos2 = new BlockPos(this.basePos.m_123341_(), k1, this.basePos.m_123343_());
                if (this.checkBlockLine(blockpos2, blockpos) != -1) continue;
                this.foliageCoords.add(new FoliageCoordinates(blockpos, blockpos2.m_123342_()));
            }
        }
    }

    void crosSection(BlockPos pos, float p_181631_2_, BlockState p_181631_3_) {
        int i = (int)((double)p_181631_2_ + 0.618);
        for (int j = -i; j <= i; ++j) {
            for (int k = -i; k <= i; ++k) {
                BlockPos blockpos;
                BlockState state;
                if (!(Math.pow((double)Math.abs(j) + 0.5, 2.0) + Math.pow((double)Math.abs(k) + 0.5, 2.0) <= (double)(p_181631_2_ * p_181631_2_)) || !(state = this.world.m_8055_(blockpos = pos.m_7918_(j, 0, k))).m_60795_() && !state.m_204336_(BlockTags.f_13035_)) continue;
                this.world.m_7731_(blockpos, p_181631_3_, 2);
            }
        }
    }

    float layerSize(int y) {
        if ((float)y < (float)this.heightLimit * 0.3f) {
            return -1.0f;
        }
        float f = (float)this.heightLimit / 2.0f;
        float f1 = f - (float)y;
        float f2 = (float)Math.sqrt(f * f - f1 * f1);
        if (f1 == 0.0f) {
            f2 = f;
        } else if (Math.abs(f1) >= f) {
            return 0.0f;
        }
        return f2 * 0.5f;
    }

    float leafSize(int y) {
        if (y >= 0 && y < this.leafDistanceLimit) {
            return y != 0 && y != this.leafDistanceLimit - 1 ? 3.0f : 2.0f;
        }
        return -1.0f;
    }

    void generateLeafNode(BlockPos pos) {
        for (int i = 0; i < this.leafDistanceLimit; ++i) {
            this.crosSection(pos.m_6630_(i), this.leafSize(i), this.leavesBlock);
        }
    }

    void limb(BlockPos p_175937_1_, BlockPos p_175937_2_, Block block) {
        BlockPos blockpos = p_175937_2_.m_7918_(-p_175937_1_.m_123341_(), -p_175937_1_.m_123342_(), -p_175937_1_.m_123343_());
        int i = this.getGreatestDistance(blockpos);
        float f = (float)blockpos.m_123341_() / (float)i;
        float f1 = (float)blockpos.m_123342_() / (float)i;
        float f2 = (float)blockpos.m_123343_() / (float)i;
        for (int j = 0; j <= i; ++j) {
            BlockPos blockpos1 = p_175937_1_.m_7918_((int)(0.5f + (float)j * f), (int)(0.5f + (float)j * f1), (int)(0.5f + (float)j * f2));
            BlockState blockState = this.getLogAxis(p_175937_1_, blockpos1, block);
            this.world.m_7731_(blockpos1, blockState, 2);
        }
    }

    private int getGreatestDistance(BlockPos posIn) {
        int i = Math.abs(posIn.m_123341_());
        int j = Math.abs(posIn.m_123342_());
        int k = Math.abs(posIn.m_123343_());
        if (k > i && k > j) {
            return k;
        }
        return j > i ? j : i;
    }

    private BlockState getLogAxis(BlockPos p_175938_1_, BlockPos p_175938_2_, Block blockIn) {
        int j;
        BlockState blockState = (BlockState)blockIn.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y);
        int i = Math.abs(p_175938_2_.m_123341_() - p_175938_1_.m_123341_());
        int k = Math.max(i, j = Math.abs(p_175938_2_.m_123343_() - p_175938_1_.m_123343_()));
        if (k > 0) {
            if (i == k) {
                blockState = (BlockState)blockIn.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X);
            } else if (j == k) {
                blockState = (BlockState)blockIn.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z);
            }
        }
        return blockState;
    }

    void generateLeaves() {
        for (FoliageCoordinates worldgenbigtree$foliagecoordinates : this.foliageCoords) {
            this.generateLeafNode(worldgenbigtree$foliagecoordinates);
        }
    }

    boolean leafNodeNeedsBase(int p_76493_1_) {
        return (double)p_76493_1_ >= (double)this.heightLimit * 0.2;
    }

    void generateTrunk() {
        BlockPos blockpos = this.basePos;
        BlockPos blockpos1 = this.basePos.m_6630_(this.height);
        Block block = this.logBlock.m_60734_();
        this.limb(blockpos, blockpos1, block);
        if (this.trunkSize == 2) {
            this.limb(blockpos.m_122029_(), blockpos1.m_122029_(), block);
            this.limb(blockpos.m_122029_().m_122019_(), blockpos1.m_122029_().m_122019_(), block);
            this.limb(blockpos.m_122019_(), blockpos1.m_122019_(), block);
        }
    }

    void generateLeafNodeBases() {
        for (FoliageCoordinates worldgenbigtree$foliagecoordinates : this.foliageCoords) {
            int i = worldgenbigtree$foliagecoordinates.getBranchBase();
            BlockPos blockpos = new BlockPos(this.basePos.m_123341_(), i, this.basePos.m_123343_());
            if (blockpos.equals((Object)worldgenbigtree$foliagecoordinates) || !this.leafNodeNeedsBase(i - this.basePos.m_123342_())) continue;
            this.limb(blockpos, worldgenbigtree$foliagecoordinates, this.logBlock.m_60734_());
        }
    }

    int checkBlockLine(BlockPos posOne, BlockPos posTwo) {
        BlockPos blockpos = posTwo.m_7918_(-posOne.m_123341_(), -posOne.m_123342_(), -posOne.m_123343_());
        int i = this.getGreatestDistance(blockpos);
        float f = (float)blockpos.m_123341_() / (float)i;
        float f1 = (float)blockpos.m_123342_() / (float)i;
        float f2 = (float)blockpos.m_123343_() / (float)i;
        if (i == 0) {
            return -1;
        }
        for (int j = 0; j <= i; ++j) {
            BlockPos blockpos1 = posOne.m_7918_((int)(0.5f + (float)j * f), (int)(0.5f + (float)j * f1), (int)(0.5f + (float)j * f2));
            if (this.canGrowInto(this.world, blockpos1)) continue;
            return j;
        }
        return -1;
    }

    public void setDecorationDefaults() {
        this.leafDistanceLimit = 5;
    }

    public boolean m_213817_(ServerLevel worldIn, ChunkGenerator p_222906_, BlockPos position, BlockState p_222908_, RandomSource rand) {
        this.world = worldIn;
        this.basePos = position;
        this.rand = new Random(rand.m_188505_());
        if (this.heightLimit == 0) {
            this.heightLimit = 5 + this.rand.nextInt(this.heightLimitLimit);
        }
        if (!this.validTreeLocation()) {
            this.world = null;
            return false;
        }
        this.generateLeafNodeList();
        this.generateLeaves();
        this.generateTrunk();
        this.generateLeafNodeBases();
        this.world = null;
        return true;
    }

    public boolean generate(Level worldIn, RandomSource rand, BlockPos position) {
        this.world = worldIn;
        this.basePos = position;
        this.rand = new Random(rand.m_188505_());
        if (this.heightLimit == 0) {
            this.heightLimit = 5 + this.rand.nextInt(this.heightLimitLimit);
        }
        if (!this.validTreeLocation()) {
            this.world = null;
            return false;
        }
        this.generateLeafNodeList();
        this.generateTrunk();
        this.generateLeaves();
        this.generateLeafNodeBases();
        this.world = null;
        return true;
    }

    private boolean validTreeLocation() {
        BlockPos down = this.basePos.m_7495_();
        BlockState state = this.world.m_8055_(down);
        boolean isSoil = true;
        if (!isSoil) {
            return false;
        }
        int i = this.checkBlockLine(this.basePos, this.basePos.m_6630_(this.heightLimit - 1));
        if (i == -1) {
            return true;
        }
        if (i < 6) {
            return false;
        }
        this.heightLimit = i;
        return true;
    }

    public boolean canGrowInto(Level world, BlockPos pos) {
        BlockState material = world.m_8055_(pos);
        return material.m_60795_() || material.m_204336_(BlockTags.f_13035_) || material.m_204336_(BlockTags.f_13029_) || material.m_204336_(BlockTags.f_144274_) || material.m_204336_(BlockTags.f_13106_) || material.m_204336_(BlockTags.f_215829_) || material.m_204336_(BlockTags.f_13104_) || material.m_60713_(this.logBlock.m_60734_()) || material.m_60713_(this.leavesBlock.m_60734_()) || material.m_60713_(this.saplingBlock.m_60734_()) || material.m_204336_(BlockTags.f_144279_) || material.m_204336_(BlockTags.f_144275_);
    }

    public void setDirtAt(Level worldIn, BlockPos pos) {
        if (worldIn.m_8055_(pos) != this.placeOnBlock) {
            worldIn.m_7731_(pos, this.placeOnBlock, 2);
        }
    }

    static class FoliageCoordinates
    extends BlockPos {
        private final int branchBase;

        public FoliageCoordinates(BlockPos pos, int p_i45635_2_) {
            super(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            this.branchBase = p_i45635_2_;
        }

        public int getBranchBase() {
            return this.branchBase;
        }
    }
}

