/*
 * Decompiled with CFR 0.152.
 */
package net.darkblade.mini_pekka.events;

import java.util.Map;
import net.darkblade.mini_pekka.client.ModBlockEntities;
import net.darkblade.mini_pekka.client.ModBlockEntityModelLayers;
import net.darkblade.mini_pekka.client.ModSkullBlockRenderer;
import net.darkblade.mini_pekka.client.ModSkullHeadLayer;
import net.darkblade.mini_pekka.client.model.MiniPekkaHeadModel;
import net.darkblade.mini_pekka.server.block.ModSkullBlock;
import net.darkblade.mini_pekka.server.items.ModSkullItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class ClientEvents {
    public static int time = 0;

    @Mod.EventBusSubscriber(modid="mpekka", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientModBusEvents {
        @SubscribeEvent
        public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.EFFECT_SKULL.get(), ModSkullBlockRenderer::new);
        }

        @SubscribeEvent
        public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(ModBlockEntityModelLayers.MINI_PK_HEAD, MiniPekkaHeadModel::createMiniPekkaHeadLayer);
        }

        @SubscribeEvent
        public static void onCreateSkullModels(EntityRenderersEvent.CreateSkullModels event) {
            ModelPart baked = event.getEntityModelSet().m_171103_(ModBlockEntityModelLayers.MINI_PK_HEAD);
            event.registerSkullModel((SkullBlock.Type)ModSkullBlock.Types.MINI_PEKKA, (SkullModelBase)new SkullModel(baked));
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void registerEffectSkullHeadLayers(EntityRenderersEvent.AddLayers event) {
            Map renderers = Minecraft.m_91087_().m_91290_().f_114362_;
            for (Map.Entry e : renderers.entrySet()) {
                Object v = e.getValue();
                if (!(v instanceof LivingEntityRenderer)) continue;
                LivingEntityRenderer ler = (LivingEntityRenderer)v;
                boolean hasCustomHead = ler.f_115291_.stream().anyMatch(l -> l instanceof CustomHeadLayer);
                if (!hasCustomHead) continue;
                ler.m_115326_(new ModSkullHeadLayer(ler, Minecraft.m_91087_().m_167973_(), Minecraft.m_91087_().m_91290_().m_234586_()));
            }
            Map skins = Minecraft.m_91087_().m_91290_().getSkinMap();
            for (Map.Entry e : skins.entrySet()) {
                Object v = e.getValue();
                if (!(v instanceof LivingEntityRenderer)) continue;
                LivingEntityRenderer ler = (LivingEntityRenderer)v;
                boolean hasCustomHead = ler.f_115291_.stream().anyMatch(l -> l instanceof CustomHeadLayer);
                if (!hasCustomHead) continue;
                ler.m_115326_(new ModSkullHeadLayer(ler, Minecraft.m_91087_().m_167973_(), Minecraft.m_91087_().m_91290_().m_234586_()));
            }
        }
    }

    @Mod.EventBusSubscriber(modid="mpekka", value={Dist.CLIENT})
    public static class ClientForgeEvents {
        @SubscribeEvent
        public static void renderHeadPre(RenderLivingEvent.Pre<?, ?> event) {
            EntityModel model = event.getRenderer().m_7200_();
            if (model instanceof HumanoidModel) {
                HumanoidModel humanoidModel = (HumanoidModel)model;
                if (event.getEntity().m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof ModSkullItem) {
                    humanoidModel.f_102808_.f_104207_ = false;
                    humanoidModel.f_102809_.f_104207_ = false;
                }
            }
        }

        @SubscribeEvent
        public static void renderHeadPost(RenderLivingEvent.Post<?, ?> event) {
            EntityModel model = event.getRenderer().m_7200_();
            if (model instanceof HumanoidModel) {
                HumanoidModel humanoidModel = (HumanoidModel)model;
                if (event.getEntity().m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof ModSkullItem) {
                    humanoidModel.f_102808_.f_104207_ = true;
                    humanoidModel.f_102809_.f_104207_ = true;
                }
            }
        }

        @SubscribeEvent
        public static void clientTick(TickEvent.ClientTickEvent event) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (!minecraft.m_91104_()) {
                ++time;
            }
        }
    }
}

