/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.nvidium.gl.shader;

import java.util.HashMap;
import java.util.Map;
import me.cortex.nvidium.gl.GlObject;
import me.cortex.nvidium.gl.shader.IShaderProcessor;
import me.cortex.nvidium.gl.shader.ShaderType;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL20C;

public class Shader
extends GlObject {
    private Shader(int program) {
        super(program);
    }

    public static Builder make(IShaderProcessor processor) {
        return new Builder(processor);
    }

    public static Builder make() {
        return new Builder((aa, source) -> source);
    }

    public void bind() {
        GL20.glUseProgram((int)this.id);
    }

    @Override
    public void delete() {
        super.free0();
        GL20.glDeleteProgram((int)this.id);
    }

    @Override
    public void free() {
        this.delete();
    }

    public static class Builder {
        private final Map<ShaderType, String> sources = new HashMap<ShaderType, String>();
        private final IShaderProcessor processor;

        private Builder(IShaderProcessor processor) {
            this.processor = processor;
        }

        public Builder addSource(ShaderType type, String source) {
            this.sources.put(type, this.processor.process(type, source));
            return this;
        }

        public Shader compile() {
            int[] shaders;
            int program = GL20C.glCreateProgram();
            for (int i : shaders = this.sources.entrySet().stream().mapToInt(a -> Builder.createShader((ShaderType)((Object)((Object)a.getKey())), (String)a.getValue())).toArray()) {
                GL20C.glAttachShader((int)program, (int)i);
            }
            GL20C.glLinkProgram((int)program);
            for (int i : shaders) {
                GL20C.glDetachShader((int)program, (int)i);
                GL20C.glDeleteShader((int)i);
            }
            Builder.printProgramLinkLog(program);
            Builder.verifyProgramLinked(program);
            return new Shader(program);
        }

        private static void printProgramLinkLog(int program) {
            String log = GL20C.glGetProgramInfoLog((int)program);
            if (!log.isEmpty()) {
                System.err.println(log);
            }
        }

        private static void verifyProgramLinked(int program) {
            int result = GL20C.glGetProgrami((int)program, (int)35714);
            if (result != 1) {
                throw new RuntimeException("Shader program linking failed, see log for details");
            }
        }

        private static int createShader(ShaderType type, String src) {
            int result;
            int shader = GL20C.glCreateShader((int)type.gl);
            GL20C.glShaderSource((int)shader, (CharSequence)src);
            GL20C.glCompileShader((int)shader);
            String log = GL20C.glGetShaderInfoLog((int)shader);
            if (!log.isEmpty()) {
                System.err.println(log);
            }
            if ((result = GL20C.glGetShaderi((int)shader, (int)35713)) != 1) {
                GL20C.glDeleteShader((int)shader);
                throw new RuntimeException("Shader compilation failed, see log for details");
            }
            return shader;
        }
    }
}

