/*
 * Decompiled with CFR 0.152.
 */
package com.ytonidc.vanillaera;

import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="vanillaera", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SpawnControl {
    private static boolean isCaveDimension(ResourceKey<Level> dimension) {
        return dimension.m_135782_().toString().equals("dimension_of_caves:cave");
    }

    private static boolean isAllowedEntity(Entity entity) {
        EntityType type = entity.m_6095_();
        MobCategory category = type.m_20674_();
        if (entity instanceof Player) {
            return true;
        }
        if (type.toString().startsWith("entity.alexscaves")) {
            return true;
        }
        if (type.toString().startsWith("entity.minecraft")) {
            return category != MobCategory.MONSTER && category != MobCategory.CREATURE && category != MobCategory.WATER_CREATURE && category != MobCategory.WATER_AMBIENT && category != MobCategory.AMBIENT && category != MobCategory.UNDERGROUND_WATER_CREATURE && category != MobCategory.AXOLOTLS;
        }
        return false;
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        if (SpawnControl.isCaveDimension((ResourceKey<Level>)event.getLevel().m_46472_()) && !SpawnControl.isAllowedEntity(event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntitySpawning(MobSpawnEvent event) {
        Mob entity;
        if (SpawnControl.isCaveDimension((ResourceKey<Level>)event.getLevel().m_6018_().m_46472_()) && !SpawnControl.isAllowedEntity((Entity)(entity = event.getEntity()))) {
            entity.m_146870_();
        }
    }
}

