/*
 * Decompiled with CFR 0.152.
 */
package com.ytonidc.vanillaera.mixin.pastedream;

import com.ytonidc.vanillaera.Vanillaera;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.pasterdream.init.ItemAnimationFactory;
import net.pasterdream.item.DreamMeterItem;
import net.pasterdream.item.ShadowHandLanternItem;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;
import software.bernie.geckolib.animatable.GeoItem;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={ItemAnimationFactory.class}, remap=false)
public class ItemAnimationFactoryMixin {
    @Unique
    private static boolean vanillaera$isValidItemStack(ItemStack stack) {
        return stack != null && !stack.m_41619_() && stack.m_41720_() != null;
    }

    @Unique
    private static boolean vanillaera$hasValidAnimationTag(ItemStack stack) {
        if (!ItemAnimationFactoryMixin.vanillaera$isValidItemStack(stack)) {
            return false;
        }
        String animTag = stack.m_41784_().m_128461_("geckoAnim");
        return animTag != null && !animTag.isEmpty();
    }

    @Unique
    private static void vanillaera$processItemAnimation(ItemStack stack, String animation, Level level) {
        if (!ItemAnimationFactoryMixin.vanillaera$isValidItemStack(stack)) {
            return;
        }
        Item item = stack.m_41720_();
        if (item == null) {
            return;
        }
        if (item instanceof DreamMeterItem) {
            DreamMeterItem animatable = (DreamMeterItem)item;
            if (level != null && level.m_5776_()) {
                animatable.animationprocedure = animation;
                ItemAnimationFactory.disableUseAnim();
            }
        } else if (item instanceof ShadowHandLanternItem) {
            ShadowHandLanternItem animatable = (ShadowHandLanternItem)item;
            if (level != null && level.m_5776_()) {
                animatable.animationprocedure = animation;
                ItemAnimationFactory.disableUseAnim();
            }
        }
    }

    @Overwrite
    @SubscribeEvent
    public static void animatedItems(TickEvent.PlayerTickEvent event) {
        String animation;
        boolean hasOffHandGeoItem;
        if (event == null || event.player == null) {
            Vanillaera.LOGGER.warn("Player tick event or player is null!");
            return;
        }
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        ItemStack mainHandStack = event.player.m_21205_();
        ItemStack offHandStack = event.player.m_21206_();
        Level level = event.player.m_9236_();
        boolean hasMainHandGeoItem = ItemAnimationFactoryMixin.vanillaera$isValidItemStack(mainHandStack) && mainHandStack.m_41720_() instanceof GeoItem;
        boolean bl = hasOffHandGeoItem = ItemAnimationFactoryMixin.vanillaera$isValidItemStack(offHandStack) && offHandStack.m_41720_() instanceof GeoItem;
        if (!hasMainHandGeoItem && !hasOffHandGeoItem) {
            return;
        }
        if (hasMainHandGeoItem && ItemAnimationFactoryMixin.vanillaera$hasValidAnimationTag(mainHandStack) && !(mainHandStack.m_41720_() instanceof ArmorItem)) {
            animation = mainHandStack.m_41784_().m_128461_("geckoAnim");
            mainHandStack.m_41784_().m_128359_("geckoAnim", "");
            ItemAnimationFactoryMixin.vanillaera$processItemAnimation(mainHandStack, animation, level);
        }
        if (hasOffHandGeoItem && ItemAnimationFactoryMixin.vanillaera$hasValidAnimationTag(offHandStack) && !(offHandStack.m_41720_() instanceof ArmorItem)) {
            animation = offHandStack.m_41784_().m_128461_("geckoAnim");
            offHandStack.m_41784_().m_128359_("geckoAnim", "");
            ItemAnimationFactoryMixin.vanillaera$processItemAnimation(offHandStack, animation, level);
        }
    }
}

