/*
 * Decompiled with CFR 0.152.
 */
package com.endilcrafter.farmersplus.common.block;

import com.endilcrafter.farmersplus.common.block.entity.DryingRackBlockEntity;
import com.endilcrafter.farmersplus.common.crafting.DryingRackRecipe;
import com.endilcrafter.farmersplus.common.registry.PlusBlockEntities;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class DryingRackBlock
extends BaseEntityBlock {
    public static final VoxelShape POST1 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)6.0, (double)2.0);
    public static final VoxelShape POST2 = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)2.0);
    public static final VoxelShape POST3 = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)6.0, (double)16.0);
    public static final VoxelShape POST4 = Block.m_49796_((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)6.0, (double)16.0);
    public static final VoxelShape FRAME1 = Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)8.0, (double)2.0);
    public static final VoxelShape FRAME2 = Block.m_49796_((double)0.0, (double)6.0, (double)14.0, (double)16.0, (double)8.0, (double)16.0);
    public static final VoxelShape FRAME3 = Block.m_49796_((double)0.0, (double)6.0, (double)2.0, (double)2.0, (double)8.0, (double)14.0);
    public static final VoxelShape FRAME4 = Block.m_49796_((double)14.0, (double)6.0, (double)2.0, (double)16.0, (double)8.0, (double)14.0);
    public static final VoxelShape MESH = Block.m_49796_((double)2.0, (double)6.9, (double)2.0, (double)14.0, (double)7.0, (double)14.0);
    public static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)POST1, (VoxelShape[])new VoxelShape[]{POST2, POST3, POST4, FRAME1, FRAME2, FRAME3, FRAME4, MESH});
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public DryingRackBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new DryingRackBlockEntity(pPos, pState);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack heldStack = player.m_21120_(hand);
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof DryingRackBlockEntity) {
            DryingRackBlockEntity rackEntity = (DryingRackBlockEntity)tileEntity;
            int rackSlot = rackEntity.getNextEmptySlot();
            if (rackSlot < 0) {
                return InteractionResult.PASS;
            }
            Optional<DryingRackRecipe> recipe = rackEntity.getMatchingRecipe((Container)new SimpleContainer(new ItemStack[]{heldStack}), rackSlot);
            if (recipe.isPresent()) {
                if (!level.f_46443_ && rackEntity.addItem(player.m_150110_().f_35937_ ? heldStack.m_41777_() : heldStack, recipe.get(), rackSlot)) {
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof DryingRackBlockEntity) {
                ItemUtils.dropItems((Level)level, (BlockPos)pos, (IItemHandler)((DryingRackBlockEntity)tileEntity).getInventory());
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{FACING});
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return DryingRackBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)PlusBlockEntities.DRYING_RACK.get()), (BlockEntityTicker)(level.f_46443_ ? DryingRackBlockEntity::animationTick : DryingRackBlockEntity::dryingTick));
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }
}

