/*
 * Decompiled with CFR 0.152.
 */
package com.endilcrafter.farmersplus.common.block;

import com.endilcrafter.farmersplus.common.block.entity.MillstoneBlockEntity;
import com.endilcrafter.farmersplus.common.registry.PlusBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.tag.ModTags;

public class MillstoneBlock
extends BaseEntityBlock {
    public static final IntegerProperty SPIN = IntegerProperty.m_61631_((String)"spin", (int)0, (int)7);
    protected static final VoxelShape BASE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    protected static final VoxelShape MILLSTONE = Block.m_49796_((double)3.0, (double)4.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);
    protected static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)MILLSTONE);

    public MillstoneBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)SPIN, (Comparable)Integer.valueOf(0)));
    }

    public static void spawnMillingParticles(Level level, BlockPos pos, ItemStack stack, int count) {
        for (int i = 0; i < count; ++i) {
            Vec3 vec3d = new Vec3(((double)level.f_46441_.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)level.f_46441_.m_188501_() - 0.5) * 0.1);
            if (level instanceof ServerLevel) {
                ((ServerLevel)level).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.1f), (double)((float)pos.m_123343_() + 0.5f), 1, vec3d.f_82479_, vec3d.f_82480_ + 0.05, vec3d.f_82481_, 0.0);
                continue;
            }
            level.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.3f), (double)((float)pos.m_123343_() + 0.5f), vec3d.f_82479_, vec3d.f_82480_ + 0.05, vec3d.f_82481_);
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof MillstoneBlockEntity) {
            MillstoneBlockEntity millstoneBlockEntity = (MillstoneBlockEntity)tileEntity;
            ItemStack heldStack = player.m_21120_(hand);
            ItemStack offhandStack = player.m_21206_();
            if (millstoneBlockEntity.isEmpty()) {
                if (!offhandStack.m_41619_()) {
                    if (hand.equals((Object)InteractionHand.MAIN_HAND) && !offhandStack.m_204117_(ModTags.OFFHAND_EQUIPMENT) && !(heldStack.m_41720_() instanceof BlockItem)) {
                        return InteractionResult.PASS;
                    }
                    if (hand.equals((Object)InteractionHand.OFF_HAND) && offhandStack.m_204117_(ModTags.OFFHAND_EQUIPMENT)) {
                        return InteractionResult.PASS;
                    }
                }
                if (heldStack.m_41619_()) {
                    return InteractionResult.PASS;
                }
                if (millstoneBlockEntity.addItem(player.m_150110_().f_35937_ ? heldStack.m_41777_() : heldStack)) {
                    level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 0.8f);
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (hand.equals((Object)InteractionHand.MAIN_HAND) && !player.m_6144_()) {
                    level.m_46597_(pos, (BlockState)state.m_61122_((Property)SPIN));
                    int process = (Integer)state.m_61143_((Property)SPIN);
                    level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12446_, SoundSource.BLOCKS, 1.0f, 0.8f);
                    if (process == 7) {
                        ItemStack boardStack = millstoneBlockEntity.getStoredItem().m_41777_();
                        if (millstoneBlockEntity.processStoredItem(player)) {
                            MillstoneBlock.spawnMillingParticles(level, pos, boardStack, 5);
                            return InteractionResult.SUCCESS;
                        }
                    }
                    return InteractionResult.SUCCESS;
                }
                if (hand.equals((Object)InteractionHand.MAIN_HAND) && player.m_6144_()) {
                    if (!player.m_7500_()) {
                        if (!player.m_150109_().m_36054_(millstoneBlockEntity.removeItem())) {
                            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)millstoneBlockEntity.removeItem());
                        }
                    } else {
                        millstoneBlockEntity.removeItem();
                    }
                    level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12019_, SoundSource.BLOCKS, 0.25f, 0.5f);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof MillstoneBlockEntity) {
                MillstoneBlockEntity millstone = (MillstoneBlockEntity)tileEntity;
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)millstone.getStoredItem());
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)SPIN, (Comparable)Integer.valueOf(0));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{SPIN});
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof MillstoneBlockEntity) {
            return !((MillstoneBlockEntity)blockEntity).isEmpty() ? 15 : 0;
        }
        return 0;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)PlusBlockEntities.MILLSTONE.get()).m_155264_(pos, state);
    }
}

