/*
 * Decompiled with CFR 0.152.
 */
package com.endilcrafter.farmersplus.common.block;

import com.endilcrafter.farmersplus.common.block.TerracottaPotBlock;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class TerracottaFeastBlock
extends TerracottaPotBlock {
    public static final VoxelShape FEAST0 = Block.m_49796_((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0);
    public static final VoxelShape FEAST1 = Block.m_49796_((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)5.0, (double)12.0);
    public static final VoxelShape FEAST2 = Block.m_49796_((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0);
    public static final VoxelShape FEAST3 = Block.m_49796_((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)3.0, (double)12.0);
    public static final IntegerProperty SERVINGS = IntegerProperty.m_61631_((String)"servings", (int)0, (int)8);
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{SHAPE, Shapes.m_83110_((VoxelShape)SHAPE, (VoxelShape)FEAST3), Shapes.m_83110_((VoxelShape)SHAPE, (VoxelShape)FEAST3), Shapes.m_83110_((VoxelShape)SHAPE, (VoxelShape)FEAST2), Shapes.m_83110_((VoxelShape)SHAPE, (VoxelShape)FEAST2), Shapes.m_83110_((VoxelShape)SHAPE, (VoxelShape)FEAST1), Shapes.m_83110_((VoxelShape)SHAPE, (VoxelShape)FEAST1), Shapes.m_83110_((VoxelShape)SHAPE, (VoxelShape)FEAST0), Shapes.m_83110_((VoxelShape)SHAPE, (VoxelShape)FEAST0)};
    public final Supplier<Item> servingItem;

    public TerracottaFeastBlock(BlockBehaviour.Properties properties, Supplier<Item> servingItem) {
        super(properties);
        this.servingItem = servingItem;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)this.getServingsProperty(), (Comparable)Integer.valueOf(this.getMaxServings())));
    }

    public IntegerProperty getServingsProperty() {
        return SERVINGS;
    }

    public int getMaxServings() {
        return 8;
    }

    public ItemStack getServingItem(BlockState state) {
        return new ItemStack((ItemLike)this.servingItem.get());
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES[(Integer)state.m_61143_((Property)SERVINGS)];
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return level.f_46443_ && this.takeServing((LevelAccessor)level, pos, state, player, hand).m_19077_() ? InteractionResult.SUCCESS : this.takeServing((LevelAccessor)level, pos, state, player, hand);
    }

    protected InteractionResult takeServing(LevelAccessor level, BlockPos pos, BlockState state, Player player, InteractionHand hand) {
        int servings = (Integer)state.m_61143_((Property)this.getServingsProperty());
        if (servings == 0) {
            level.m_5594_(null, pos, SoundEvents.f_12442_, SoundSource.PLAYERS, 0.8f, 0.8f);
            level.m_46961_(pos, true);
            return InteractionResult.SUCCESS;
        }
        ItemStack serving = this.getServingItem(state);
        ItemStack heldStack = player.m_21120_(hand);
        if (servings > 0) {
            if (!serving.hasCraftingRemainingItem() || ItemStack.m_41656_((ItemStack)heldStack, (ItemStack)serving.getCraftingRemainingItem())) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)this.getServingsProperty(), (Comparable)Integer.valueOf(servings - 1)), 3);
                if (!player.m_150110_().f_35937_ && serving.hasCraftingRemainingItem()) {
                    heldStack.m_41774_(1);
                }
                if (!player.m_150109_().m_36054_(serving)) {
                    player.m_36176_(serving, false);
                }
                level.m_5594_(null, pos, SoundEvents.f_11675_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            player.m_5661_((Component)TextUtils.getTranslation((String)"block.feast.use_container", (Object[])new Object[]{serving.getCraftingRemainingItem().m_41786_()}), true);
        }
        return InteractionResult.PASS;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, SERVINGS});
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        return (Integer)blockState.m_61143_((Property)this.getServingsProperty());
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

