/*
 * Decompiled with CFR 0.152.
 */
package com.endilcrafter.farmersplus.common.crafting;

import com.endilcrafter.farmersplus.common.registry.PlusBlocks;
import com.endilcrafter.farmersplus.common.registry.PlusRecipeSerializers;
import com.endilcrafter.farmersplus.common.registry.PlusRecipeTypes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class DryingRackRecipe
implements Recipe<Container> {
    protected final ResourceLocation id;
    protected final Ingredient ingredient;
    protected final ItemStack result;
    protected final int dryingTime;

    public DryingRackRecipe(ResourceLocation id, Ingredient ingredient, ItemStack result, int dryingTime) {
        this.id = id;
        this.ingredient = ingredient;
        this.result = result;
        this.dryingTime = dryingTime;
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        return this.ingredient.test(pContainer.m_8020_(0));
    }

    public ItemStack m_5874_(Container pContainer, RegistryAccess pRegistryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.result;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList $$0 = NonNullList.m_122779_();
        $$0.add((Object)this.ingredient);
        return $$0;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)PlusRecipeSerializers.DRYING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)PlusRecipeTypes.DRYING.get();
    }

    public int getDryingTime() {
        return this.dryingTime;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)PlusBlocks.DRYING_RACK.get());
    }

    public static class Serializer
    implements RecipeSerializer<DryingRackRecipe> {
        public DryingRackRecipe fromJson(ResourceLocation id, JsonObject json) {
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            JsonArray jsonelement = GsonHelper.m_13885_((JsonObject)json, (String)"ingredients") ? GsonHelper.m_13933_((JsonObject)json, (String)"ingredients") : GsonHelper.m_13930_((JsonObject)json, (String)"ingredients");
            Ingredient ingredient = Ingredient.m_288218_((JsonElement)jsonelement, (boolean)false);
            int dryingTime = GsonHelper.m_13927_((JsonObject)json, (String)"dryingtime");
            return new DryingRackRecipe(id, ingredient, result, dryingTime);
        }

        @Nullable
        public DryingRackRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf pBuffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            ItemStack result = pBuffer.m_130267_();
            int dryingTime = pBuffer.m_130242_();
            return new DryingRackRecipe(id, ingredient, result, dryingTime);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, DryingRackRecipe pRecipe) {
            pRecipe.ingredient.m_43923_(pBuffer);
            pBuffer.m_130055_(pRecipe.result);
            pBuffer.m_130130_(pRecipe.dryingTime);
        }
    }
}

