/*
 * Decompiled with CFR 0.152.
 */
package com.endilcrafter.farmersplus.common.crafting;

import com.endilcrafter.farmersplus.common.registry.PlusRecipeSerializers;
import com.endilcrafter.farmersplus.common.registry.PlusRecipeTypes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import vectorwing.farmersdelight.common.crafting.ingredient.ChanceResult;

public class MillstoneRecipe
implements Recipe<RecipeWrapper> {
    private final ResourceLocation id;
    private final String group;
    private final Ingredient input;
    private final NonNullList<ChanceResult> results;
    private final String soundEvent;

    public MillstoneRecipe(ResourceLocation id, String group, Ingredient input, NonNullList<ChanceResult> results, String soundEvent) {
        this.id = id;
        this.group = group;
        this.input = input;
        this.results = results;
        this.soundEvent = soundEvent;
    }

    public boolean m_5598_() {
        return true;
    }

    public String m_6076_() {
        return this.group;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonnulllist = NonNullList.m_122779_();
        nonnulllist.add((Object)this.input);
        return nonnulllist;
    }

    public String getSoundEventID() {
        return this.soundEvent;
    }

    public boolean matches(RecipeWrapper inv, Level level) {
        return !inv.m_7983_() && this.input.test(inv.m_8020_(0));
    }

    protected int getMaxInputCount() {
        return 64;
    }

    public ItemStack assemble(RecipeWrapper inv, RegistryAccess access) {
        return ((ChanceResult)this.results.get(0)).getStack().m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= this.getMaxInputCount();
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ((ChanceResult)this.results.get(0)).getStack();
    }

    public List<ItemStack> getResults() {
        return this.getRollableResults().stream().map(ChanceResult::getStack).collect(Collectors.toList());
    }

    public NonNullList<ChanceResult> getRollableResults() {
        return this.results;
    }

    public List<ItemStack> rollResults(RandomSource rand) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        NonNullList<ChanceResult> rollableResults = this.getRollableResults();
        for (ChanceResult output : rollableResults) {
            ItemStack stack = output.rollOutput(rand, 0);
            if (stack.m_41619_()) continue;
            results.add(stack);
        }
        return results;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)PlusRecipeSerializers.MILLING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)PlusRecipeTypes.MILLING.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            MillstoneRecipe that = (MillstoneRecipe)o;
            if (!this.m_6423_().equals((Object)that.m_6423_())) {
                return false;
            }
            if (!this.m_6076_().equals(that.m_6076_())) {
                return false;
            }
            if (!this.input.equals(that.input)) {
                return false;
            }
            return this.getResults().equals(that.getResults()) && Objects.equals(this.soundEvent, that.soundEvent);
        }
        return false;
    }

    public int hashCode() {
        int result = this.m_6423_().hashCode();
        result = 31 * result + (this.m_6076_() != null ? this.m_6076_().hashCode() : 0);
        result = 31 * result + this.input.hashCode();
        result = 31 * result + this.getResults().hashCode();
        result = 31 * result + (this.soundEvent != null ? this.soundEvent.hashCode() : 0);
        return result;
    }

    public static class Serializer
    implements RecipeSerializer<MillstoneRecipe> {
        private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientArray.get(i));
                if (ingredient.m_43947_()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        private static NonNullList<ChanceResult> readResults(JsonArray resultArray) {
            NonNullList results = NonNullList.m_122779_();
            for (JsonElement result : resultArray) {
                results.add((Object)ChanceResult.deserialize((JsonElement)result));
            }
            return results;
        }

        public MillstoneRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String groupIn = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> inputItemsIn = Serializer.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (inputItemsIn.isEmpty()) {
                throw new JsonParseException("No ingredients for milling recipe");
            }
            if (inputItemsIn.size() > 1) {
                throw new JsonParseException("Too many ingredients for milling recipe! Please define only one ingredient");
            }
            NonNullList<ChanceResult> results = Serializer.readResults(GsonHelper.m_13933_((JsonObject)json, (String)"result"));
            if (results.size() > 4) {
                throw new JsonParseException("Too many results for milling recipe! The maximum quantity of unique results is 4");
            }
            String soundID = GsonHelper.m_13851_((JsonObject)json, (String)"sound", (String)"");
            return new MillstoneRecipe(recipeId, groupIn, (Ingredient)inputItemsIn.get(0), results, soundID);
        }

        @Nullable
        public MillstoneRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String groupIn = buffer.m_130136_(Short.MAX_VALUE);
            Ingredient inputItemIn = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int i = buffer.m_130242_();
            NonNullList resultsIn = NonNullList.m_122780_((int)i, (Object)ChanceResult.EMPTY);
            resultsIn.replaceAll(ignored -> ChanceResult.read((FriendlyByteBuf)buffer));
            String soundEventIn = buffer.m_130277_();
            return new MillstoneRecipe(recipeId, groupIn, inputItemIn, (NonNullList<ChanceResult>)resultsIn, soundEventIn);
        }

        public void toNetwork(FriendlyByteBuf buffer, MillstoneRecipe recipe) {
            buffer.m_130070_(recipe.group);
            recipe.input.m_43923_(buffer);
            buffer.m_130130_(recipe.results.size());
            for (ChanceResult result : recipe.results) {
                result.write(buffer);
            }
            buffer.m_130070_(recipe.soundEvent);
        }
    }
}

