/*
 * Decompiled with CFR 0.152.
 */
package com.endilcrafter.farmersplus.data.builder;

import com.endilcrafter.farmersplus.common.registry.PlusRecipeSerializers;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistries;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class DryingRecipeBuilder {
    private final Item result;
    private final Ingredient ingredient;
    private final int dryingTime;

    public DryingRecipeBuilder(Ingredient ingredient, Item result, int dryingTime) {
        this.result = result;
        this.ingredient = ingredient;
        this.dryingTime = dryingTime;
    }

    public static DryingRecipeBuilder dryingRecipe(Ingredient ingredient, Item result, int dryingTime) {
        return new DryingRecipeBuilder(ingredient, result, dryingTime);
    }

    public static DryingRecipeBuilder dryingRecipe(Ingredient ingredient, Item result) {
        return new DryingRecipeBuilder(ingredient, result, 600);
    }

    public void build(Consumer<FinishedRecipe> consumerIn) {
        ResourceLocation location = ForgeRegistries.ITEMS.getKey((Object)this.ingredient.m_43908_()[0].m_41720_());
        this.build(consumerIn, "farmersplus:drying/" + location.m_135815_());
    }

    public void build(Consumer<FinishedRecipe> consumerIn, String save) {
        ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((Object)this.ingredient.m_43908_()[0].m_41720_());
        if (new ResourceLocation(save).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Drying Recipe " + save + " should remove its 'save' argument");
        }
        this.build(consumerIn, new ResourceLocation(save));
    }

    public void build(Consumer<FinishedRecipe> consumerIn, ResourceLocation id) {
        consumerIn.accept(new Result(id, this.ingredient, this.result, this.dryingTime));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient ingredient;
        private final Item result;
        private final int dryingTime;

        public Result(ResourceLocation idIn, Ingredient ingredientIn, Item result, int dryingTime) {
            this.id = idIn;
            this.ingredient = ingredientIn;
            this.result = result;
            this.dryingTime = dryingTime;
        }

        public void m_7917_(JsonObject json) {
            JsonArray arrayIngredients = new JsonArray();
            arrayIngredients.add(this.ingredient.m_43942_());
            json.add("ingredients", (JsonElement)arrayIngredients);
            JsonObject objectResults = new JsonObject();
            objectResults.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.result).toString());
            json.add("result", (JsonElement)objectResults);
            json.addProperty("dryingtime", (Number)this.dryingTime);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)PlusRecipeSerializers.DRYING.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

