/*
 * Decompiled with CFR 0.152.
 */
package com.endilcrafter.farmersplus.integration.jei;

import com.endilcrafter.farmersplus.common.registry.PlusItems;
import com.endilcrafter.farmersplus.integration.jei.FPRecipeTypes;
import com.endilcrafter.farmersplus.integration.jei.FPRecipes;
import com.endilcrafter.farmersplus.integration.jei.category.DryingRecipeCategory;
import com.endilcrafter.farmersplus.integration.jei.category.MillingRecipeCategory;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@JeiPlugin
public class PlusJEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("farmersplus", "jei_plugin");

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new DryingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new MillingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        FPRecipes modRecipes = new FPRecipes();
        registration.addRecipes(FPRecipeTypes.DRYING, modRecipes.getDryingRackRecipes());
        registration.addRecipes(FPRecipeTypes.MILLING, modRecipes.getMillstoneRecipes());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)PlusItems.DRYING_RACK.get()), new RecipeType[]{FPRecipeTypes.DRYING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)PlusItems.MILLSTONE.get()), new RecipeType[]{FPRecipeTypes.MILLING});
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }
}

