/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.core.generated.oba;

import javax.annotation.Nonnull;
import org.mtr.core.oba.Frequency;
import org.mtr.core.oba.StopTime;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.serializer.SerializedDataBase;
import org.mtr.core.serializer.WriterBase;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;

public abstract class ScheduleSchema
implements SerializedDataBase {
    protected final String timeZone;
    protected final ObjectArrayList<StopTime> stopTimes = new ObjectArrayList();
    protected final String previousTripId;
    protected final String nextTripId;
    protected Frequency frequency = this.getDefaultFrequency();

    protected ScheduleSchema(String timeZone, String previousTripId, String nextTripId) {
        this.timeZone = timeZone;
        this.previousTripId = previousTripId;
        this.nextTripId = nextTripId;
    }

    protected ScheduleSchema(ReaderBase readerBase) {
        this.timeZone = readerBase.getString("timeZone", "");
        this.previousTripId = readerBase.getString("previousTripId", "");
        this.nextTripId = readerBase.getString("nextTripId", "");
    }

    @Override
    public void updateData(ReaderBase readerBase) {
        readerBase.iterateReaderArray("stopTimes", this.stopTimes::clear, readerBaseChild -> this.stopTimes.add(new StopTime((ReaderBase)readerBaseChild)));
        readerBase.unpackChild("frequency", readerBaseChild -> {
            this.frequency = new Frequency((ReaderBase)readerBaseChild);
        });
    }

    @Override
    public void serializeData(WriterBase writerBase) {
        writerBase.writeString("timeZone", this.timeZone);
        this.serializeStopTimes(writerBase);
        writerBase.writeString("previousTripId", this.previousTripId);
        writerBase.writeString("nextTripId", this.nextTripId);
        this.serializeFrequency(writerBase);
    }

    @Nonnull
    public String toString() {
        return "timeZone: " + this.timeZone + "\nstopTimes: " + this.stopTimes + "\npreviousTripId: " + this.previousTripId + "\nnextTripId: " + this.nextTripId + "\nfrequency: " + this.frequency + "\n";
    }

    protected void serializeStopTimes(WriterBase writerBase) {
        writerBase.writeDataset(this.stopTimes, "stopTimes");
    }

    protected abstract Frequency getDefaultFrequency();

    protected void serializeFrequency(WriterBase writerBase) {
        if (this.frequency != null) {
            this.frequency.serializeData(writerBase.writeChild("frequency"));
        }
    }
}

