/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.libraries.okhttp3.internal.connection;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.Socket;
import java.util.Collection;
import java.util.List;
import org.mtr.libraries.kotlin.Metadata;
import org.mtr.libraries.kotlin.jvm.internal.Intrinsics;
import org.mtr.libraries.okhttp3.Connection;
import org.mtr.libraries.okhttp3.ConnectionListener;
import org.mtr.libraries.okhttp3.EventListener;
import org.mtr.libraries.okhttp3.Handshake;
import org.mtr.libraries.okhttp3.HttpUrl;
import org.mtr.libraries.okhttp3.Protocol;
import org.mtr.libraries.okhttp3.Route;
import org.mtr.libraries.okhttp3.internal.connection.ConnectPlan;
import org.mtr.libraries.okhttp3.internal.connection.ConnectionUser;
import org.mtr.libraries.okhttp3.internal.connection.RealCall;
import org.mtr.libraries.okhttp3.internal.connection.RealConnection;
import org.mtr.libraries.okhttp3.internal.http.RealInterceptorChain;
import org.mtr.libraries.org.jetbrains.annotations.NotNull;
import org.mtr.libraries.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0010H\u0016J\"\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\"\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010#\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010$\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u001fH\u0016J\u001e\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0016J\u0010\u0010+\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020-H\u0016J\u0010\u0010/\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u00100\u001a\u00020\u000e2\u0006\u00101\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u0002040)H\u0016J\u0010\u00105\u001a\u00020\u000e2\u0006\u00101\u001a\u000202H\u0016J\n\u00106\u001a\u0004\u0018\u000107H\u0016J\u0010\u00108\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u00109\u001a\u00020\u000e2\b\u0010:\u001a\u0004\u0018\u00010;H\u0016J\b\u0010<\u001a\u00020\u000eH\u0016J\u0010\u0010=\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lorg/mtr/libraries/okhttp3/internal/connection/CallConnectionUser;", "Lorg/mtr/libraries/okhttp3/internal/connection/ConnectionUser;", "call", "Lorg/mtr/libraries/okhttp3/internal/connection/RealCall;", "poolConnectionListener", "Lorg/mtr/libraries/okhttp3/ConnectionListener;", "chain", "Lorg/mtr/libraries/okhttp3/internal/http/RealInterceptorChain;", "(Lokhttp3/internal/connection/RealCall;Lokhttp3/ConnectionListener;Lokhttp3/internal/http/RealInterceptorChain;)V", "eventListener", "Lorg/mtr/libraries/okhttp3/EventListener;", "getEventListener", "()Lokhttp3/EventListener;", "acquireConnectionNoEvents", "", "connection", "Lorg/mtr/libraries/okhttp3/internal/connection/RealConnection;", "addPlanToCancel", "connectPlan", "Lorg/mtr/libraries/okhttp3/internal/connection/ConnectPlan;", "callConnectEnd", "route", "Lorg/mtr/libraries/okhttp3/Route;", "protocol", "Lorg/mtr/libraries/okhttp3/Protocol;", "candidateConnection", "connectFailed", "e", "Ljava/io/IOException;", "connectStart", "connectionAcquired", "Lorg/mtr/libraries/okhttp3/Connection;", "connectionConnectEnd", "connectionConnectionAcquired", "connectionConnectionClosed", "connectionConnectionReleased", "connectionReleased", "dnsEnd", "socketHost", "", "result", "", "Ljava/net/InetAddress;", "dnsStart", "doExtensiveHealthChecks", "", "isCanceled", "noNewExchanges", "proxySelectEnd", "url", "Lorg/mtr/libraries/okhttp3/HttpUrl;", "proxies", "Ljava/net/Proxy;", "proxySelectStart", "releaseConnectionNoEvents", "Ljava/net/Socket;", "removePlanToCancel", "secureConnectEnd", "handshake", "Lorg/mtr/libraries/okhttp3/Handshake;", "secureConnectStart", "updateRouteDatabaseAfterSuccess", "okhttp"})
public final class CallConnectionUser
implements ConnectionUser {
    @NotNull
    private final RealCall call;
    @NotNull
    private final ConnectionListener poolConnectionListener;
    @NotNull
    private final RealInterceptorChain chain;

    public CallConnectionUser(@NotNull RealCall call, @NotNull ConnectionListener poolConnectionListener, @NotNull RealInterceptorChain chain) {
        Intrinsics.checkNotNullParameter(call, "call");
        Intrinsics.checkNotNullParameter(poolConnectionListener, "poolConnectionListener");
        Intrinsics.checkNotNullParameter(chain, "chain");
        this.call = call;
        this.poolConnectionListener = poolConnectionListener;
        this.chain = chain;
    }

    private final EventListener getEventListener() {
        return this.call.getEventListener$okhttp();
    }

    @Override
    public void addPlanToCancel(@NotNull ConnectPlan connectPlan) {
        Intrinsics.checkNotNullParameter(connectPlan, "connectPlan");
        ((Collection)this.call.getPlansToCancel$okhttp()).add(connectPlan);
    }

    @Override
    public void removePlanToCancel(@NotNull ConnectPlan connectPlan) {
        Intrinsics.checkNotNullParameter(connectPlan, "connectPlan");
        ((Collection)this.call.getPlansToCancel$okhttp()).remove(connectPlan);
    }

    @Override
    public void updateRouteDatabaseAfterSuccess(@NotNull Route route) {
        Intrinsics.checkNotNullParameter(route, "route");
        this.call.getClient().getRouteDatabase$okhttp().connected(route);
    }

    @Override
    public void connectStart(@NotNull Route route) {
        Intrinsics.checkNotNullParameter(route, "route");
        this.getEventListener().connectStart(this.call, route.socketAddress(), route.proxy());
        this.poolConnectionListener.connectStart(route, this.call);
    }

    @Override
    public void connectFailed(@NotNull Route route, @Nullable Protocol protocol, @NotNull IOException e) {
        Intrinsics.checkNotNullParameter(route, "route");
        Intrinsics.checkNotNullParameter(e, "e");
        this.getEventListener().connectFailed(this.call, route.socketAddress(), route.proxy(), null, e);
        this.poolConnectionListener.connectFailed(route, this.call, e);
    }

    @Override
    public void secureConnectStart() {
        this.getEventListener().secureConnectStart(this.call);
    }

    @Override
    public void secureConnectEnd(@Nullable Handshake handshake2) {
        this.getEventListener().secureConnectEnd(this.call, handshake2);
    }

    @Override
    public void callConnectEnd(@NotNull Route route, @Nullable Protocol protocol) {
        Intrinsics.checkNotNullParameter(route, "route");
        this.getEventListener().connectEnd(this.call, route.socketAddress(), route.proxy(), protocol);
    }

    @Override
    public void connectionConnectEnd(@NotNull Connection connection, @NotNull Route route) {
        Intrinsics.checkNotNullParameter(connection, "connection");
        Intrinsics.checkNotNullParameter(route, "route");
        this.poolConnectionListener.connectEnd(connection, route, this.call);
    }

    @Override
    public void connectionAcquired(@NotNull Connection connection) {
        Intrinsics.checkNotNullParameter(connection, "connection");
        this.getEventListener().connectionAcquired(this.call, connection);
    }

    @Override
    public void acquireConnectionNoEvents(@NotNull RealConnection connection) {
        Intrinsics.checkNotNullParameter(connection, "connection");
        this.call.acquireConnectionNoEvents(connection);
    }

    @Override
    @Nullable
    public Socket releaseConnectionNoEvents() {
        return this.call.releaseConnectionNoEvents$okhttp();
    }

    @Override
    public void connectionReleased(@NotNull Connection connection) {
        Intrinsics.checkNotNullParameter(connection, "connection");
        this.getEventListener().connectionReleased(this.call, connection);
    }

    @Override
    public void connectionConnectionAcquired(@NotNull RealConnection connection) {
        Intrinsics.checkNotNullParameter(connection, "connection");
        connection.getConnectionListener$okhttp().connectionAcquired(connection, this.call);
    }

    @Override
    public void connectionConnectionReleased(@NotNull RealConnection connection) {
        Intrinsics.checkNotNullParameter(connection, "connection");
        connection.getConnectionListener$okhttp().connectionReleased(connection, this.call);
    }

    @Override
    public void connectionConnectionClosed(@NotNull RealConnection connection) {
        Intrinsics.checkNotNullParameter(connection, "connection");
        connection.getConnectionListener$okhttp().connectionClosed(connection);
    }

    @Override
    public void noNewExchanges(@NotNull RealConnection connection) {
        Intrinsics.checkNotNullParameter(connection, "connection");
        connection.getConnectionListener$okhttp().noNewExchanges(connection);
    }

    @Override
    public boolean doExtensiveHealthChecks() {
        return !Intrinsics.areEqual(this.chain.getRequest$okhttp().method(), "GET");
    }

    @Override
    public boolean isCanceled() {
        return this.call.isCanceled();
    }

    @Override
    @Nullable
    public RealConnection candidateConnection() {
        return this.call.getConnection();
    }

    @Override
    public void proxySelectStart(@NotNull HttpUrl url) {
        Intrinsics.checkNotNullParameter(url, "url");
        this.getEventListener().proxySelectStart(this.call, url);
    }

    @Override
    public void proxySelectEnd(@NotNull HttpUrl url, @NotNull List<? extends Proxy> proxies) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(proxies, "proxies");
        this.getEventListener().proxySelectEnd(this.call, url, proxies);
    }

    @Override
    public void dnsStart(@NotNull String socketHost) {
        Intrinsics.checkNotNullParameter(socketHost, "socketHost");
        this.getEventListener().dnsStart(this.call, socketHost);
    }

    @Override
    public void dnsEnd(@NotNull String socketHost, @NotNull List<? extends InetAddress> result) {
        Intrinsics.checkNotNullParameter(socketHost, "socketHost");
        Intrinsics.checkNotNullParameter(result, "result");
        this.getEventListener().dnsEnd(this.call, socketHost, result);
    }
}

