/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.InteractionHand;
import org.mtr.mapping.annotation.MappedMethod;

@ParametersAreNonnullByDefault
public enum Hand {
    MAIN_HAND(InteractionHand.MAIN_HAND),
    OFF_HAND(InteractionHand.OFF_HAND);

    public final InteractionHand data;

    private Hand(InteractionHand data) {
        this.data = data;
    }

    public static Hand convert(@Nullable InteractionHand data) {
        return data == null ? null : Hand.values()[data.ordinal()];
    }

    @MappedMethod
    public final boolean equals(@Nullable Hand data) {
        return data != null && this.data == data.data;
    }

    @Nonnull
    @MappedMethod
    public static Hand getMainHandMapped() {
        return Hand.convert(InteractionHand.MAIN_HAND);
    }

    @Nonnull
    @MappedMethod
    public static Hand getOffHandMapped() {
        return Hand.convert(InteractionHand.OFF_HAND);
    }
}

