/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.phys.HitResult;
import org.mtr.mapping.annotation.MappedMethod;

@ParametersAreNonnullByDefault
public enum HitResultType {
    MISS(HitResult.Type.MISS),
    BLOCK(HitResult.Type.BLOCK),
    ENTITY(HitResult.Type.ENTITY);

    public final HitResult.Type data;

    private HitResultType(HitResult.Type data) {
        this.data = data;
    }

    public static HitResultType convert(@Nullable HitResult.Type data) {
        return data == null ? null : HitResultType.values()[data.ordinal()];
    }

    @MappedMethod
    public final boolean equals(@Nullable HitResultType data) {
        return data != null && this.data == data.data;
    }

    @Nonnull
    @MappedMethod
    public static HitResultType getMissMapped() {
        return HitResultType.convert(HitResult.Type.MISS);
    }

    @Nonnull
    @MappedMethod
    public static HitResultType getBlockMapped() {
        return HitResultType.convert(HitResult.Type.BLOCK);
    }

    @Nonnull
    @MappedMethod
    public static HitResultType getEntityMapped() {
        return HitResultType.convert(HitResult.Type.ENTITY);
    }
}

