/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import com.mojang.authlib.GameProfile;
import java.io.File;
import java.net.SocketAddress;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.tool.HolderBase;

@ParametersAreNonnullByDefault
public final class PlayerManager
extends HolderBase<PlayerList> {
    public PlayerManager(PlayerList data) {
        super(data);
    }

    @MappedMethod
    public static PlayerManager cast(HolderBase<?> data) {
        return new PlayerManager((PlayerList)data.data);
    }

    @MappedMethod
    public static boolean isInstance(@Nullable HolderBase<?> data) {
        return data != null && data.data instanceof PlayerList;
    }

    @MappedMethod
    public boolean equals(@Nullable Object data) {
        return data instanceof HolderBase && ((PlayerList)this.data).equals(((HolderBase)data).data);
    }

    @Nonnull
    @MappedMethod
    public String[] getOpNames() {
        return ((PlayerList)this.data).m_11308_();
    }

    @Nullable
    @MappedMethod
    public ServerPlayerEntity getPlayer(UUID arg0) {
        ServerPlayer tempData = ((PlayerList)this.data).m_11259_(arg0);
        return tempData == null ? null : new ServerPlayerEntity(tempData);
    }

    @Nullable
    @MappedMethod
    public CompoundTag getUserData() {
        net.minecraft.nbt.CompoundTag tempData = ((PlayerList)this.data).m_6960_();
        return tempData == null ? null : new CompoundTag(tempData);
    }

    @Nullable
    @MappedMethod
    public ServerPlayerEntity getPlayer(String arg0) {
        ServerPlayer tempData = ((PlayerList)this.data).m_11255_(arg0);
        return tempData == null ? null : new ServerPlayerEntity(tempData);
    }

    @Nonnull
    @MappedMethod
    public MinecraftServer getServer() {
        return new MinecraftServer(((PlayerList)this.data).m_7873_());
    }

    @MappedMethod
    public void sendWorldInfo(ServerPlayerEntity arg0, ServerWorld arg1) {
        ((PlayerList)this.data).m_11229_((ServerPlayer)arg0.data, (ServerLevel)arg1.data);
    }

    @MappedMethod
    public boolean canBypassPlayerLimit(GameProfile arg0) {
        return ((PlayerList)this.data).m_5765_(arg0);
    }

    @MappedMethod
    public void remove(ServerPlayerEntity arg0) {
        ((PlayerList)this.data).m_11286_((ServerPlayer)arg0.data);
    }

    @Nullable
    @MappedMethod
    public Text checkCanJoin(SocketAddress arg0, GameProfile arg1) {
        Component tempData = ((PlayerList)this.data).m_6418_(arg0, arg1);
        return tempData == null ? null : new Text(tempData);
    }

    @MappedMethod
    public int getViewDistance() {
        return ((PlayerList)this.data).m_11312_();
    }

    @Nonnull
    @MappedMethod
    public ServerPlayerEntity respawnPlayer(ServerPlayerEntity arg0, boolean arg1) {
        return new ServerPlayerEntity(((PlayerList)this.data).m_11236_((ServerPlayer)arg0.data, arg1));
    }

    @Nullable
    @MappedMethod
    public CompoundTag loadPlayerData(ServerPlayerEntity arg0) {
        net.minecraft.nbt.CompoundTag tempData = ((PlayerList)this.data).m_11224_((ServerPlayer)arg0.data);
        return tempData == null ? null : new CompoundTag(tempData);
    }

    @MappedMethod
    public void setMainWorld(ServerWorld arg0) {
        ((PlayerList)this.data).m_184209_((ServerLevel)arg0.data);
    }

    @MappedMethod
    public void setViewDistance(int arg0) {
        ((PlayerList)this.data).m_11217_(arg0);
    }

    @Nonnull
    @MappedMethod
    public static File getWhitelistFileMapped() {
        return PlayerList.f_11192_;
    }
}

