/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.level.block.state.properties.StairsShape;
import org.mtr.mapping.annotation.MappedMethod;

@ParametersAreNonnullByDefault
public enum StairShape {
    STRAIGHT(StairsShape.STRAIGHT),
    INNER_LEFT(StairsShape.INNER_LEFT),
    INNER_RIGHT(StairsShape.INNER_RIGHT),
    OUTER_LEFT(StairsShape.OUTER_LEFT),
    OUTER_RIGHT(StairsShape.OUTER_RIGHT);

    public final StairsShape data;

    private StairShape(StairsShape data) {
        this.data = data;
    }

    public static StairShape convert(@Nullable StairsShape data) {
        return data == null ? null : StairShape.values()[data.ordinal()];
    }

    @MappedMethod
    public final boolean equals(@Nullable StairShape data) {
        return data != null && this.data == data.data;
    }

    @Nonnull
    @MappedMethod
    public String asString() {
        return this.data.m_7912_();
    }

    @Nonnull
    @MappedMethod
    public static StairShape getStraightMapped() {
        return StairShape.convert(StairsShape.STRAIGHT);
    }

    @Nonnull
    @MappedMethod
    public static StairShape getOuterLeftMapped() {
        return StairShape.convert(StairsShape.OUTER_LEFT);
    }

    @Nonnull
    @MappedMethod
    public static StairShape getOuterRightMapped() {
        return StairShape.convert(StairsShape.OUTER_RIGHT);
    }

    @Nonnull
    @MappedMethod
    public static StairShape getInnerLeftMapped() {
        return StairShape.convert(StairsShape.INNER_LEFT);
    }

    @Nonnull
    @MappedMethod
    public static StairShape getInnerRightMapped() {
        return StairShape.convert(StairsShape.INNER_RIGHT);
    }
}

