/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.mapper;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.DetectedVersion;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import org.apache.commons.io.IOUtils;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.tool.DummyClass;

public final class ResourceManagerHelper
extends DummyClass {
    @MappedMethod
    public static void readResource(Identifier identifier, Consumer<InputStream> consumer) {
        try {
            Optional optionalResource = Minecraft.m_91087_().m_91098_().m_213713_((ResourceLocation)identifier.data);
            optionalResource.ifPresent(resource -> ResourceManagerHelper.readResource(resource, consumer));
        }
        catch (Exception e) {
            ResourceManagerHelper.logException(e);
        }
    }

    @MappedMethod
    public static String readResource(Identifier identifier) {
        String[] string = new String[]{""};
        ResourceManagerHelper.readResource(identifier, (InputStream inputStream2) -> {
            try {
                string[0] = IOUtils.toString((InputStream)inputStream2, (Charset)StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                ResourceManagerHelper.logException(e);
            }
        });
        return string[0];
    }

    @MappedMethod
    public static void readAllResources(Identifier identifier, Consumer<InputStream> consumer) {
        try {
            Minecraft.m_91087_().m_91098_().m_213829_((ResourceLocation)identifier.data).forEach(resource -> ResourceManagerHelper.readResource(resource, consumer));
        }
        catch (Exception e) {
            ResourceManagerHelper.logException(e);
        }
    }

    @MappedMethod
    public static void readDirectory(String path, BiConsumer<Identifier, InputStream> consumer) {
        try {
            Minecraft.m_91087_().m_91098_().m_214160_(path, identifier -> true).forEach((identifier, resources) -> resources.forEach(resource -> ResourceManagerHelper.readResource(resource, (InputStream inputStream2) -> consumer.accept(new Identifier((ResourceLocation)identifier), (InputStream)inputStream2))));
        }
        catch (Exception e) {
            ResourceManagerHelper.logException(e);
        }
    }

    private static void readResource(Resource resource, Consumer<InputStream> consumer) {
        try (InputStream inputStream2 = resource.m_215507_();){
            consumer.accept(inputStream2);
        }
        catch (Exception e) {
            ResourceManagerHelper.logException(e);
        }
    }

    @MappedMethod
    public static int getResourcePackVersion() {
        return DetectedVersion.m_195834_().m_264084_(PackType.CLIENT_RESOURCES);
    }

    @MappedMethod
    public static int getDataPackVersion() {
        return DetectedVersion.m_195834_().m_264084_(PackType.SERVER_DATA);
    }
}

