/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.render.object;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.Closeable;
import org.lwjgl.opengl.GL33;
import org.mtr.mapping.render.batch.MaterialProperties;
import org.mtr.mapping.render.model.Mesh;
import org.mtr.mapping.render.object.IndexBuffer;
import org.mtr.mapping.render.tool.GlStateTracker;
import org.mtr.mapping.render.vertex.VertexAttributeMapping;

public final class VertexArray
implements Closeable {
    private int id = GL33.glGenVertexArrays();
    public final MaterialProperties materialProperties;
    public final IndexBuffer indexBuffer;
    public final VertexAttributeMapping mapping;

    public VertexArray(Mesh mesh, VertexAttributeMapping mapping) {
        this.materialProperties = mesh.materialProperties;
        this.indexBuffer = mesh.indexBuffer;
        this.mapping = mapping;
        GL33.glBindVertexArray((int)this.id);
        mapping.setupAttributesToVao(mesh.vertexBuffer);
        mesh.indexBuffer.bind(34963);
        VertexArray.unbind();
    }

    public void bind() {
        GlStateTracker.assertProtected();
        GL33.glBindVertexArray((int)this.id);
    }

    public static void unbind() {
        GlStateTracker.assertProtected();
        GL33.glBindVertexArray((int)0);
    }

    public void draw() {
        GL33.glDrawElements((int)4, (int)this.indexBuffer.getVertexCount(), (int)this.indexBuffer.indexType, (long)0L);
    }

    @Override
    public void close() {
        if (RenderSystem.isOnRenderThread()) {
            GL33.glDeleteVertexArrays((int)this.id);
            this.id = 0;
        } else {
            RenderSystem.recordRenderCall(this::close);
        }
    }
}

