/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Blocks;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.LivingEntity;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.TextFormatting;
import org.mtr.mapping.holder.TooltipContext;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.BlockPIDSBase;
import org.mtr.mod.block.DoubleVerticalBlock;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.generated.lang.TranslationProvider;

public abstract class BlockPIDSVerticalBase
extends BlockPIDSBase
implements IBlock {
    public BlockPIDSVerticalBase(int maxArrivals) {
        super(maxArrivals, BlockPIDSVerticalBase::canStoreData, BlockPIDSVerticalBase::getBlockPosWithData);
    }

    @Override
    @Nonnull
    public BlockState getStateForNeighborUpdate2(BlockState state, Direction direction, BlockState neighborState, WorldAccess world, BlockPos pos, BlockPos neighborPos) {
        return DoubleVerticalBlock.getStateForNeighborUpdate(state, direction, neighborState.isOf(new Block(this)), super.getStateForNeighborUpdate2(state, direction, neighborState, world, pos, neighborPos));
    }

    @Override
    public void onPlaced2(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        DoubleVerticalBlock.onPlaced(world, pos, state, this.getDefaultState2());
    }

    @Override
    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        return DoubleVerticalBlock.getPlacementState(ctx, this.getDefaultState2());
    }

    @Override
    public void onBreak2(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        DoubleVerticalBlock.onBreak(world, pos, state, player);
        super.onBreak2(world, pos, state, player);
    }

    @Override
    public void addTooltips(ItemStack stack, @Nullable BlockView world, List<MutableText> tooltip, TooltipContext options) {
        BlockEntityExtension blockEntity = this.createBlockEntity(new BlockPos(0, 0, 0), Blocks.getAirMapped().getDefaultState());
        if (blockEntity instanceof BlockPIDSBase.BlockEntityBase) {
            tooltip.add(TranslationProvider.TOOLTIP_MTR_ARRIVALS.getMutableText(this.maxArrivals / 2).formatted(TextFormatting.GRAY));
        }
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add(FACING);
        properties.add(HALF);
    }

    private static boolean canStoreData(World world, BlockPos blockPos) {
        return IBlock.getStatePropertySafe(world, blockPos, HALF) == IBlock.DoubleBlockHalf.UPPER;
    }

    private static BlockPos getBlockPosWithData(World world, BlockPos blockPos) {
        if (BlockPIDSVerticalBase.canStoreData(world, blockPos)) {
            return blockPos;
        }
        return blockPos.up();
    }

    public static abstract class BlockEntityVerticalBase
    extends BlockPIDSBase.BlockEntityBase {
        public BlockEntityVerticalBase(int maxArrivals, BlockEntityType<?> type, BlockPos pos, BlockState state) {
            super(maxArrivals, BlockPIDSVerticalBase::canStoreData, BlockPIDSVerticalBase::getBlockPosWithData, type, pos, state);
        }

        @Override
        public boolean showArrivalNumber() {
            return false;
        }

        @Override
        public boolean alternateLines() {
            return true;
        }

        @Override
        public int textColorArrived() {
            return 0xFF9900;
        }

        @Override
        public int textColor() {
            return 0xFF9900;
        }
    }
}

