/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockWithEntity;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.BlockEntityTypes;
import org.mtr.mod.block.BlockDirectionalDoubleBlockBase;
import org.mtr.mod.block.IBlock;

public class BlockTactileMap
extends BlockDirectionalDoubleBlockBase
implements BlockWithEntity {
    public BlockTactileMap(BlockSettings blockSettings) {
        super(blockSettings);
    }

    @Override
    @Nonnull
    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        if (world.isClient() && BlockEntity.onUse != null) {
            BlockEntity.onUse.accept(pos);
            return ActionResult.SUCCESS;
        }
        return ActionResult.CONSUME;
    }

    @Override
    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        Direction facing = IBlock.getStatePropertySafe(state, FACING);
        if (IBlock.getStatePropertySafe(state, HALF) == IBlock.DoubleBlockHalf.UPPER) {
            return IBlock.getVoxelShapeByDirection(0.0, 0.0, 2.0, 16.0, 7.0, 14.0, facing);
        }
        return VoxelShapes.union(Block.createCuboidShape(4.0, 0.0, 4.0, 12.0, 1.0, 12.0), IBlock.getVoxelShapeByDirection(6.0, 1.0, 7.0, 10.0, 16.0, 9.0, facing));
    }

    @Override
    @Nonnull
    public BlockEntityExtension createBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BlockEntity(blockPos, blockState);
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add(FACING);
        properties.add(HALF);
    }

    public static class BlockEntity
    extends BlockEntityExtension {
        public static BiConsumer<BlockPos, Boolean> updateSoundSource = null;
        public static Consumer<BlockPos> onUse = null;

        public BlockEntity(BlockPos pos, BlockState state) {
            super((BlockEntityType<?>)BlockEntityTypes.TACTILE_MAP.get(), pos, state);
        }

        @Override
        public void blockEntityTick() {
            if (this.getWorld2() != null && this.getWorld2().isClient() && updateSoundSource != null) {
                updateSoundSource.accept(this.getPos2(), false);
            }
        }

        @Override
        public void markRemoved2() {
            if (this.getWorld2() != null && this.getWorld2().isClient() && updateSoundSource != null) {
                updateSoundSource.accept(this.getPos2(), true);
            }
            super.markRemoved2();
        }
    }
}

