/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.item;

import javax.annotation.Nonnull;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.ItemSettings;
import org.mtr.mapping.holder.ItemUsageContext;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.ItemExtension;
import org.mtr.mod.Blocks;
import org.mtr.mod.block.BlockEscalatorBase;
import org.mtr.mod.block.BlockEscalatorSide;
import org.mtr.mod.block.BlockEscalatorStep;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.item.ItemPSDAPGBase;

public class ItemEscalator
extends ItemExtension
implements IBlock {
    public ItemEscalator(ItemSettings itemSettings) {
        super(itemSettings);
    }

    @Override
    @Nonnull
    public ActionResult useOnBlock2(ItemUsageContext context) {
        if (ItemPSDAPGBase.blocksNotReplaceable(context, 2, 2, null)) {
            return ActionResult.FAIL;
        }
        World world = context.getWorld();
        Direction playerFacing = context.getPlayerFacing();
        BlockPos pos1 = context.getBlockPos().offset(context.getSide());
        BlockPos pos2 = pos1.offset(playerFacing.rotateYClockwise());
        BlockState frontState = world.getBlockState(pos1.offset(playerFacing));
        if (frontState.getBlock().data instanceof BlockEscalatorBase && IBlock.getStatePropertySafe(frontState, BlockEscalatorBase.FACING) == playerFacing.getOpposite()) {
            playerFacing = playerFacing.getOpposite();
            BlockPos pos3 = pos1;
            pos1 = pos2;
            pos2 = pos3;
        }
        BlockState stepState = Blocks.ESCALATOR_STEP.get().getDefaultState().with(new Property((net.minecraft.world.level.block.state.properties.Property)BlockEscalatorStep.FACING.data), playerFacing.data);
        world.setBlockState(pos1, stepState.with(new Property((net.minecraft.world.level.block.state.properties.Property)ItemEscalator.SIDE.data), IBlock.EnumSide.LEFT));
        world.setBlockState(pos2, stepState.with(new Property((net.minecraft.world.level.block.state.properties.Property)ItemEscalator.SIDE.data), IBlock.EnumSide.RIGHT));
        BlockState sideState = Blocks.ESCALATOR_SIDE.get().getDefaultState().with(new Property((net.minecraft.world.level.block.state.properties.Property)BlockEscalatorSide.FACING.data), playerFacing.data);
        world.setBlockState(pos1.up(), sideState.with(new Property((net.minecraft.world.level.block.state.properties.Property)ItemEscalator.SIDE.data), IBlock.EnumSide.LEFT));
        world.setBlockState(pos2.up(), sideState.with(new Property((net.minecraft.world.level.block.state.properties.Property)ItemEscalator.SIDE.data), IBlock.EnumSide.RIGHT));
        context.getStack().decrement(1);
        return ActionResult.SUCCESS;
    }
}

