/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import javax.annotation.Nullable;
import net.minecraft.client.gui.components.AbstractWidget;
import org.mtr.core.data.Platform;
import org.mtr.core.data.Station;
import org.mtr.libraries.it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectSet;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MathHelper;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.Screen;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;
import org.mtr.mapping.mapper.ScreenExtension;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.mapper.TexturedButtonWidgetExtension;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.BlockRailwaySign;
import org.mtr.mod.block.BlockRouteSignBase;
import org.mtr.mod.client.CustomResourceLoader;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.data.IGui;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.packet.PacketUpdateRailwaySignConfig;
import org.mtr.mod.render.RenderRailwaySign;
import org.mtr.mod.resource.SignResource;
import org.mtr.mod.screen.DashboardListItem;
import org.mtr.mod.screen.DashboardListSelectorScreen;
import org.mtr.mod.screen.EditStationScreen;
import org.mtr.mod.screen.PIDSConfigScreen;
import org.mtr.mod.screen.TexturedButtonWidgetHelper;

public class RailwaySignScreen
extends ScreenExtension
implements IGui {
    private int editingIndex = -1;
    private int page;
    private int totalPages;
    private int columns;
    private int rows;
    private final BlockPos signPos;
    private final boolean isRailwaySign;
    private final int length;
    private final String[] signIds;
    private final LongAVLTreeSet selectedIds;
    private final ObjectImmutableList<DashboardListItem> exitsForList;
    private final ObjectImmutableList<DashboardListItem> platformsForList;
    private final ObjectArraySet<DashboardListItem> routesForList;
    private final ObjectArraySet<DashboardListItem> stationsForList;
    private final ObjectArrayList<String> allSignIds = new ObjectArrayList();
    private final ButtonWidgetExtension[] buttonsEdit;
    private final ButtonWidgetExtension[] buttonsSelection;
    private final ButtonWidgetExtension buttonClear;
    private final TexturedButtonWidgetExtension buttonPrevPage;
    private final TexturedButtonWidgetExtension buttonNextPage;
    private static final int SIGN_SIZE = 32;
    private static final int SIGN_BUTTON_SIZE = 16;
    private static final int BUTTON_Y_START = 62;

    public RailwaySignScreen(BlockPos signPos) {
        int i;
        this.signPos = signPos;
        ClientWorld world = MinecraftClient.getInstance().getWorldMapped();
        this.allSignIds.addAll((ObjectList<String>)CustomResourceLoader.getSortedSignIds());
        Station station = InitClient.findStation(signPos);
        if (station == null) {
            this.exitsForList = ObjectImmutableList.of();
            this.platformsForList = ObjectImmutableList.of();
            this.stationsForList = new ObjectArraySet();
            this.routesForList = new ObjectArraySet();
        } else {
            this.exitsForList = new ObjectImmutableList<DashboardListItem>((ObjectList<DashboardListItem>)EditStationScreen.getExitsForDashboardList(EditStationScreen.getStationExits(station, true)));
            this.platformsForList = PIDSConfigScreen.getPlatformsForList(new ObjectArrayList<Platform>(station.savedRails));
            ObjectArraySet<Station> connectingStationsIncludingThisOne = new ObjectArraySet<Station>((ObjectSet<Station>)station.connectedStations);
            connectingStationsIncludingThisOne.add(station);
            this.stationsForList = MinecraftClientData.convertDataSet(connectingStationsIncludingThisOne);
            LongAVLTreeSet platformIds = new LongAVLTreeSet();
            connectingStationsIncludingThisOne.forEach(connectingStation -> connectingStation.savedRails.forEach(platform -> platformIds.add(platform.getId())));
            this.routesForList = new ObjectArraySet();
            IntAVLTreeSet addedColors = new IntAVLTreeSet();
            MinecraftClientData.getInstance().simplifiedRoutes.forEach(simplifiedRoute -> {
                int color = simplifiedRoute.getColor();
                if (!addedColors.contains(color) && simplifiedRoute.getPlatforms().stream().anyMatch(simplifiedRoutePlatform -> platformIds.contains(simplifiedRoutePlatform.getPlatformId()))) {
                    this.routesForList.add(new DashboardListItem(color, simplifiedRoute.getName().split("\\|\\|")[0], color));
                    addedColors.add(color);
                }
            });
        }
        if (world != null) {
            BlockEntity entity = world.getBlockEntity(signPos);
            if (entity != null && entity.data instanceof BlockRailwaySign.BlockEntity) {
                this.signIds = ((BlockRailwaySign.BlockEntity)((Object)entity.data)).getSignIds();
                this.selectedIds = ((BlockRailwaySign.BlockEntity)((Object)entity.data)).getSelectedIds();
                this.isRailwaySign = true;
            } else {
                this.signIds = new String[0];
                this.selectedIds = new LongAVLTreeSet();
                this.isRailwaySign = false;
                if (entity != null && entity.data instanceof BlockRouteSignBase.BlockEntityBase) {
                    this.selectedIds.add(((BlockRouteSignBase.BlockEntityBase)((Object)entity.data)).getPlatformId());
                }
            }
            Block block = world.getBlockState(signPos).getBlock();
            this.length = block.data instanceof BlockRailwaySign ? ((BlockRailwaySign)block.data).length : 0;
        } else {
            this.length = 0;
            this.signIds = new String[0];
            this.selectedIds = new LongAVLTreeSet();
            this.isRailwaySign = false;
        }
        this.buttonsEdit = new ButtonWidgetExtension[this.length];
        for (i = 0; i < this.buttonsEdit.length; ++i) {
            int index = i;
            this.buttonsEdit[i] = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.translatable("selectWorld.edit", new Object[0]), button -> this.edit(index));
        }
        this.buttonsSelection = new ButtonWidgetExtension[this.allSignIds.size()];
        for (i = 0; i < this.allSignIds.size(); ++i) {
            int index = i;
            this.buttonsSelection[i] = new ButtonWidgetExtension(0, 0, 0, 16, button -> this.setNewSignId(this.allSignIds.get(index)));
        }
        this.buttonClear = new ButtonWidgetExtension(0, 0, 0, 20, TranslationProvider.GUI_MTR_RESET_SIGN.getMutableText(new Object[0]), button -> this.setNewSignId(null));
        this.buttonPrevPage = TexturedButtonWidgetHelper.create(0, 0, 0, 20, new Identifier("textures/gui/sprites/mtr/icon_left.png"), new Identifier("textures/gui/sprites/mtr/icon_left_highlighted.png"), button -> this.setPage(this.page - 1));
        this.buttonNextPage = TexturedButtonWidgetHelper.create(0, 0, 0, 20, new Identifier("textures/gui/sprites/mtr/icon_right.png"), new Identifier("textures/gui/sprites/mtr/icon_right_highlighted.png"), button -> this.setPage(this.page + 1));
    }

    @Override
    protected void init2() {
        super.init2();
        for (int i = 0; i < this.buttonsEdit.length; ++i) {
            IDrawing.setPositionAndWidth(this.buttonsEdit[i], (this.f_96543_ - 32 * this.length) / 2 + i * 32, 32, 32);
            this.addChild(new ClickableWidget((AbstractWidget)this.buttonsEdit[i]));
        }
        this.columns = Math.max((this.f_96543_ - 48) / 128 * 2, 1);
        this.rows = Math.max((this.f_96544_ - 32 - 80) / 16, 1);
        int xOffsetSmall = (this.f_96543_ - 16 * (this.columns * 4 + 3)) / 2 + 16;
        int xOffsetBig = xOffsetSmall + 16 * (this.columns + 1);
        this.totalPages = this.loopSigns((index, x, y, isBig) -> {
            IDrawing.setPositionAndWidth(this.buttonsSelection[index], (isBig ? xOffsetBig : xOffsetSmall) + x, 62 + y, isBig ? 48 : 16);
            this.buttonsSelection[index].f_93624_ = false;
            this.addChild(new ClickableWidget((AbstractWidget)this.buttonsSelection[index]));
        }, true);
        int buttonClearX = (this.f_96543_ - 144 - 80) / 2;
        int buttonY = this.f_96544_ - 40;
        IDrawing.setPositionAndWidth(this.buttonClear, buttonClearX, buttonY, 144);
        this.buttonClear.f_93624_ = false;
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonClear));
        IDrawing.setPositionAndWidth(this.buttonPrevPage, buttonClearX + 144, buttonY, 20);
        this.buttonPrevPage.f_93624_ = false;
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonPrevPage));
        IDrawing.setPositionAndWidth(this.buttonNextPage, buttonClearX + 144 + 60, buttonY, 20);
        this.buttonNextPage.f_93624_ = false;
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonNextPage));
        if (!this.isRailwaySign) {
            MinecraftClient.getInstance().openScreen(new Screen(new DashboardListSelectorScreen(this::onClose2, this.platformsForList, this.selectedIds, true, false, null)));
        }
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphicsHolder);
        super.render(graphicsHolder, mouseX, mouseY, delta);
        for (int i = 0; i < this.signIds.length; ++i) {
            if (this.signIds[i] == null) continue;
            RenderRailwaySign.drawSign(graphicsHolder, null, this.signPos, this.signIds[i], (float)(this.f_96543_ - 32 * this.length) / 2.0f + (float)(i * 32), 0.0f, 32.0f, RenderRailwaySign.getMaxWidth(this.signIds, i, false), RenderRailwaySign.getMaxWidth(this.signIds, i, true), this.selectedIds, Direction.UP, 0, (textureId, x, y, size, flipTexture) -> {
                GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
                guiDrawing.beginDrawingTexture(textureId);
                guiDrawing.drawTexture(x, y, x + size, y + size, flipTexture ? 1.0f : 0.0f, 0.0f, flipTexture ? 0.0f : 1.0f, 1.0f);
                guiDrawing.finishDrawingTexture();
            });
        }
        if (this.editingIndex >= 0) {
            int xOffsetSmall = (this.f_96543_ - 16 * (this.columns * 4 + 3)) / 2 + 16;
            int xOffsetBig = xOffsetSmall + 16 * (this.columns + 1);
            this.loopSigns((index, x, y, isBig) -> {
                String signId = this.allSignIds.get(index);
                SignResource sign = RenderRailwaySign.getSign(signId);
                if (sign != null) {
                    boolean moveRight = sign.hasCustomText && sign.getFlipCustomText();
                    RenderRailwaySign.drawSign(graphicsHolder, null, this.signPos, signId, (isBig ? xOffsetBig : xOffsetSmall) + x + (moveRight ? 32 : 0), 62 + y, 16.0f, 2.0f, 2.0f, this.selectedIds, Direction.UP, 0, (textureId, x1, y1, size, flipTexture) -> {
                        GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
                        guiDrawing.beginDrawingTexture(sign.getTexture());
                        guiDrawing.drawTexture(x1, y1, x1 + size, y1 + size, flipTexture ? 1.0f : 0.0f, 0.0f, flipTexture ? 0.0f : 1.0f, 1.0f);
                        guiDrawing.finishDrawingTexture();
                    });
                }
            }, false);
            graphicsHolder.drawCenteredText(String.format("%s/%s", this.page + 1, this.totalPages), (this.f_96543_ - 144 - 80) / 2 + 144 + 40, this.f_96544_ - 40 + 6, -1);
        }
    }

    @Override
    public boolean mouseScrolled2(double mouseX, double mouseY, double amount) {
        this.setPage(this.page + (int)Math.signum(-amount));
        return super.mouseScrolled2(mouseX, mouseY, amount);
    }

    @Override
    public void onClose2() {
        InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketUpdateRailwaySignConfig(this.signPos, this.selectedIds, this.signIds));
        super.onClose2();
    }

    @Override
    public boolean isPauseScreen2() {
        return false;
    }

    @Override
    public void resize2(MinecraftClient client, int width, int height) {
        super.resize2(client, width, height);
        for (ButtonWidgetExtension button : this.buttonsEdit) {
            button.f_93623_ = true;
        }
        for (ButtonWidgetExtension button : this.buttonsSelection) {
            button.f_93624_ = false;
        }
        this.editingIndex = -1;
    }

    private int loopSigns(LoopSignsCallback loopSignsCallback, boolean ignorePage) {
        int pageCount = this.rows * this.columns;
        int indexSmall = 0;
        int indexBig = 0;
        int columnSmall = 0;
        int columnBig = 0;
        int rowSmall = 0;
        int rowBig = 0;
        int totalPagesSmallCount = 1;
        int totalPagesBigCount = 1;
        for (int i = 0; i < this.allSignIds.size(); ++i) {
            boolean onPage;
            SignResource sign = RenderRailwaySign.getSign(this.allSignIds.get(i));
            boolean isBig = sign != null && sign.hasCustomText;
            this.buttonsSelection[i].f_93624_ = onPage = (isBig ? indexBig : indexSmall) / pageCount == this.page;
            if (ignorePage || onPage) {
                loopSignsCallback.loopSignsCallback(i, (isBig ? columnBig * 3 : columnSmall) * 16, (isBig ? rowBig : rowSmall) * 16, isBig);
            }
            if (isBig) {
                ++columnBig;
                if (totalPagesBigCount < 0) {
                    totalPagesBigCount = -totalPagesBigCount + 1;
                }
                if (columnBig >= this.columns) {
                    columnBig = 0;
                    if (++rowBig >= this.rows) {
                        rowBig = 0;
                        totalPagesBigCount = -totalPagesBigCount;
                    }
                }
                ++indexBig;
                continue;
            }
            ++columnSmall;
            if (totalPagesSmallCount < 0) {
                totalPagesSmallCount = -totalPagesSmallCount + 1;
            }
            if (columnSmall >= this.columns) {
                columnSmall = 0;
                if (++rowSmall >= this.rows) {
                    rowSmall = 0;
                    totalPagesSmallCount = -totalPagesSmallCount;
                }
            }
            ++indexSmall;
        }
        return Math.max(Math.abs(totalPagesBigCount), Math.abs(totalPagesSmallCount));
    }

    private void edit(int editingIndex) {
        this.editingIndex = editingIndex;
        for (ButtonWidgetExtension button : this.buttonsEdit) {
            button.f_93623_ = true;
        }
        this.buttonClear.f_93624_ = true;
        this.setPage(this.page);
        this.buttonsEdit[editingIndex].f_93623_ = false;
    }

    private void setNewSignId(@Nullable String newSignId) {
        if (this.editingIndex >= 0 && this.editingIndex < this.signIds.length) {
            boolean isStation;
            this.signIds[this.editingIndex] = newSignId;
            boolean isExitLetter = newSignId != null && (newSignId.equals("exit_letter") || newSignId.equals("exit_letter_flipped"));
            boolean isPlatform = newSignId != null && (newSignId.equals("platform") || newSignId.equals("platform_flipped"));
            boolean isLine = newSignId != null && (newSignId.equals("line") || newSignId.equals("line_flipped"));
            boolean bl = isStation = newSignId != null && (newSignId.equals("station") || newSignId.equals("station_flipped"));
            if (isExitLetter || isPlatform || isLine || isStation) {
                MinecraftClient.getInstance().openScreen(new Screen(new DashboardListSelectorScreen(new ObjectImmutableList<DashboardListItem>(isExitLetter ? this.exitsForList : (isPlatform ? this.platformsForList : (isLine ? this.routesForList : this.stationsForList))), this.selectedIds, false, false, this)));
            }
        }
    }

    private void setPage(int newPage) {
        this.page = MathHelper.clamp(newPage, 0, this.totalPages - 1);
        this.buttonPrevPage.f_93624_ = this.editingIndex >= 0 && this.page > 0;
        this.buttonNextPage.f_93624_ = this.editingIndex >= 0 && this.page < this.totalPages - 1;
    }

    @FunctionalInterface
    private static interface LoopSignsCallback {
        public void loopSignsCallback(int var1, int var2, int var3, boolean var4);
    }
}

