/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.servlet;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.mtr.core.Main;
import org.mtr.libraries.okhttp3.Call;
import org.mtr.libraries.okhttp3.Callback;
import org.mtr.libraries.okhttp3.MediaType;
import org.mtr.libraries.okhttp3.OkHttpClient;
import org.mtr.libraries.okhttp3.Request;
import org.mtr.libraries.okhttp3.RequestBody;
import org.mtr.libraries.okhttp3.Response;
import org.mtr.libraries.okhttp3.ResponseBody;

public final class RequestHelper {
    private final OkHttpClient okHttpClient = new OkHttpClient.Builder().connectTimeout(2L, TimeUnit.SECONDS).writeTimeout(2L, TimeUnit.SECONDS).readTimeout(2L, TimeUnit.SECONDS).build();

    public void sendRequest(String url, @Nullable String content, final @Nullable BiConsumer<String, String> callback) {
        Request.Builder requestBuilder = new Request.Builder().url(url);
        Request request = content == null ? requestBuilder.get().build() : requestBuilder.post(RequestBody.create(content, MediaType.get("application/json"))).build();
        Call call = this.okHttpClient.newCall(request);
        call.enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                if (!(e instanceof InterruptedIOException)) {
                    Main.LOGGER.error((Object)call.request().url(), (Throwable)e);
                }
            }

            @Override
            public void onResponse(Call call, Response response) {
                block9: {
                    try (ResponseBody responseBody = response.body();){
                        if (callback != null) {
                            callback.accept(responseBody.string(), response.request().url().url().getFile());
                        }
                    }
                    catch (IOException e) {
                        if (e instanceof InterruptedIOException) break block9;
                        Main.LOGGER.error((Object)call.request().url(), (Throwable)e);
                    }
                }
            }
        });
    }
}

