/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.sound;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mod.sound.BveMotorDataBase;
import org.mtr.mod.sound.BveVehicleSoundConfig;

public class BveMotorData5
extends BveMotorDataBase {
    private final FloatSplines powerVolume;
    private final FloatSplines powerFrequency;
    private final FloatSplines brakeVolume;
    private final FloatSplines brakeFrequency;
    private final int soundCount;

    public BveMotorData5(String baseName) {
        this.powerVolume = new FloatSplines(BveVehicleSoundConfig.readResource(new Identifier(baseName + "/powervol.csv")));
        this.powerFrequency = new FloatSplines(BveVehicleSoundConfig.readResource(new Identifier(baseName + "/powerfreq.csv")));
        this.brakeVolume = new FloatSplines(BveVehicleSoundConfig.readResource(new Identifier(baseName + "/brakevol.csv")));
        this.brakeFrequency = new FloatSplines(BveVehicleSoundConfig.readResource(new Identifier(baseName + "/brakefreq.csv")));
        this.soundCount = Math.max(Math.max(this.powerVolume.data.size(), this.powerFrequency.data.size()), Math.max(this.brakeVolume.data.size(), this.brakeFrequency.data.size()));
    }

    @Override
    public int getSoundCount() {
        return this.soundCount;
    }

    @Override
    public float getPitch(int index, float speed, float power) {
        if (power == 0.0f) {
            return 0.0f;
        }
        return power > 0.0f ? this.powerFrequency.getValue(index, speed) : this.brakeFrequency.getValue(index, speed);
    }

    @Override
    public float getVolume(int index, float speed, float power) {
        if (power == 0.0f) {
            return 0.0f;
        }
        return (power > 0.0f ? this.powerVolume.getValue(index, speed) : this.brakeVolume.getValue(index, speed)) * Math.abs(power);
    }

    public static class FloatSplines {
        public List<TreeMap<Float, Float>> data = new ArrayList<TreeMap<Float, Float>>();

        public FloatSplines(String textContent) {
            String[] lines;
            for (String line : lines = textContent.split("[\\r\\n]+")) {
                String[] tokens;
                String lineTrim = line.trim().toLowerCase(Locale.ENGLISH);
                if (StringUtils.isEmpty((CharSequence)lineTrim) || lineTrim.startsWith("#") || lineTrim.startsWith("//") || lineTrim.startsWith("bvets") || (tokens = lineTrim.split(",")).length == 0) continue;
                while (this.data.size() < tokens.length - 1) {
                    this.data.add(new TreeMap());
                }
                float key = Float.parseFloat(tokens[0].trim());
                for (int i = 1; i < tokens.length; ++i) {
                    String tokenTrim = tokens[i].trim();
                    if (tokenTrim.isEmpty()) continue;
                    this.data.get(i - 1).put(Float.valueOf(key), Float.valueOf(Float.parseFloat(tokenTrim)));
                }
            }
        }

        public float getValue(int index, float key) {
            if (index >= this.data.size()) {
                return 0.0f;
            }
            TreeMap<Float, Float> spline = this.data.get(index);
            if (spline.isEmpty()) {
                return 0.0f;
            }
            Map.Entry<Float, Float> floorEntry = spline.floorEntry(Float.valueOf(key));
            Map.Entry<Float, Float> ceilingEntry = spline.ceilingEntry(Float.valueOf(key));
            if (floorEntry == null) {
                return ceilingEntry.getValue().floatValue();
            }
            if (ceilingEntry == null) {
                return floorEntry.getValue().floatValue();
            }
            if (Objects.equals(floorEntry.getKey(), ceilingEntry.getKey())) {
                return floorEntry.getValue().floatValue();
            }
            return floorEntry.getValue().floatValue() + (ceilingEntry.getValue().floatValue() - floorEntry.getValue().floatValue()) * ((key - floorEntry.getKey().floatValue()) / (ceilingEntry.getKey().floatValue() - floorEntry.getKey().floatValue()));
        }
    }
}

