//古城
LootJS.modifiers(event => {//远古城市        
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:coal'],//煤炭
        ['minecraft:book'],//书
        ['minecraft:bone'],//骨头
        ['minecraft:diamond_hoe'],//钻石锄
        ['minecraft:glow_berries'],//发光浆果
        ['minecraft:candle'],//蜡烛
        ['minecraft:soul_torch'],//灵魂火把
        ['minecraft:name_tag'],//命名牌
        ['minecraft:compass'],//指南针
        ['minecraft:lead'],//拴绳
        ['minecraft:amethyst_shard'],//紫水晶碎片
        ['minecraft:diamond_horse_armor'],//钻石马铠
        ['minecraft:disc_fragment_5'],//唱片碎片
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:saddle'],//鞍 
        ['minecraft:potion'],//再生药水
        [Item.of('minecraft:iron_leggings')],//铁护腿
        [Item.of('minecraft:diamond_leggings')],//钻石护腿
        ['minecraft:experience_bottle'],//附魔之瓶
        ['galosphere:spectre_flare'],//幽荧照明弹
        ['minecraft:music_disc_13'],//13号唱片
        ['minecraft:music_disc_cat'],//猫唱片
        ['minecraft:music_disc_otherside'],//唱片
        ['minecraft:ward_armor_trim_smithing_template'],//锻造模板
        ['deeperdarker:warden_upgrade_smithing_template'],//锻造模板
    ]
    //定义添加权重物品[物品id,权重]
    let weightLootItem = [
        ['ltc2:sculk_mint', 3],//辣条工艺2 幽匿薄荷
        ['dungeonsdelight:wardenzola_crumbles', 1],//地牢乐事 幽匿蓝纹奶酪碎
        ['dungeonsdelight:sculk_apple', 3], //地牢乐事 幽匿苹果
        ['dungeonsdelight:sculk_mayo', 1],//地牢乐事 幽匿蛋黄酱
        ['silentsdelight:warden_ear', 3],//美味的寂静（幽匿乐事） 坚守者耳
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币  
    ]
    //定义添加权重物品[物品id,概率]
    let lootItem = [
        ['enigmaticlegacy:darkest_scroll', 0.1],//神秘遗物 至暗卷轴
        ['bountifulfares:hoary_apple', 0.15],//丰饶食记 朽老苹果
        ['lightmanscurrency:coin_emerald', 0.15],//硬币与物品 绿宝石币
        ['vintagedelight:century_egg', 0.05],//腌渍乐事 松花蛋（厨神之证）
        ['enigmaticlegacy:unholy_grail',0.1],//神秘遗物 不洁圣杯
        ['immortalers_delight:enchanted_golden_himekaido',0.2],//千古乐事 金魔法果
    ]
//遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/ancient_city')//远古城市
            //随机抽取2-3次weightLootItem里面的参数
            .addWeightedLoot([3, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/ancient_city')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/ancient_city')//远古城市
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//废弃矿井
LootJS.modifiers(event => {  //废弃矿井
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:coal'],//煤炭
        ['minecraft:glow_berries'],//发光浆果
        ['minecraft:compass'],//指南针
        ['minecraft:beetroot_seeds'],//甜菜种子
        ['minecraft:melon_seeds'],//西瓜种子
        ['minecraft:rail'],//铁轨
        ['minecraft:powered_rail'],//动力铁轨
        ['minecraft:activator_rail'],//激活铁轨
        ['minecraft:detector_rail'],//探测铁轨
        ['minecraft:leather'],//皮革
        ['minecraft:iron_ingot'],//铁
        ['minecraft:gold_ingot'],//金
        ['minecraft:emerald'],//绿宝石
        ['minecraft:diamond'],//钻石
        ['minecraft:lapis_lazuli'],//青金石
        ['minecraft:redstone'],//红石
        ['additionaladditions:rope'],//绳子
        ['supplementaries:rope'],//绳索
        ['farmersdelight:rope'],//绳子
        ['additionaladditions:glow_stick'],//荧光棒
        ['muffins_thaidelight:pepper_seeds'],//辣椒种子
        ['minecraft:torch'],//火把
        ['dumplings_delight:chinese_cabbage_seeds'],//白菜种子
        [('minecraft:clock')],//钟
        [Item.of('minecraft:iron_axe')],//铁斧头
        ['farmersdelight:cabbage_seeds'],//卷心菜种子
        ['additionaladditions:rose_gold_upgrade'],//锻造模板
        ['minecraft:pumpkin_seeds'],//南瓜种子
        ['galosphere:silver_upgrade_smithing_template'],//锻造模板
        [Item.of('minecraft:potion', '{Potion:"ars_nouveau:mana_regen_potion_long"}')],//药水
        ['ars_nouveau:music_disc_aria_biblio'],//唱片
    ]

    //定义添加权重物品[物品id,权重]
    let weightLootItem = [
        ['bountifulfares:stone_stew', 2],//丰饶食记 石头炖
        ['vanillacookbook:miners_salad', 2],//原版烹饪书 矿工沙拉
        ['mineraldelight:geode_carrot', 1],//矿工乐事 晶簇胡萝卜
        ['mineraldelight:dazzling_candy', 2],//矿工乐事 炫目糖果
        ['mineraldelight:diamond_biscuit', 1],//矿工乐事 钻石饼干
        ['mineraldelight:amethyst_apple', 2],//矿工乐事 紫金苹果
        ['mineraldelight:lapis_mochi', 2],//矿工乐事 青金石团子
        ['mineraldelight:pebble_in_a_bowl', 2],//矿工乐事 碗装鹅卵石
        ['composite_material:dungeon_steel_ingot', 1],//复合材料 地牢钢锭
        ['mineraldelight:golden_dough', 1],//矿工乐事 金色面团
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]

    //定义添加权重物品[物品id,概率]
    let lootItem = [
        ['mineraldelight:shining_broth', 0.2],//矿工乐事 闪亮肉汤
        ['galospheric_delight:fruits_in_amethyst_dust', 0.1],//晶界飨宴 紫金渍果
        ['mineraldelight:amethyst_carrot', 0.1],//矿工乐事 紫金胡萝卜
        ['mineraldelight:diamond_jello', 0.2],//矿工乐事 钻石果冻
    ]
    
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/abandoned_mineshaft')//废弃矿井
            //随机抽取1-4次weightLootItem里面的参数
            .addWeightedLoot([1, 4], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/abandoned_mineshaft')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/abandoned_mineshaft')//废弃矿井
            .removeLoot(item)//删除遍历removeLoot的物品

     })
    })


//堡垒遗迹桥
LootJS.modifiers(event => {//堡垒遗迹桥
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:string'],//线
        ['minecraft:arrow'],//箭
        ['minecraft:spectral_arrow'],//光灵箭
        ['minecraft:leather'],//皮革
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:iron_nugget'],//铁粒
        [Item.of('minecraft:golden_leggings', '{Damage:0}')],//金护腿
        [Item.of('minecraft:golden_pickaxe', '{Damage:0}')],//金稿
        [Item.of('minecraft:golden_axe', '{Damage:0}')],//金斧
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['mynethersdelight:hoglin_loin', 20],//下界乐事 疣猪兽腰肉
        ['mynethersdelight:ghasta', 30],//下界乐事 恶魂意面
        ['mynethersdelight:strider_rock', 20],//下界乐事 炽足兽岩壳蛋
        ['lightmanscurrency:coin_gold',10],//硬币与物品 金币
        ['minecraft:cooked_porkchop',30],//熟猪肉
    ]

    let lootItem = [
        ['minecraft:netherite_scrap', 0.3],//下界合金碎片
        ['mynethersdelight:hotdog_with_mixed_salad', 0.1],//下界乐事 混合沙拉热狗
        ['mynethersdelight:hotdog', 0.2],//下界乐事 热狗
        ['mynethersdelight:hotdog_with_nether_salad', 0.1],//下界乐事 下界沙拉热狗
        ['mynethersdelight:chilidog', 0.1],//火辣热狗
        ['mynethersdelight:resurgent_soil', 0.3],//下界乐事 复生沃土
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/bastion_bridge')//堡垒遗迹桥
            //随机抽取2-4次weightLootItem里面的参数
            .addWeightedLoot([2, 4], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/bastion_bridge')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/bastion_bridge')//堡垒遗迹桥
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//堡垒遗迹疣猪兽棚
LootJS.modifiers(event => {//堡垒遗迹疣猪兽棚
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:string'],//线
        ['minecraft:arrow'],//箭
        ['minecraft:crimson_roots'],//绯红索菌
        ['minecraft:soul_sand'],//灵魂沙
        ['minecraft:crimson_nylium'],//绯红菌岩
        ['minecraft:glowstone'],//萤石
        ['minecraft:gold_nugget'],//金粒
        [Item.of('minecraft:golden_leggings', '{Damage:0}')],//金护腿
        [Item.of('minecraft:golden_pickaxe', '{Damage:0}')],//金稿
        [Item.of('minecraft:golden_axe', '{Damage:0}')],//金斧
    ]
    //定义添加权重物品[物品id,权重]
    let weightLootItem = [
        ['mynethersdelight:hoglin_loin', 2],//下界乐事 疣猪兽腰肉
        ['mynethersdelight:ghasta', 3],//下界乐事 恶魂意面
        ['mynethersdelight:strider_rock', 2],//下界乐事 炽足兽岩壳蛋
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
        ['minecraft:cooked_porkchop',30],//熟猪肉
    ]
    let lootItem = [
        ['minecraft:netherite_scrap', 0.3],//下界合金碎片
        ['mynethersdelight:sausage_and_potatoes', 0.3],//下界乐事 香肠配土豆
        ['mynethersdelight:red_loin_on_a_stick', 0.3],//下界乐事 赤红腰肉烤串
        ['mynethersdelight:resurgent_soil', 0.3],//下界乐事 复生沃土
    ]
//遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/bastion_hoglin_stable')//堡垒遗迹疣猪兽棚
            //随机抽取1-4次weightLootItem里面的参数
            .addWeightedLoot([1, 4], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/bastion_hoglin_stable')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/bastion_hoglin_stable')//堡垒遗迹疣猪兽棚
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//堡垒遗迹塔尖
LootJS.modifiers(event => {//堡垒遗迹塔尖
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:string'],//线
        ['minecraft:arrow'],//箭
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:spectral_arrow'],//光灵箭
        ['minecraft:iron_nugget'],//铁粒
        ['minecraft:chain'],//锁链
        ['minecraft:lava_bucket'],//熔岩桶
        ['minecraft:crossbow'],//弩
        ['minecraft:obsidian'],//黑曜石
        ['minecraft:bone_block'],//骨块
        [Item.of('minecraft:golden_leggings', '{Damage:0}')],//金护腿
        [Item.of('minecraft:golden_pickaxe', '{Damage:0}')],//金稿
        [Item.of('minecraft:golden_axe', '{Damage:0}')],//金斧
    ]
  //定义添加权重物品[物品id,权重]
    let weightLootItem = [
        ['mynethersdelight:hoglin_loin', 2],//下界乐事 疣猪兽腰肉
        ['mynethersdelight:ghasta', 3],//下界乐事 恶魂意面
        ['mynethersdelight:strider_rock', 2],//下界乐事 炽足兽岩壳蛋
        ['minecraft:cooked_porkchop',3],//熟猪肉
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
     let lootItem = [
        ['minecraft:netherite_scrap', 0.3],//下界合金碎片
        ['mynethersdelight:spicy_skewer', 0.2],//下界乐事 辛辣烤串
        ['mynethersdelight:spicy_cotton', 0.2],//下界乐事 辛辣面花串
        ['mynethersdelight:resurgent_soil', 0.3],//下界乐事 复生沃土
     ]

//遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/bastion_other')//堡垒遗迹塔尖
            //随机抽取1-4次weightLootItem里面的参数
            .addWeightedLoot([1, 5], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/bastion_other')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/bastion_other')//堡垒遗迹塔尖
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//堡垒遗迹宝藏室
LootJS.modifiers(event => {//堡垒遗迹宝藏室
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:quartz'],//下界石英
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:spectral_arrow'],//光灵箭
        ['minecraft:crying_obsidian'],//哭泣黑曜石
        ['touhou_little_maid:power_point'],//p点
        ['minecraft:netherite_upgrade_smithing_template'],//锻造模板
        [Item.of('minecraft:diamond_sword', '{Damage:0}')],//钻石剑
        [Item.of('farmersdelight:diamond_knife', '{Damage:0}')],//钻石刀
        ['minecraft:iron_ingot'],//铁
        ['sophisticatedbackpacks:gold_backpack'],//金背包
        ['minecraft:iron_block'],//铁块
        ['touhou_little_maid:shrine',],//神龛
        [Item.of('minecraft:diamond_chestplate', '{Damage:91}')],//钻石甲
        ['ars_nouveau:wixie_shards'],//药水
        ['nethervinery:crimson_grape_seeds'],//种子
        ['sophisticatedbackpacks:feeding_upgrade'],//喂食升级
        [Item.of('minecraft:diamond_helmet', '{Damage:13}')],//钻石头盔
        ['minecraft:gold_block'],//金块
        ['minecraft:gold_ingot'],//金子
        [Item.of('minecraft:potion', '{Potion:"ars_nouveau:mana_regen_potion_long"}')],//药水
        ['ars_nouveau:amplify_arrow'],//箭
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['lightmanscurrency:coin_emerald', 5],//硬币与物品 绿宝石币
        ['composite_material:dungeon_steel_ingot', 30],//复合材料 地牢钢锭
        ['terramity:daemonium_chunk', 30],//terramity 恶魔碎块
        ['farmersdelight:ham',30],//农夫乐事 火腿
        ['immortalers_delight:golden_kwat_toast_slice',30],//千古乐事 金瓦斯麦吐司碎片
        ['brewinandchewin:scarlet_cheese_wheel',5],//饮酒作乐 绯红奶酪轮
        ['midashunger:cooked_golden_porkchop',30],//食物与饮品 金熟猪排
    ]
    let lootItem = [
        ['minecraft:netherite_scrap', 0.5],//下界合金碎片
        ['minecraft:netherite_ingot', 0.3],//下界合金锭
        [Item.of('minecraft:netherite_pickaxe', '{Damage:0}').enchant('minecraft:unbreaking', 3).enchant('minecraft:fortune', 1).enchant('minecraft:efficiency', 3).enchant('minecraft:vanishing_curse', 1),0.5],//下界合金稿
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/bastion_treasure')//堡垒遗迹宝藏室
            //随机抽取1-4次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/bastion_treasure')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/bastion_treasure')//堡垒遗迹宝藏室
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//下界要塞
LootJS.modifiers(event => {//下界要塞
//定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:wither_rose'],//凋灵玫瑰
        ['minecraft:nether_wart'],//下界疣
        ['minecraft:lava_bucket'],//熔岩桶
        ['minecraft:flint_and_steel'],//打火石
        ['minecraft:golden_horse_armor'],//黄金马铠
        ['minecraft:diamond_horse_armor'],//钻石马铠
        ['minecraft:saddle'],//鞍
        ['minecraft:emerald'],//绿宝石
        ['ars_nouveau:sourceberry_bush'],//魔源浆果丛
        [Item.of('minecraft:golden_chestplate', '{Damage:0}')],//金胸甲
        [Item.of('minecraft:golden_sword', '{Damage:0}')],//金剑
        ['minecraft:iron_horse_armor'],//铁马恺
        [Item.of('minecraft:golden_shovel', '{Damage:0}')],//金铲
    ]

    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['netherdepthsupgrade:warped_kelp',10],//炽海生机 诡异海带
        ['netherdepthsupgrade:crimson_kelp',10],//炽海生机 绯红海带
        ['terramity:daemonium_chunk', 2],//terramity 恶魔碎块
        ['composite_material:dungeon_steel_ingot', 2],//复合材料 地牢钢锭
        ['mynethersdelight:strider_rock',10],//下界乐事 炽足兽岩壳蛋
        ['mynethersdelight:golden_egg',10],//下界乐事 金蛋
        ['lightmanscurrency:coin_gold',10],//硬币与物品 金币
    ]
    let lootItem = [
        ['minecraft:netherite_scrap', 0.3],//下界合金碎片
        ['enigmaticlegacy:darkest_scroll', 0.3],//神秘遗物 至暗卷轴
        ['mynethersdelight:enchanted_golden_egg', 0.2],//下界乐事 附魔金蛋
        ['mynethersdelight:nether_burger', 0.2],//下界乐事 下界汉堡
        ['mynethersdelight:strider_slice',0.4],//下界乐事 炽足兽肉片
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/nether_bridge')//下界要塞
            //随机抽取2-4次weightLootItem里面的参数
            .addWeightedLoot([2, 4], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/nether_bridge')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/nether_bridge')//下界要塞
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})

//沉船宝箱
LootJS.modifiers(event => {//沉船宝箱
//定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:iron_nugget'],//铁粒
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:emerald'],//绿宝石
        ['minecraft:gold_ingot'],//金
        ['minecraft:iron_ingot'],//铁
        ['additionaladditions:rose_gold_upgrade'],//锻造模板
        [Item.of('beachparty:rubber_ring_pelican', '{Damage:0}')],//泳圈
        ['beachparty:overgrown_disc'],//唱片
        ['minecraft:coast_armor_trim_smithing_template'],//锻造模板
        ['minecraft:lapis_lazuli'],//青金石
        [Item.of('jellyfishing:jellyfish_net', '{Damage:0}')],//水母网
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['alexsmobs:lobster_tail', 2],//龙虾尾
        ['crabbersdelight:clawster', 2],//龙虾
        ['crabbersdelight:crab', 2],//螃蟹
        ['minecraft:nautilus_shell',2],//鹦鹉螺壳
        ['bountifulfares:citrus_essence',2],//柑橘精华
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
        ['minecraft:sea_pickle',2],//海泡菜
    ]
    let lootItem = [
        ['crabbersdelight:kelp_shake', 0.3],//蟹农乐事 海带奶昔
        ['collectorsreap:lunar_pearl',0.05],//collectors reap  月光珍珠
        ['crabbersdelight:sea_pickle_juice',0.3],//蟹农乐事 海泡菜汁
        ['vanillacookbook:stuffed_sea_pickle', 0.2],//原版烹饪书 填馅海泡菜
        ['confluence:ancient_chisel',0.1],//泰拉饰品 远古凿子

    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/shipwreck_treasure')//沉船宝箱
            //随机抽取2-4次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/shipwreck_treasure')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/shipwreck_treasure')//沉船宝箱
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//小型水下废墟
LootJS.modifiers(event => {//小型水下废墟
        //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:coal'],//煤炭
        ['minecraft:stone_axe'],//石斧
        ['minecraft:wheat'],//小麦
        ['minecraft:rotten_flesh'],//腐肉
        ['minecraft:leather_chestplate'],//皮革外套
        ['minecraft:leather'],//皮革
        ['minecraft:iron_nugget'],//铁粒
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:emerald'],//绿宝石
        ['minecraft:gold_ingot'],//金
        ['minecraft:iron_ingot'],//铁
        ['additionaladditions:rose_gold_upgrade'],//锻造模板
        [Item.of('beachparty:rubber_ring_pelican', '{Damage:0}')],//泳圈
        ['beachparty:overgrown_disc'],//唱片
        ['minecraft:coast_armor_trim_smithing_template'],//锻造模板
        ['minecraft:lapis_lazuli'],//青金石
        ['rustic_engineer:book_abyssal_submarine'],//书
        ['ars_nouveau:pierce_arrow'],//箭
        [Item.of('minecraft:potion', '{Potion:"ars_nouveau:mana_regen_potion"}')],//药水
        ['ars_nouveau:amplify_arrow'],//强化箭
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['alexsmobs:lobster_tail', 3],//龙虾尾
        ['crabbersdelight:clawster', 3],//龙虾
        ['crabbersdelight:crab', 3],//螃蟹
        ['minecraft:nautilus_shell',3],//鹦鹉螺壳
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币
        ['minecraft:sea_pickle',5],//海泡菜
        ['kitchenkarrot:kelp_with_sunflower_seed',3],//胡萝卜厨房 爪子海带干
        ['kitchenkarrot:crispy_bread_with_kelp',1],//胡萝卜厨房 酥脆海带面包
        ['vanillacookbook:kelp_salad',1],//原版烹饪书 凉拌海带
    ]
    let lootItem = [
        ['crabbersdelight:kelp_shake', 0.3],//蟹农乐事 海带奶昔
        ['collectorsreap:lunar_pearl',0.1],//collectors reap  月光珍珠
        ['crabbersdelight:sea_pickle_juice',0.3],//蟹农乐事 海泡菜汁
        ['aquaculture:neptunium_ingot', 0.1],//水产 海王锭
        ['minecraft:turtle_egg',0.4]//海龟蛋

    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/underwater_ruin_small')//小型水下废墟
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/underwater_ruin_small')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/underwater_ruin_small')//小型水下废墟
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})
//大型水下废墟
LootJS.modifiers(event => {//大型水下废墟
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:coal'],//煤炭
        ['minecraft:stone_axe'],//石斧
        ['minecraft:wheat'],//小麦
        ['minecraft:rotten_flesh'],//腐肉
        ['minecraft:leather_chestplate'],//皮革外套
        ['minecraft:leather'],//皮革
        ['minecraft:iron_nugget'],//铁粒
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:emerald'],//绿宝石
        ['minecraft:gold_ingot'],//金
        ['minecraft:iron_ingot'],//铁
        ['additionaladditions:rose_gold_upgrade'],//锻造模板
        [Item.of('beachparty:rubber_ring_pelican', '{Damage:0}')],//泳圈
        ['beachparty:overgrown_disc'],//唱片
        ['minecraft:coast_armor_trim_smithing_template'],//锻造模板
        ['minecraft:lapis_lazuli'],//青金石
        ['rustic_engineer:book_abyssal_submarine'],//书
        ['ars_nouveau:pierce_arrow'],//箭
        [Item.of('minecraft:potion', '{Potion:"ars_nouveau:mana_regen_potion"}')],//药水
        ['ars_nouveau:amplify_arrow'],//强化箭
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [['alexsmobs:lobster_tail', 3],//龙虾尾
        ['crabbersdelight:clawster', 2],//龙虾
        ['crabbersdelight:crab', 3],//螃蟹
        ['minecraft:nautilus_shell',3],//鹦鹉螺壳
        ['lightmanscurrency:coin_gold',2],//硬币与物品 金币
        ['minecraft:sea_pickle',5],//海泡菜
        ['kitchenkarrot:kelp_with_sunflower_seed',3],//胡萝卜厨房 爪子海带干
        ['kitchenkarrot:crispy_bread_with_kelp',1],//胡萝卜厨房 酥脆海带面包
        ['vanillacookbook:kelp_salad',1],//原版烹饪书 凉拌海带
    ]
    let lootItem = [
        ['crabbersdelight:kelp_shake', 0.3],//蟹农乐事 海带奶昔
        ['collectorsreap:lunar_pearl',0.1],//collectors reap  月光珍珠
        ['crabbersdelight:sea_pickle_juice',0.3],//蟹农乐事 海泡菜汁
        ['aquaculture:neptunium_ingot', 0.1],//水产 海王锭
        ['minecraft:turtle_egg',0.4]//海龟蛋

    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/underwater_ruin_big')//大型水下废墟
            //随机抽取2-3次weightLootItem里面的参数
            .addWeightedLoot([3, 4], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/underwater_ruin_big')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/underwater_ruin_big')//大型水下废墟
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//沙漠神殿
LootJS.modifiers(event => {//沙漠神殿
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:sand'],//沙子
        ['minecraft:leather'],//皮革
        ['minecraft:rotten_flesh'],//腐肉
        ['minecraft:arrow'],//箭
        ['minecraft:bone'],//骨头
        ['minecraft:gunpowder'],//火药
        ['minecraft:spider_eye'],//蜘蛛眼
        ['minecraft:string'],//线
        ['minecraft:pumpkin_pie'],//南瓜派
        ['minecraft:gold_ingot'],//金
        [Item.of('minecraft:potion', '{Potion:"ars_nouveau:mana_regen_potion_long"}')],//药水
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['beachparty:icecream_cactus', 2],//海滩派对 仙人掌棒冰 
        ['delightful:cactus_flesh', 3],//农夫乐事 仙人掌肉
        ['vanillacookbook:cactus_soda', 1],//原版烹饪书 仙人掌汽水
        ['delightful:prickly_pear_juice', 1],//农夫乐事 仙人掌果汁
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
        ['ecologics:prickly_pear',3],//丰富生态 仙人掌果
    ]
    let lootItem = [
        ['natures_spirit:desert_turnip',0.2],//自然之灵 沙漠芜菁
        ['delightful:cactus_chili',0.1],//农夫乐事 辣子仙人掌
        ['delightful:cactus_soup',0.1],//农夫乐事 仙人掌汤
        ['enigmaticlegacy:darkest_scroll', 0.1],//神秘遗物 至暗卷轴
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/desert_pyramid')//沙漠神殿
            //随机抽取2-3次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/desert_pyramid')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/desert_pyramid')//沙漠神殿
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//末地城
LootJS.modifiers(event => {//末地城
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:beetroot_seeds'],//甜菜种子
        ['minecraft:iron_ingot'],//铁锭
        ['minecraft:gold_ingot'],//金锭
        ['minecraft:iron_horse_armor'],//铁马铠
        ['minecraft:golden_carrot'],//金胡萝卜
        ['minecraft:glistering_melon_slice'],//金西瓜
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:saddle'],//鞍
        ['minecraft:cake'],//蛋糕
        ['minecraft:iron_pickaxe'],//铁镐
        ['minecraft:iron_shovel'],//铁铲
        ['minecraft:iron_sword'],//铁剑
        ['minecraft:iron_helmet'],//铁头盔
        ['minecraft:iron_chestplate'],//铁胸甲
        ['minecraft:iron_leggings'],//铁护腿
        ['minecraft:iron_boots'],//铁靴
        ['minecraft:enchanting_table'],//附魔台
        ['minecraft:ender_eye'],//末影之眼
        ['minecraft:ender_pearl'],//末影珍珠
        ['touhou_little_maid:shrine'],//神龛
        ['simplyswords:runic_tablet'],//符文石板
        ['enigmaticlegacy:recall_potion'],//召回药水
        ['minecraft:phantom_membrane'],//幻翼膜
        ['minecraft:diamond_horse_armor'],//钻石马铠
        ['enigmaticlegacy:lore_inscriber'],//设计师的墨水
        ['minecraft:golden_horse_armor'],//金马铠
        ['minecraft:end_crystal'],//末地水晶
        ['simplyswords:sword_on_a_stick'],//一把奇怪的武器
        ['minecraft:diamond_helmet'],//钻石头盔
        ['minecraft:diamond_chestplate'],//钻石胸甲
        ['minecraft:diamond_leggings'],//钻石护腿
        ['minecraft:diamond_boots'],//钻石靴
        ['minecraft:diamond_pickaxe'],//钻石镐
        ['minecraft:diamond_shovel'],//钻石铲
        ['minecraft:diamond_sword'],//钻石剑
        ['ars_nouveau:pierce_arrow'],//法术箭
        ['minecraft:diamond']//钻石
    ]

    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['minecraft:chorus_fruit',20],//紫颂果
        ['enigmaticlegacy:astral_dust', 5],//神秘遗物 星尘
        ['exquisito:chorus_gummy',5],//食物与饮品 紫颂果软糖
        ['exquisito:chorus_ice_cream',5],//食物与饮品 紫颂果冰激凌
        ['ends_delight:chorus_succulent',20],//末地乐事 末地多肉植物
        ['ends_delight:chorus_cookie',10],//末地乐事 紫颂曲奇
        ['lightmanscurrency:coin_gold',10],//硬币与物品 金币
    ]
    let lootItem = [
        ['enigmaticlegacy:etherium_ore', 0.2],//神秘遗物 以太矿石
        ['ends_delight:dragon_breath_and_chorus_soup',0.2],//末地乐事 龙息紫颂汤
        ['kitchenkarrot:chorus_mousse',0.2],//胡罗卜厨房 紫颂果慕斯
        ['minecraft:dragon_breath',0.4],//龙息
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/end_city_treasure')//末地城
            //随机抽取1-3次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/end_city_treasure')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/end_city_treasure')//末地城
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//雪屋
LootJS.modifiers(event => {//雪屋
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:string'],//线
        ['minecraft:arrow'],//箭
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:spectral_arrow'],//光灵箭
        ['minecraft:iron_nugget'],//铁粒
        ['minecraft:chain'],//锁链
        ['minecraft:lava_bucket'],//熔岩桶
        ['minecraft:crossbow'],//弩
        ['minecraft:obsidian'],//黑曜石
        ['minecraft:bone_block'],//骨块
        ['minecraft:coal'],//煤炭
        ['minecraft:leather'],//皮革
        ['minecraft:wheat'],//小麦
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['farmersdelight:melon_popsicle', 2],//西瓜冰棍
        ['aquamirae:wisteria_niveis', 2],
        ['aquamirae:oxygelium', 2],
        ['farmersdelight:melon_juice', 2],//西瓜汁
        ['twilightdelight:twilight_spring', 1],//暮色山泉
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]

    let lootItem = [
        ['manors_bounty:vanilla_chocolate_ice_cream', 0.2],//庄园馀事 经典双拼冰激凌
        ['manors_bounty:starfruit_ice_cream', 0.2],//庄园馀事 杨桃冰激凌
        ['manors_bounty:vanilla_ice_cream',0.2],//庄园馀事 香草冰激凌
        ['manors_bounty:chocolate_ice_cream',0.2],//庄园馀事 巧克力冰激凌
        ['manors_bounty:blueberry_ice_cream',0.2],//庄园馀事 蓝莓冰激凌
        ['manors_bounty:cherries_ice_cream',0.2],//庄园馀事 车厘子冰激凌
        ['manors_bounty:jalapeno_ice_cream',0.2],//庄园馀事 墨西哥辣椒冰激凌
        ['manors_bounty:blueberry_cherries_ice_cream',0.2],//庄园馀事 莓果双拼冰激凌
        ['manors_bounty:starfruit_jalapeno_ice_cream',0.2],//庄园馀事 命运双拼冰激凌
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/igloo_chest')//雪屋
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/igloo_chest')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/igloo_chest')//雪屋
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//极光宫殿
LootJS.modifiers(event => {//极光宫殿
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:coal'],//煤炭
        ['touhou_little_maid:shrine'],//神龛
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:stick'],//木棍
        ['minecraft:arrow'],//箭
        ['minecraft:sugar_cane'],//甘蔗
        ['minecraft:packed_ice'],//浮冰
        ['minecraft:ice'],//冰
        ['minecraft:sand'],//沙子
        ['twilightforest:firefly'],//萤火虫
        ['minecraft:wheat_seeds'],//小麦种子
        ['minecraft:bone_meal'],//骨粉
        ['minecraft:flint'],//燧石
    ]
        //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['16x twilightforest:aurora_block', 5],//暮色森林 极光方块
        ['aquamirae:wisteria_niveis', 5],
        ['aquamirae:oxygelium', 5],
        ['twilightdelight:twilight_spring', 3],//暮色乐事 暮色山泉
        ['twilightdelight:glacier_ice_tea',1],//暮色乐事 冰川冰茶
        ['twilightdelight:glacier_milkshake',1],//暮色乐事 冰川奶昔
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
    let lootItem = [
        ['twilightdelight:aurora_cake_slice',0.05],//暮色乐事 极光蛋糕切片
        ['twilightdelight:aurora_ice_cream',0.2],//暮色乐事 极光冰激凌
        ['arsdelight:arch_sauce',0.1],//新生乐事 至高酱
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/aurora_cache')//极光宫殿
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/aurora_cache')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('twilightforest:chests/aurora_cache')//极光宫殿
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//极光宫殿2
LootJS.modifiers(event => {//极光宫殿
        //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:coal'],//煤炭
        ['touhou_little_maid:shrine'],//神龛
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:stick'],//木棍
        ['minecraft:arrow'],//箭
        ['minecraft:sugar_cane'],//甘蔗
        ['minecraft:packed_ice'],//浮冰
        ['minecraft:ice'],//冰
        ['minecraft:sand'],//沙子
        ['twilightforest:firefly'],//萤火虫
        ['minecraft:wheat_seeds'],//小麦种子
        ['minecraft:bone_meal'],//骨粉
        ['minecraft:flint'],//燧石
        ['twilightforest:arctic_helmet'],//极地帽子
        ['twilightforest:arctic_leggings'],//极地护腿
        ['twilightforest:arctic_boots'],//极地靴子
    ]
       
        //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['16x twilightforest:aurora_block', 5],//暮色森林 极光方块
        ['twilightdelight:twilight_spring', 3],//暮色乐事 暮色山泉
        ['twilightdelight:glacier_ice_tea',1],//暮色乐事 冰川冰茶
        ['twilightdelight:glacier_milkshake',1],//暮色乐事 冰川奶昔
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
    let lootItem = [
        ['twilightdelight:aurora_cake_slice',0.05],//暮色乐事 极光蛋糕切片
        ['twilightdelight:aurora_ice_cream',0.2],//暮色乐事 极光冰激凌
        ['arsdelight:arch_sauce',0.1],//新生乐事 至高酱
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/aurora_room')//极光宫殿2
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/aurora_room')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('twilightforest:chests/aurora_room')//极光宫殿2
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//幽冥高塔
LootJS.modifiers(event => {//幽冥高塔
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:coal'],//煤炭
        ['touhou_little_maid:shrine'],//神龛
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:stick'],//木棍
        ['minecraft:arrow'],//箭
        ['minecraft:sugar_cane'],//甘蔗
        ['minecraft:packed_ice'],//浮冰
        ['minecraft:ice'],//冰
        ['minecraft:sand'],//沙子
        ['twilightforest:firefly'],//萤火虫
        ['minecraft:wheat_seeds'],//小麦种子
        ['minecraft:bone_meal'],//骨粉
        ['minecraft:flint'],//燧石
        ['twilightforest:arctic_helmet'],//极地帽子
        ['twilightforest:arctic_leggings'],//极地护腿
        ['twilightforest:arctic_boots'],//极地靴子
        ['minecraft:red_wool'],//红色羊毛
        ['minecraft:charcoal'],//木炭
        ['minecraft:redstone'],//红石粉
        ['minecraft:dandelion'],//蒲公英
        ['minecraft:redstone_lamp'],//红石灯
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['mynethersdelight:ghasta', 3],//下界乐事 恶魂意面
        ['twilightforest:borer_essence', 5],//暮色森林 蛀虫精华
        ['mynethersdelight:ghasmati', 3],//下界乐事 恶魂长米
        ['twilightforest:experiment_115',1],//暮色乐事 试验品115
        ['twilightdelight:experiment_113',1],//暮色乐事 试验品113
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
   let lootItem = [
        ['twilightdelight:glow_113', 0.2],//暮色乐事 113蘸荧光堡
        ['twilightdelight:milky_113', 0.2],//暮色乐事 113蘸炼乳
        ['twilightdelight:chocolate_113', 0.2],//暮色乐事 113蘸巧克力
        ['twilightdelight:honey_113', 0.2],//暮色乐事 113蘸蜂蜜
        ['twilightdelight:experiment_110', 0.05],//暮色乐事 试验品110
        ['dungeonsdelight:ghastly_spirits', 0.3],//地牢乐事 恶魂烈酒
        ['twilightdelight:tear_drink', 0.2],//暮色乐事 营泪之饮
        ['arsdelight:arch_sauce',0.1],//新生乐事 至高酱
        ['dungeonsdelight:tower_boreito',0.1],//地牢乐事 高塔蛀虫卷饼
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/darktower_cache')//幽冥高塔
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/darktower_cache')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('twilightforest:chests/darktower_cache')//幽冥高塔
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//树篱迷宫
LootJS.modifiers(event => {//树篱迷宫
    //定义删除物品,[物品id]
    let removeLoot = [
        ['touhou_little_maid:shrine'],//神龛
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:stick'],//木棍
        ['minecraft:arrow'],//箭
        ['twilightforest:firefly'],//萤火虫
        ['minecraft:wheat_seeds'],//小麦种子
        ['minecraft:dandelion'],//蒲公英
        ['minecraft:shears'],//剪刀
        ['minecraft:melon_seeds'],//西瓜种子
        ['minecraft:pumpkin_seeds'],//南瓜种子
        ['minecraft:cactus'],//仙人掌
        ['minecraft:poppy'],//虞美人
        ['minecraft:oak_planks'],//橡木木板
        ['minecraft:red_mushroom'],//红蘑菇
        ['minecraft:brown_mushroom'],//棕蘑菇
        ['minecraft:wheat'],//小麦
        ['minecraft:bow'],//弓
        ['minecraft:saddle'],//马鞍
        ['minecraft:apple'],//苹果
        ['minecraft:melon_slice'],//西瓜
        ['minecraft:mushroom_stew'],//蘑菇煲
        ['minecraft:flower_pot'],//花盆
        ['minecraft:cobweb'],//蜘蛛网
        ['minecraft:sugar_cane'],//甘蔗
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['minecraft:torchflower_seeds', 5],//火把花种子
        ['dungeonsdelight:spider_meat',3],//地牢乐事 蜘蛛肉
        ['dungeonsdelight:bug_chops',3],//地牢乐事 虫肉排
        ['twilightdelight:raw_insect',3],//暮色乐事 生虫肉
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
    let lootItem = [
        ['twilightdelight:berry_stick', 0.3],//暮色乐事 浆果串
        ['dungeonsdelight:spider_extract', 0.4],//地牢乐事 蜘蛛提取物
        ['dungeonsdelight:spider_donut', 0.3],//地牢乐事 蜘蛛甜甜圈
        ['arsdelight:arch_sauce',0.1],//新生乐事 至高酱
        ['dungeonsdelight:maze_roll',0.2]//地牢乐事 迷宫寿司
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/hedge_maze')//树篱迷宫
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([3, 4], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/hedge_maze')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('twilightforest:chests/hedge_maze')//树篱迷宫
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//幻影骑士要塞
LootJS.modifiers(event => {//幻影骑士要塞
    //定义删除物品,[物品id]
    let removeLoot = [
        ['touhou_little_maid:shrine'],//神龛
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:stick'],//木棍
        ['minecraft:arrow'],//箭
        ['twilightforest:firefly'],//萤火虫
        ['minecraft:bow'],//弓
        ['minecraft:coal'],//煤炭
        ['twilightforest:steeleaf_sword'],//钢叶剑
        ['minecraft:bucket'],//桶
        ['minecraft:blue_wool'],//蓝色羊毛
        ['minecraft:iron_ingot'],//铁锭
        ['minecraft:iron_sword'],//铁剑
        ['twilightforest:ironwood_sword'],//铁木剑
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['minecraft:torchflower_seeds', 5],//火把花种子
        ['dungeonsdelight:spider_meat',3],//地牢乐事 蜘蛛肉
        ['dungeonsdelight:bug_chops',3],//地牢乐事 虫肉排
        ['twilightdelight:raw_insect',3],//暮色乐事 生虫肉
        ['twilightforest:steeleaf_ingot',2],//暮色森林 钢叶
        ['twilightforest:knightmetal_ingot',1],//暮色森林 骑士金属锭
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
    let lootItem = [
        ['dungeonsdelight:maze_roll', 0.2],//地牢乐事 迷宫寿司
        ['arsdelight:arch_sauce',0.1],//新生乐事 至高酱
        ['twilightdelight:mushgloom_sauce', 0.2],//暮色乐事 荧光蘑菇酱   
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/stronghold_cache')//幻影骑士要塞
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/stronghold_cache')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('twilightforest:chests/stronghold_cache')//幻影骑士要塞
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})
//幻影骑士要塞2
LootJS.modifiers(event => {//幻影骑士要塞2
    //定义删除物品,[物品id]
    let removeLoot = [
        ['touhou_little_maid:shrine'],//神龛
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:stick'],//木棍
        ['minecraft:arrow'],//箭
        ['twilightforest:firefly'],//萤火虫
        ['minecraft:bow'],//弓
        ['minecraft:coal'],//煤炭
        ['twilightforest:steeleaf_sword'],//钢叶剑
        ['minecraft:bucket'],//桶
        ['minecraft:blue_wool'],//蓝色羊毛
        ['minecraft:iron_ingot'],//铁锭
        ['minecraft:iron_sword'],//铁剑
        ['twilightforest:ironwood_sword'],//铁木剑
        ['minecraft:dandelion'],//蒲公英
        ['minecraft:gunpowder'],//火药
        ['minecraft:milk_bucket'],//奶桶
        ['twilightforest:ironwood_chestplate'],//铁木胸甲
        ['twilightforest:steeleaf_pickaxe'],//钢叶稿
        ['twilightforest:steeleaf_helmet'],//钢叶头盔
        ['twilightforest:steeleaf_chestplate'],//钢叶胸甲
        ['twilightforest:steeleaf_leggings'],//钢叶护腿
        ['twilightforest:steeleaf_boots'],//钢叶靴子
        ['minecraft:diamond_sword'],//钻石剑
        ['minecraft:sugar_cane'],//甘蔗
        ['minecraft:bone_meal'],//骨粉
        ['minecraft:flint'],//燧石
        ['minecraft:flint'],//小麦种子
        ['minecraft:sand'],//沙子
        ['minecraft:poppy'],//虞美人
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['minecraft:torchflower_seeds', 5],//火把花种子
        ['dungeonsdelight:spider_meat',3],//地牢乐事 蜘蛛肉
        ['dungeonsdelight:bug_chops',3],//地牢乐事 虫肉排
        ['twilightdelight:raw_insect',3],//暮色乐事 生虫肉
        ['twilightforest:steeleaf_ingot',2],//暮色森林 钢叶
        ['twilightforest:knightmetal_ingot',1],//暮色森林 骑士金属锭
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
    let lootItem = [
        ['dungeonsdelight:maze_roll', 0.1],//地牢乐事 迷宫寿司
        ['arsdelight:arch_sauce',0.1],//新生乐事 至高酱
        ['twilightdelight:mushgloom_sauce', 0.2],//暮色乐事 荧光蘑菇酱   
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/stronghold_room')//幻影骑士要塞2
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/stronghold_room')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('twilightforest:chests/stronghold_room')//幻影骑士要塞2
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//牛头人迷宫
LootJS.modifiers(event => {//牛头人迷宫
    //定义删除物品,[物品id]
    let removeLoot = [
        ['touhou_little_maid:shrine'],//神龛
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:stick'],//木棍
        ['minecraft:arrow'],//箭
        ['twilightforest:firefly'],//萤火虫
        ['minecraft:bow'],//弓
        ['minecraft:coal'],//煤炭
        ['twilightforest:steeleaf_sword'],//钢叶剑
        ['minecraft:bucket'],//桶
        ['minecraft:blue_wool'],//蓝色羊毛
        ['minecraft:iron_ingot'],//铁锭
        ['minecraft:iron_sword'],//铁剑
        ['twilightforest:ironwood_sword'],//铁木剑
        ['minecraft:dandelion'],//蒲公英
        ['minecraft:gunpowder'],//火药
        ['minecraft:milk_bucket'],//奶桶
        ['twilightforest:ironwood_chestplate'],//铁木胸甲
        ['twilightforest:steeleaf_pickaxe'],//钢叶稿
        ['twilightforest:steeleaf_helmet'],//钢叶头盔
        ['twilightforest:steeleaf_chestplate'],//钢叶胸甲
        ['twilightforest:steeleaf_leggings'],//钢叶护腿
        ['twilightforest:steeleaf_boots'],//钢叶靴子
        ['minecraft:diamond_sword'],//钻石剑
        ['minecraft:sugar_cane'],//甘蔗
        ['minecraft:bone_meal'],//骨粉
        ['minecraft:flint'],//燧石
        ['minecraft:flint'],//小麦种子
        ['minecraft:sand'],//沙子
        ['minecraft:poppy'],//虞美人
        ['minecraft:mushroom_stew'],//蘑菇包
        ['minecraft:paper'],//纸
        ['twilightforest:red_thread'],//红线
        ['minecraft:leather'],//皮革
        ['twilightforest:steeleaf_axe'],//钢叶斧
        ['twilightforest:steeleaf_shovel'],//钢叶铲
        ['minecraft:ender_chest'],//末影箱
        ['minecraft:tnt'],//TNT
        ['minecraft:cactus'],//仙人掌
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['twilightforest:mushgloom', 3],//暮色森林 荧光蘑菇
        ['minecraft:brown_mushroom', 5],//棕色蘑菇
        ['minecraft:red_mushroom', 5],//红色蘑菇
        ['twilightdelight:raw_tomahawk_smeak', 1],//暮色乐事 生战斧牛头人肋排
        ['twilightforest:raw_meef', 3],//暮色森林 生牛头人肉
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
    let lootItem = [
        ['twilightdelight:mushgloom_sauce', 0.2],//暮色乐事 荧光蘑菇酱
        ['farmersdelight:mushroom_rice', 0.2],//农夫乐事 蘑菇饭
        ['arsdelight:arch_sauce',0.1],//新生乐事 至高酱
        ['dungeonsdelight:maze_roll',0.1],//地牢乐事 迷宫寿司
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/labyrinth_dead_end')//牛头人迷宫
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/labyrinth_dead_end')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('twilightforest:chests/labyrinth_dead_end')//牛头人迷宫
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//牛头人迷宫2
LootJS.modifiers(event => {//牛头人迷宫2
    //定义删除物品,[物品id]
    let removeLoot = [
        ['touhou_little_maid:shrine'],//神龛
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:stick'],//木棍
        ['minecraft:arrow'],//箭
        ['twilightforest:firefly'],//萤火虫
        ['minecraft:bow'],//弓
        ['minecraft:coal'],//煤炭
        ['twilightforest:steeleaf_sword'],//钢叶剑
        ['minecraft:bucket'],//桶
        ['minecraft:blue_wool'],//蓝色羊毛
        ['minecraft:iron_ingot'],//铁锭
        ['minecraft:iron_sword'],//铁剑
        ['twilightforest:ironwood_sword'],//铁木剑
        ['minecraft:dandelion'],//蒲公英
        ['minecraft:gunpowder'],//火药
        ['minecraft:milk_bucket'],//奶桶
        ['twilightforest:ironwood_chestplate'],//铁木胸甲
        ['twilightforest:steeleaf_pickaxe'],//钢叶稿
        ['twilightforest:steeleaf_helmet'],//钢叶头盔
        ['twilightforest:steeleaf_chestplate'],//钢叶胸甲
        ['twilightforest:steeleaf_leggings'],//钢叶护腿
        ['twilightforest:steeleaf_boots'],//钢叶靴子
        ['minecraft:diamond_sword'],//钻石剑
        ['minecraft:sugar_cane'],//甘蔗
        ['minecraft:bone_meal'],//骨粉
        ['minecraft:flint'],//燧石
        ['minecraft:flint'],//小麦种子
        ['minecraft:sand'],//沙子
        ['minecraft:poppy'],//虞美人
        ['minecraft:mushroom_stew'],//蘑菇包
        ['minecraft:paper'],//纸
        ['twilightforest:red_thread'],//红线
        ['minecraft:leather'],//皮革
        ['twilightforest:steeleaf_axe'],//钢叶斧
        ['twilightforest:steeleaf_shovel'],//钢叶铲
        ['minecraft:ender_chest'],//末影箱
        ['minecraft:tnt'],//TNT
        ['minecraft:cactus'],//仙人掌
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['twilightforest:mushgloom', 3],//暮色森林 荧光蘑菇
        ['minecraft:brown_mushroom', 5],//棕色蘑菇
        ['minecraft:red_mushroom', 5],//红色蘑菇
        ['twilightdelight:raw_tomahawk_smeak', 1],//暮色乐事 生战斧牛头人肋排
        ['twilightforest:raw_meef', 3],//暮色森林 生牛头人肉
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
    let lootItem = [
        ['twilightdelight:mushgloom_sauce', 0.3],//暮色乐事 荧光蘑菇酱
        ['farmersdelight:mushroom_rice', 0.3],//农夫乐事 蘑菇饭
        ['arsdelight:arch_sauce',0.1],//新生乐事 至高酱
        ['dungeonsdelight:maze_roll',0.2],//地牢乐事 迷宫寿司
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/labyrinth_room')//牛头人迷宫2
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/labyrinth_room')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('twilightforest:chests/labyrinth_room')//牛头人迷宫2
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//牛头人迷宫3
LootJS.modifiers(event => {//牛头人迷宫3
    //定义删除物品,[物品id]
    let removeLoot = [
        ['touhou_little_maid:shrine'],//神龛
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:stick'],//木棍
        ['minecraft:arrow'],//箭
        ['twilightforest:firefly'],//萤火虫
        ['minecraft:bow'],//弓
        ['minecraft:coal'],//煤炭
        ['twilightforest:steeleaf_sword'],//钢叶剑
        ['minecraft:bucket'],//桶
        ['minecraft:blue_wool'],//蓝色羊毛
        ['minecraft:iron_ingot'],//铁锭
        ['minecraft:iron_sword'],//铁剑
        ['twilightforest:ironwood_sword'],//铁木剑
        ['minecraft:dandelion'],//蒲公英
        ['minecraft:gunpowder'],//火药
        ['minecraft:milk_bucket'],//奶桶
        ['twilightforest:ironwood_chestplate'],//铁木胸甲
        ['twilightforest:steeleaf_pickaxe'],//钢叶稿
        ['twilightforest:steeleaf_helmet'],//钢叶头盔
        ['twilightforest:steeleaf_chestplate'],//钢叶胸甲
        ['twilightforest:steeleaf_leggings'],//钢叶护腿
        ['twilightforest:steeleaf_boots'],//钢叶靴子
        ['minecraft:diamond_sword'],//钻石剑
        ['minecraft:sugar_cane'],//甘蔗
        ['minecraft:bone_meal'],//骨粉
        ['minecraft:flint'],//燧石
        ['minecraft:flint'],//小麦种子
        ['minecraft:sand'],//沙子
        ['minecraft:poppy'],//虞美人
        ['minecraft:mushroom_stew'],//蘑菇包
        ['minecraft:paper'],//纸
        ['twilightforest:red_thread'],//红线
        ['minecraft:leather'],//皮革
        ['twilightforest:steeleaf_axe'],//钢叶斧
        ['twilightforest:steeleaf_shovel'],//钢叶铲
        ['minecraft:ender_chest'],//末影箱
        ['minecraft:tnt'],//TNT
        ['minecraft:cactus'],//仙人掌
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['twilightforest:mushgloom', 3],//暮色森林 荧光蘑菇
        ['minecraft:brown_mushroom', 5],//棕色蘑菇
        ['minecraft:red_mushroom', 5],//红色蘑菇
        ['twilightdelight:raw_tomahawk_smeak', 1],//暮色乐事 生战斧牛头人肋排
        ['twilightforest:raw_meef', 3],//暮色森林 生牛头人肉
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
    let lootItem = [
        ['twilightdelight:mushgloom_sauce', 0.3],//暮色乐事 荧光蘑菇酱
        ['farmersdelight:mushroom_rice', 0.3],//农夫乐事 蘑菇饭
        ['arsdelight:arch_sauce',0.1],//新生乐事 至高酱
        ['dungeonsdelight:maze_roll',0.2],//地牢乐事 迷宫寿司
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/labyrinth_vault')//牛头人迷宫3
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/labyrinth_vault')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('twilightforest:chests/labyrinth_vault')//牛头人迷宫3
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//亡灵矿山
LootJS.modifiers(event => {//亡灵矿山
    //定义删除物品,[物品id]
    let removeLoot = [
        ['touhou_little_maid:shrine'],//神龛
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:arrow'],//箭
        ['minecraft:dandelion'],//蒲公英
        ['minecraft:gunpowder'],//火药
        ['minecraft:sugar_cane'],//甘蔗
        ['minecraft:bone_meal'],//骨粉
        ['minecraft:flint'],//小麦种子
        ['minecraft:sand'],//沙子
        ['minecraft:torch'],//火把
        ['twilightforest:ironwood_pickaxe'],//铁木稿
        ['minecraft:pumpkin_pie'],//南瓜派
        ['twilightforest:steeleaf_ingot'],//钢叶
        ['minecraft:potato'],//马铃薯
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:feather'],//羽毛
        ['minecraft:cod'],//鱼
        ['minecraft:wheat_seeds'],//小麦种子
        ['minecraft:cactus'],//仙人掌
        ['minecraft:flower_pot'],//花盆
    ]
     //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['farmersdelight:bone_broth',5],//农夫乐事 大骨汤
        ['kaleidoscope_cookery:pork_bone_soup',3],//森罗物语 大骨汤
        ['terramity:daemonium_chunk',5],//terramity 恶魔碎块
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
        ['lightmanscurrency:coin_iron',2],//硬币与物品 银币
        ['lightmanscurrency:coin_copper',3],//硬币与物品 铜币
    ]
    let lootItem = [
        ['confluence:royal_gel', 0.15],//皇家凝胶
        ['confluence:vitamins', 0.15],//维生素
        ['confluence:magiluminescence', 0.15],//魔光护符
        ['confluence:anklet_of_the_wind', 0.15],//疾风脚镯
        ['confluence:shark_tooth_necklace', 0.15],//鲨鱼项链
        ['confluence:bezoar', 0.15],//牛黄
        ['confluence:flashlight', 0.15],//手电筒
        ['confluence:blindfold', 0.15],//蒙眼布
        ['confluence:energy_bar', 0.15],//能量棒
        ['confluence:magma_skull', 0.15],//岩浆骷髅头
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/hill_3')//亡灵矿山
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/hill_3')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('twilightforest:chests/hill_3')//亡灵矿山
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//巫妖塔
LootJS.modifiers(event => {//巫妖塔
    //定义删除物品,[物品id]
    let removeLoot = [
        ['touhou_little_maid:shrine'],//神龛
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:arrow'],//箭
        ['minecraft:dandelion'],//蒲公英
        ['minecraft:gunpowder'],//火药
        ['minecraft:sugar_cane'],//甘蔗
        ['minecraft:bone_meal'],//骨粉
        ['minecraft:flint'],//小麦种子
        ['minecraft:sand'],//沙子
        ['minecraft:torch'],//火把
        ['twilightforest:ironwood_pickaxe'],//铁木稿
        ['minecraft:pumpkin_pie'],//南瓜派
        ['twilightforest:steeleaf_ingot'],//钢叶
        ['minecraft:potato'],//马铃薯
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:feather'],//羽毛
        ['minecraft:cod'],//鱼
        ['minecraft:wheat_seeds'],//小麦种子
        ['minecraft:cactus'],//仙人掌
        ['minecraft:flower_pot'],//花盆
        ['minecraft:bow'],//弓
        ['minecraft:stone_sword'],//石剑
        ['minecraft:wooden_sword'],//木剑
        ['minecraft:iron_sword'],//铁剑
        ['minecraft:iron_leggings'],//铁护腿
        ['minecraft:paper'],//纸
        ['minecraft:ladder'],//梯子
        ['minecraft:fire_charge'],//火焰弹
        ['minecraft:map'],//地图
        ['minecraft:bone'],//骨头
        ['minecraft:clay_ball'],//黏土
        ['minecraft:glass_bottle'],//玻璃瓶
        ['minecraft:book'],//书
        ['minecraft:potion'],//水瓶
        ['minecraft:golden_pickaxe'],//金稿
    ]

     //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['twilightforest:torchberries',5],//暮色森林 火炬浆果
        ['twilightforest:fiddlehead',2],//暮色森林 暮色蕨
        ['twilightdelight:torchberry_cookie',1],//暮色乐事 火炬浆果曲奇
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
        ['arsdelight:neutralized_bombegrante_jam',1],//新生乐事 果酱
        ['arsdelight:activated_mendosteen_jam',1],//新生乐事 果酱
        ['arsdelight:activated_bastion_jam',1],//新生乐事 果酱
        ['arsdelight:neutralized_frostaya_jam',1],//新生乐事 果酱
    ]
    let lootItem = [
        ['twilightdelight:torchberry_cake_slice',0.3],//暮色乐事 火炬浆果蛋糕切片
        ['twilightdelight:torchberry_pie_slice',0.3],//暮色乐事 火炬浆果派切片
        ['arsdelight:arch_sauce',0.1],//新生乐事 至高酱
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/tower_library')//巫妖怪塔
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 4], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/tower_library')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('twilightforest:chests/tower_library')//巫妖怪塔
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//工兵矿山   暮色森林
LootJS.modifiers(event => {//工兵矿山
    //定义删除物品,[物品id]
    let removeLoot = [
        ['touhou_little_maid:shrine'],//神龛
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:arrow'],//箭
        ['minecraft:dandelion'],//蒲公英
        ['minecraft:gunpowder'],//火药
        ['minecraft:sugar_cane'],//甘蔗
        ['minecraft:bone_meal'],//骨粉
        ['minecraft:flint'],//小麦种子
        ['minecraft:sand'],//沙子
        ['minecraft:torch'],//火把
        ['twilightforest:ironwood_pickaxe'],//铁木稿
        ['minecraft:pumpkin_pie'],//南瓜派
        ['twilightforest:steeleaf_ingot'],//钢叶
        ['minecraft:potato'],//马铃薯
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:feather'],//羽毛
        ['minecraft:cod'],//鱼
        ['minecraft:wheat_seeds'],//小麦种子
        ['minecraft:cactus'],//仙人掌
        ['minecraft:flower_pot'],//花盆
        ['minecraft:carrot'],//胡萝卜
        ['minecraft:baked_potato'],//烤马铃薯
        ['minecraft:bucket'],//桶
        ['minecraft:poppy'],//虞美人
        ['minecraft:ladder'],//梯子
    ]
     //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['farmersdelight:bone_broth',2],//农夫乐事 大骨汤
        ['kaleidoscope_cookery:pork_bone_soup',1],//森罗物语 大骨汤
        ['terramity:daemonium_chunk',5],//terramity 恶魔碎块
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
        ['lightmanscurrency:coin_iron',2],//硬币与物品 银币
        ['lightmanscurrency:coin_copper',3],//硬币与物品 铜币
    ]
    let lootItem = [
        ['confluence:royal_gel', 0.12],//皇家凝胶
        ['confluence:vitamins', 0.12],//维生素
        ['confluence:magiluminescence', 0.12],//魔光护符
        ['confluence:anklet_of_the_wind', 0.12],//疾风脚镯
        ['confluence:shark_tooth_necklace', 0.12],//鲨鱼项链
        ['confluence:bezoar', 0.12],//牛黄
        ['confluence:flashlight', 0.12],//手电筒
        ['confluence:blindfold', 0.12],//蒙眼布
        ['confluence:energy_bar', 0.12],//能量棒
        ['confluence:magma_skull', 0.12],//岩浆骷髅头
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/hill_2')//工兵矿山
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/hill_2')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('twilightforest:chests/hill_2')//工兵矿山
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//空心矿山  暮色森林
LootJS.modifiers(event => {//空心矿山
     //定义删除物品,[物品id]
    let removeLoot = [
        ['touhou_little_maid:shrine'],//神龛
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:arrow'],//箭
        ['minecraft:dandelion'],//蒲公英
        ['minecraft:gunpowder'],//火药
        ['minecraft:sugar_cane'],//甘蔗
        ['minecraft:bone_meal'],//骨粉
        ['minecraft:flint'],//小麦种子
        ['minecraft:sand'],//沙子
        ['minecraft:torch'],//火把
        ['twilightforest:ironwood_pickaxe'],//铁木稿
        ['minecraft:pumpkin_pie'],//南瓜派
        ['twilightforest:steeleaf_ingot'],//钢叶
        ['minecraft:potato'],//马铃薯
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:feather'],//羽毛
        ['minecraft:cod'],//鱼
        ['minecraft:wheat_seeds'],//小麦种子
        ['minecraft:cactus'],//仙人掌
        ['minecraft:flower_pot'],//花盆
        ['minecraft:carrot'],//胡萝卜
        ['minecraft:baked_potato'],//烤马铃薯
        ['minecraft:bucket'],//桶
        ['minecraft:poppy'],//虞美人
        ['minecraft:ladder'],//梯子
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['farmersdelight:bone_broth',2],//农夫乐事 大骨汤
        ['kaleidoscope_cookery:pork_bone_soup',1],//森罗物语 大骨汤
        ['terramity:daemonium_chunk',5],//terramity 恶魔碎块
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
        ['lightmanscurrency:coin_iron',2],//硬币与物品 银币
        ['lightmanscurrency:coin_copper',3],//硬币与物品 铜币
    ]
    let lootItem = [
        ['confluence:royal_gel', 0.1],//皇家凝胶
        ['confluence:vitamins', 0.1],//维生素
        ['confluence:magiluminescence', 0.1],//魔光护符
        ['confluence:anklet_of_the_wind', 0.1],//疾风脚镯
        ['confluence:shark_tooth_necklace', 0.1],//鲨鱼项链
        ['confluence:bezoar', 0.1],//牛黄
        ['confluence:flashlight', 0.1],//手电筒
        ['confluence:blindfold', 0.1],//蒙眼布
        ['confluence:energy_bar', 0.1],//能量棒
        ['confluence:magma_skull', 0.1],//岩浆骷髅头
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/hill_2')//工兵矿山
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/hill_2')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('twilightforest:chests/hill_2')//工兵矿山
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//巨魔洞穴  暮色森林
LootJS.modifiers(event => {//巨魔洞穴
     //定义删除物品,[物品id]
    let removeLoot = [
        ['touhou_little_maid:shrine'],//神龛
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:arrow'],//箭
        ['minecraft:dandelion'],//蒲公英
        ['minecraft:gunpowder'],//火药
        ['minecraft:sugar_cane'],//甘蔗
        ['minecraft:bone_meal'],//骨粉
        ['minecraft:flint'],//小麦种子
        ['minecraft:sand'],//沙子
        ['minecraft:torch'],//火把
        ['twilightforest:ironwood_pickaxe'],//铁木稿
        ['minecraft:pumpkin_pie'],//南瓜派
        ['twilightforest:steeleaf_ingot'],//钢叶
        ['minecraft:potato'],//马铃薯
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:feather'],//羽毛
        ['minecraft:cod'],//鱼
        ['minecraft:wheat_seeds'],//小麦种子
        ['minecraft:cactus'],//仙人掌
        ['minecraft:flower_pot'],//花盆
        ['minecraft:carrot'],//胡萝卜
        ['minecraft:baked_potato'],//烤马铃薯
        ['minecraft:bucket'],//桶
        ['minecraft:poppy'],//虞美人
        ['minecraft:ladder'],//梯子
        ['minecraft:melon_seeds'],//西瓜种子
        ['minecraft:red_mushroom'],//红蘑菇
        ['minecraft:brown_mushroom'],//棕蘑菇
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['twilightforest:magic_beans', 100],//暮色森林 魔豆
        ['twilightforest:transformation_powder',5],//暮色森林 转换粉
        ['twilightforest:liveroot',5],//暮色森林 活根
        ['lightmanscurrency:coin_gold',10],//硬币与物品 金币
        ['twilightforest:hydra_chop',1],//暮色森林 九头蛇肉排
        ['twilightforest:fiery_tears',1],//暮色森林 炽热之泪
        ['twilightforest:ice_bomb',1],//暮色森林 冰霜炸弹
    ]
    let lootItem = [
        ['arsdelight:arch_sauce',0.1],//新生乐事 至高酱
    ]
     //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/troll_garden')//巨魔洞穴
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/troll_garden')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('twilightforest:chests/troll_garden')//巨魔洞穴
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//巨魔洞穴2   暮色森林
LootJS.modifiers(event => {//巨魔洞穴2
    //定义删除物品,[物品id]
    let removeLoot = [
        ['touhou_little_maid:shrine'],//神龛
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:arrow'],//箭
        ['minecraft:dandelion'],//蒲公英
        ['minecraft:gunpowder'],//火药
        ['minecraft:sugar_cane'],//甘蔗
        ['minecraft:bone_meal'],//骨粉
        ['minecraft:flint'],//小麦种子
        ['minecraft:sand'],//沙子
        ['minecraft:torch'],//火把
        ['twilightforest:ironwood_pickaxe'],//铁木稿
        ['minecraft:pumpkin_pie'],//南瓜派
        ['twilightforest:steeleaf_ingot'],//钢叶
        ['minecraft:potato'],//马铃薯
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:feather'],//羽毛
        ['minecraft:cod'],//鱼
        ['minecraft:wheat_seeds'],//小麦种子
        ['minecraft:cactus'],//仙人掌
        ['minecraft:flower_pot'],//花盆
        ['minecraft:carrot'],//胡萝卜
        ['minecraft:baked_potato'],//烤马铃薯
        ['minecraft:bucket'],//桶
        ['minecraft:poppy'],//虞美人
        ['minecraft:ladder'],//梯子
        ['twilightforest:uncrafting_table'],//拆解台
        ['minecraft:melon_seeds'],//西瓜种子
        ['minecraft:red_mushroom'],//红蘑菇
        ['minecraft:brown_mushroom'],//棕蘑菇
        ['minecraft:emerald'],//绿宝石
        ['minecraft:obsidian'],//黑曜石
        ['twilightforest:torchberries'],//火炬浆果
        ['minecraft:coal'],//煤炭
        ['twilightforest:trollsteinn'],//巨魔岩石
    ]
     //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['twilightforest:magic_beans', 100],//暮色森林 魔豆
        ['twilightforest:transformation_powder',5],//暮色森林 转换粉
        ['twilightforest:liveroot',5],//暮色森林 活根
        ['lightmanscurrency:coin_gold',10],//硬币与物品 金币
        ['twilightforest:hydra_chop',1],//暮色森林 九头蛇肉排
        ['twilightforest:fiery_tears',1],//暮色森林 炽热之泪
        ['twilightforest:ice_bomb',1],//暮色森林 冰霜炸弹
    ]
    let lootItem = [
        ['arsdelight:arch_sauce',0.1],//新生乐事 至高酱
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/troll_vault')//巨魔洞穴2
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/troll_vault')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('twilightforest:chests/troll_vault')//巨魔洞穴2
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//巨魔洞穴3  暮色森林
LootJS.modifiers(event => {//巨魔洞穴3
    //定义删除物品,[物品id]
    let removeLoot = [
        ['touhou_little_maid:shrine'],//神龛
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:arrow'],//箭
        ['minecraft:dandelion'],//蒲公英
        ['minecraft:gunpowder'],//火药
        ['minecraft:sugar_cane'],//甘蔗
        ['minecraft:bone_meal'],//骨粉
        ['minecraft:flint'],//小麦种子
        ['minecraft:sand'],//沙子
        ['minecraft:torch'],//火把
        ['twilightforest:ironwood_pickaxe'],//铁木稿
        ['minecraft:pumpkin_pie'],//南瓜派
        ['twilightforest:steeleaf_ingot'],//钢叶
        ['minecraft:potato'],//马铃薯
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:feather'],//羽毛
        ['minecraft:cod'],//鱼
        ['minecraft:wheat_seeds'],//小麦种子
        ['minecraft:cactus'],//仙人掌
        ['minecraft:flower_pot'],//花盆
        ['minecraft:carrot'],//胡萝卜
        ['minecraft:baked_potato'],//烤马铃薯
        ['minecraft:bucket'],//桶
        ['minecraft:poppy'],//虞美人
        ['minecraft:ladder'],//梯子
        ['twilightforest:uncrafting_table'],//拆解台
        ['minecraft:melon_seeds'],//西瓜种子
        ['minecraft:red_mushroom'],//红蘑菇
        ['minecraft:brown_mushroom'],//棕蘑菇
        ['minecraft:emerald'],//绿宝石
        ['minecraft:obsidian'],//黑曜石
        ['twilightforest:torchberries'],//火炬浆果
        ['minecraft:coal'],//煤炭
        ['twilightforest:trollsteinn'],//巨魔岩石
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['twilightforest:hydra_chop',10],//暮色森林 九头蛇肉排
        ['twilightforest:fiery_tears',10],//暮色森林 炽热之泪
        ['twilightforest:ice_bomb',10],//暮色森林 冰霜炸弹
        ['twilightforest:transformation_powder',5],//暮色森林 转换粉
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
        ['twilightforest:liveroot',5]//暮色森林 活根
    ]
    let lootItem = [
        ['arsdelight:arch_sauce',0.4],//新生乐事 至高酱
        ['pasterdream:legend_dragon_horn_ice_cream',0.1],//帕斯特之梦 传说龙角冰激凌
    ]
     //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/troll_vault_with_lamp')//巨魔洞穴3
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/troll_vault_with_lamp')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('twilightforest:chests/troll_vault_with_lamp')//巨魔洞穴3
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})



//古陵  eeeab's mods
LootJS.modifiers(event => {//古陵
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:arrow'],//箭
        ['minecraft:book'],//书
        ['minecraft:brown_mushroom'],//蘑菇
        ['minecraft:leather_horse_armor'],//皮革马凯
        ['minecraft:apple'],//苹果
        ['minecraft:poisonous_potato'],//毒马铃薯
        ['minecraft:wheat'],//小麦
        ['minecraft:red_mushroom'],//红色蘑菇
        ['minecraft:coal'],//煤炭
        ['minecraft:iron_sword'],//铁剑
        ['touhou_little_maid:power_point'],//P点
        ['touhou_little_maid:shrine'],//神龛
        ['eeeabsmobs:immortal_debris'],//盔甲残骸

    ]

    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['vefc:soulspores', 4],//香草纪元 魂光孢子
        ['eeeabsmobs:immortal_bone', 1],//eeeab 不朽之骨
        ['quark:ancient_fruit',3],//夸克 远古水果
    ]

    let lootItem = [
        ['enigmaticlegacy:darkest_scroll', 0.2],//神秘遗物 至暗卷轴
        ['bountifulfares:hoary_apple', 0.15],//丰饶食记 朽老苹果
        ['lightmanscurrency:coin_emerald', 0.15],//硬币与物品 绿宝石币
        ['vintagedelight:century_egg', 0.05],//腌渍乐事 松花蛋（厨神之证）
        ['enigmaticlegacy:unholy_grail',0.1],//神秘遗物 不洁圣杯
    ]
//遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('eeeabsmobs:chests/epic_ancient_tomb')//古陵
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('eeeabsmobs:chests/epic_ancient_tomb')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('eeeabsmobs:chests/epic_ancient_tomb')//古陵
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//古陵2 eeeab's mods
LootJS.modifiers(event => {//古陵2
    //定义删除物品,[物品id]
    let removeLoot = [
        ['enigmaticlegacy:iron_ring'],//铁指环
        ['minecraft:bow'],//弓
        ['minecraft:golden_horse_armor'],//金马凯
        ['minecraft:iron_horse_armor'],//铁马凯
        ['minecraft:iron_helmet'],//铁头盔
        ['minecraft:iron_chestplate'],//铁胸甲
        ['minecraft:iron_leggings'],//铁护腿
        ['minecraft:iron_boots'],//铁靴子
        ['minecraft:iron_sword'],//铁剑
        ['minecraft:iron_axe'],//铁斧
        ['minecraft:saddle'],//马鞍
        ['minecraft:clock'],//钟
        ['minecraft:sand'],//沙子
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['immortalers_delight:sealed_ancient_rations',1],//千古乐事 古代口粮包
        ['lightmanscurrency:coin_emerald',1],//硬币与物品 绿宝石币
        ['quark:ancient_fruit',3],//夸克 远古水果
        ['vefc:soulspores', 4],//香草纪元 魂光孢子
    ]
    let lootItem = [
        ['confluence:royal_gel', 0.3],//皇家凝胶
        ['confluence:vitamins', 0.3],//维生素
        ['confluence:magiluminescence', 0.3],//魔光护符
        ['confluence:anklet_of_the_wind', 0.3],//疾风脚镯
        ['confluence:shark_tooth_necklace', 0.3],//鲨鱼项链
        ['confluence:bezoar', 0.3],//牛黄
        ['confluence:flashlight', 0.3],//手电筒
        ['confluence:blindfold', 0.3],//蒙眼布
        ['confluence:energy_bar', 0.3],//能量棒
        ['confluence:magma_skull', 0.3],//岩浆骷髅头 
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('eeeabsmobs:chests/rare_ancient_tomb')//古陵2
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('eeeabsmobs:chests/rare_ancient_tomb')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('eeeabsmobs:chests/rare_ancient_tomb')//古陵2
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//简单地牢
LootJS.modifiers(event => {  //简单地牢
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:coal'],//煤炭
        ['minecraft:glow_berries'],//发光浆果
        ['minecraft:compass'],//指南针
        ['minecraft:beetroot_seeds'],//甜菜种子
        ['minecraft:melon_seeds'],//西瓜种子
        ['minecraft:rail'],//铁轨
        ['minecraft:powered_rail'],//动力铁轨
        ['minecraft:activator_rail'],//激活铁轨
        ['minecraft:detector_rail'],//探测铁轨
        ['minecraft:leather'],//皮革
        ['minecraft:iron_ingot'],//铁
        ['minecraft:gold_ingot'],//金
        ['minecraft:emerald'],//绿宝石
        ['minecraft:diamond'],//钻石
        ['minecraft:lapis_lazuli'],//青金石
        ['minecraft:redstone'],//红石
        ['additionaladditions:rope'],//绳子
        ['supplementaries:rope'],//绳索
        ['farmersdelight:rope'],//绳子
        ['additionaladditions:glow_stick'],//荧光棒
        ['muffins_thaidelight:pepper_seeds'],//辣椒种子
        ['minecraft:torch'],//火把
        ['dumplings_delight:chinese_cabbage_seeds'],//白菜种子
        [('minecraft:clock')],//钟
        [Item.of('minecraft:iron_axe')],//铁斧头
        ['farmersdelight:cabbage_seeds'],//卷心菜种子
        ['additionaladditions:rose_gold_upgrade'],//锻造模板
        ['additionaladditions:music_disc_1507'],//唱片
        ['additionaladditions:music_disc_1007'],//唱片
        ['additionaladditions:music_disc_0308'],//唱片
        ['minecraft:gunpowder'],//火药
        ['enigmaticlegacy:iron_ring'],//铁指环
        ['minecraft:string'],//线
        ['minecraft:pumpkin_seeds'],//南瓜种子
        ['minecraft:wheat'],//小麦
        ['minecraft:music_disc_otherside'],//唱片
        ['minecraft:iron_horse_armor'],//铁马恺
        [Item.of('beachparty:rubber_ring_axolotl', '{Damage:0}')],//泳圈
        ['ars_nouveau:split_arrow'],//箭
        ['minecraft:slime_ball'],//粘液球
        ['minecraft:golden_horse_armor'],//金马凯
        [Item.of('beachparty:rubber_ring_pelican', '{Damage:0}')],//泳圈
        ['farmersdelight:tomato_seeds'],//番茄种子
        ['beachparty:overgrown_disc'],//唱片
        ['minecraft:bone'],//骨头
        ['minecraft:music_disc_cat'],//唱片
        [Item.of('minecraft:potion', '{Potion:"ars_nouveau:mana_regen_potion"}')],//药水
        ['quark:smithing_template_rune'],//锻造模板
        ['ars_nouveau:amplify_arrow'],//箭
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['lightmanscurrency:coin_gold',10],//硬币与物品 金币
        ['dungeonsdelight:rubaboo',1],//地牢乐事 腐肉饼汤
        ['minecraft:poisonous_potato',5],//毒马铃薯
        ['farmersdelight:rotten_tomato',5],//农夫乐事 烂番茄
    ]
    let lootItem = [
        ['enigmaticaddons:artificial_flower',0.2],//神秘遗物扩展 魔法石英花
        ['enigmaticaddons:void_tome',0.1],//神秘遗物扩展 虚无之书
        ['enigmaticlegacy:forbidden_fruit',0.1],//神秘佳肴 禁忌之果
        ['enigmaticlegacy:unholy_grail',0.1],//神秘佳肴 不洁圣杯
        ['immortalers_delight:stuffed_poisonous_potato',0.2],//千古乐事 填馅毒马铃薯
        ['immortalers_delight:meaty_rotten_tomato_broth',0.2],//千古乐事 烂茄肉汤
    ]
     //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/simple_dungeon')//简单地牢
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/simple_dungeon')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/simple_dungeon')//简单地牢
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//浮云神殿
LootJS.modifiers(event => {///浮云神殿
     //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:string'],//线
        ['minecraft:feather'],//羽毛
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币
        ['minecraft:diamond', 2],//钻石
        ['delighto_flight:clear_cloudshroom',1],//云端之乐 云蘑菇
    ]
    let lootItem = [
        ['enigmaticdelicacy:enigmatic_seed', 0.2],//神秘佳肴 神秘种子
        ['confluence:shot_put', 0.2],//泰拉饰品 铅球
        ['delighto_flight:cloud_bread',0.3],//云端之乐 云朵面包
        ['confluence:cloud_in_a_bottle',0.2],//泰拉饰品 云朵瓶
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('legendary_monsters:chests/cloudy_temple_loot_table')//浮云神殿
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('legendary_monsters:chests/cloudy_temple_loot_table')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('legendary_monsters:chests/cloudy_temple_loot_table')//浮云神殿
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})


//荒古要塞
LootJS.modifiers(event => {///荒古要塞
    //定义删除物品,[物品id]
    let removeLoot = [
        ['legendary_monsters:ancient_dripstone_bricks'],//荒古滴水石砖
        ['minecraft:saddle'],//鞍
        ['minecraft:bone'],//骨头
        ['minecraft:beetroot_seeds'],//甜菜种子
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币
        ['minecraft:sniffer_egg', 1],//嗅探兽蛋
        ['manors_bounty:super_ancient_mushroom',1],//庄园 超古代蘑菇
    ]

    let lootItem = [
        ['confluence:eye_of_the_golem', 0.2],//泰拉饰品 石巨人之眼
        ['confluence:warrior_emblem', 0.2],//泰拉饰品 战士徽章
        ['confluence:cobalt_shield', 0.2],//泰拉饰品 钴护盾
        ['enigmaticaddons:artificial_flower', 0.1],//神秘遗物+ 魔法石英花
        ['composite_material:primitive_tenacity',0.1],//复合材料 荒古坚材
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('legendary_monsters:chests/ancient_stronghold_luxury_loot_table')//荒古要塞
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('legendary_monsters:chests/ancient_stronghold_luxury_loot_table')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('legendary_monsters:chests/ancient_stronghold_luxury_loot_table')//荒古要塞
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})


//荒古要塞2
LootJS.modifiers(event => {///荒古要塞2
    //定义删除物品,[物品id]
    let removeLoot = [
        ['legendary_monsters:ancient_dripstone_bricks'],//荒古滴水石砖
        ['minecraft:saddle'],//鞍
        ['minecraft:bone'],//骨头
        ['minecraft:beetroot_seeds'],//甜菜种子
    ]

    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币
        ['minecraft:sniffer_egg', 1],//嗅探兽蛋
        ['manors_bounty:super_ancient_mushroom',1],//庄园 超古代蘑菇
    ]

    let lootItem = [
        ['confluence:eye_of_the_golem', 0.2],// 泰拉饰品 石巨人之眼
        ['confluence:warrior_emblem', 0.2],//泰拉饰品 战士徽章
        ['confluence:cobalt_shield', 0.2],//泰拉饰品 钴护盾
        ['enigmaticaddons:artificial_flower', 0.1],//神秘佳肴 魔法石英花
        ['composite_material:primitive_tenacity',0.1],//复合材料 荒古坚材
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('legendary_monsters:chests/ancient_stronghold_loot_table')//荒古要塞2
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('legendary_monsters:chests/ancient_stronghold_loot_table')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('legendary_monsters:chests/ancient_stronghold_loot_table')//荒古要塞2
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})
//废弃墓穴
LootJS.modifiers(event => {///废弃墓穴
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:iron_helmet'],//铁头盔
        ['minecraft:iron_chestplate'],//铁胸甲
        ['minecraft:iron_leggings'],//铁护腿
        ['minecraft:iron_boots'],//铁靴子
        ['minecraft:iron_sword'],//铁剑
        ['minecraft:chainmail_helmet'],//锁链头盔
        ['minecraft:chainmail_chestplate'],//锁链胸甲
        ['minecraft:chainmail_leggings'],//锁链护腿
        ['minecraft:chainmail_boots'],//锁链靴子
        ['minecraft:bone_meal'],//骨粉
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币
        ['royalvariations:royal_armor_fragments', 1],//皇家变种 骑士碎片
    ]
     let lootItem = [
        ['enigmaticdelicacy:enigmatic_seed', 0.2],//神秘佳肴 神秘种子
        ['confluence:paladins_shield', 0.2],//泰拉饰品 圣骑士护盾
        ['confluence:magic_mirror', 0.2],//泰拉饰品 魔镜
        ['royalvariations:royal_armor_fragments',0.3],//皇家变种 灵性王冠碎片
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('legendary_monsters:chests/abandoned_crypt_loot_table')//废弃墓穴
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('legendary_monsters:chests/abandoned_crypt_loot_table')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('legendary_monsters:chests/abandoned_crypt_loot_table')//废弃墓穴
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})


//废弃传送门
LootJS.modifiers(event => {///废弃传送门
     let removeLoot = [
        ['additionaladditions:gilded_netherite_upgrade'],//锻造模版
        [Item.of('minecraft:flint_and_steel', '{Damage:0}')],//打火石
        ['minecraft:iron_nugget'],//铁粒
        [Item.of('minecraft:golden_leggings', '{Damage:0}')],//金护腿
        [Item.of('minecraft:golden_pickaxe', '{Damage:0}')],//金稿
        [Item.of('minecraft:golden_axe', '{Damage:0}')],//金斧
        [Item.of('minecraft:golden_chestplate', '{Damage:0}')],//金胸甲
        [Item.of('minecraft:golden_sword', '{Damage:0}')],//金剑
        ['minecraft:iron_horse_armor'],//铁马恺
        [Item.of('minecraft:golden_shovel', '{Damage:0}')],//金铲
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币
        ['midashunger:cooked_golden_mutton',1],//金羊肉
        ['midashunger:cooked_golden_chicken',1],//金鸡肉
        ['midashunger:cooked_golden_rabbit',1],//金兔肉
        ['midashunger:cooked_golden_beef',1],//金牛排
    ]
    let lootItem = [
        ['confluence:shackle', 0.2],//泰拉饰品 脚镣
        ['confluence:platinum_watch', 0.2],//泰拉饰品 铂金表
        ['enigmaticdelicacy:enigmatic_seed', 0.2],//泰拉饰品 神秘种子
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/ruined_portal')///废弃传送门
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/ruined_portal')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/ruined_portal')//废弃传送门
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})

//丛林神庙
LootJS.modifiers(event => {//丛林神庙
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:coal'],//煤炭
        ['minecraft:glow_berries'],//发光浆果
        ['minecraft:compass'],//指南针
        ['minecraft:beetroot_seeds'],//甜菜种子
        ['minecraft:melon_seeds'],//西瓜种子
        ['minecraft:rail'],//铁轨
        ['minecraft:powered_rail'],//动力铁轨
        ['minecraft:activator_rail'],//激活铁轨
        ['minecraft:detector_rail'],//探测铁轨
        ['minecraft:leather'],//皮革
        ['minecraft:iron_ingot'],//铁
        ['minecraft:gold_ingot'],//金
        ['minecraft:emerald'],//绿宝石
        ['minecraft:diamond'],//钻石
        ['minecraft:lapis_lazuli'],//青金石
        ['minecraft:redstone'],//红石
        ['additionaladditions:rope'],//绳子
        ['supplementaries:rope'],//绳索
        ['farmersdelight:rope'],//绳子
        ['additionaladditions:glow_stick'],//荧光棒
        ['muffins_thaidelight:pepper_seeds'],//辣椒种子
        ['minecraft:torch'],//火把
        ['dumplings_delight:chinese_cabbage_seeds'],//白菜种子
        [('minecraft:clock')],//钟
        [Item.of('minecraft:iron_axe')],//铁斧头
        ['farmersdelight:cabbage_seeds'],//卷心菜种子
        ['additionaladditions:rose_gold_upgrade'],//锻造模板
        ['minecraft:pumpkin_seeds'],//南瓜种子
        ['galosphere:silver_upgrade_smithing_template'],//锻造模板
        [Item.of('minecraft:potion', '{Potion:"ars_nouveau:mana_regen_potion_long"}')],//药水
        ['ars_nouveau:music_disc_aria_biblio'],//唱片
    ]

    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币
        ['abnormals_delight:chocolate_cake_slice',1],//巧克力蛋糕切片
        ['manors_bounty:chocolate_chips',1],//巧克力碎
        ['manors_bounty:white_chocolate_chips',1],//白巧克力碎
        ['manors_bounty:dark_chocolate_chips',1],//黑巧克力碎
    ]
    let lootItem = [
        ['pasterdream:heart_chocolate_0', 0.3],//帕斯特之梦 心形巧克力0
        ['pasterdream:heart_chocolate_1', 0.3],//帕斯特之梦 心形巧克力1
        ['enigmaticdelicacy:enigmatic_seed', 0.2],//神秘佳肴 神秘种子
        ['pasterdream:heart_chocolate_2',0.3],//帕斯特之梦 心形巧克力2
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/jungle_temple')///丛林神庙
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/jungle_temple')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/jungle_temple')//丛林神庙
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})


//巫妖塔（祸乱鬼魅）
LootJS.modifiers(event => {//巫妖塔（祸乱鬼魅）
    let removeLoot = [
        ['minecraft:coal'],//煤炭
        ['minecraft:glow_berries'],//发光浆果
        ['minecraft:compass'],//指南针
        ['minecraft:beetroot_seeds'],//甜菜种子
        ['minecraft:melon_seeds'],//西瓜种子
        ['minecraft:rail'],//铁轨
        ['minecraft:powered_rail'],//动力铁轨
        ['minecraft:activator_rail'],//激活铁轨
        ['minecraft:detector_rail'],//探测铁轨
        ['minecraft:leather'],//皮革
        ['minecraft:iron_ingot'],//铁
        ['minecraft:gold_ingot'],//金
        ['minecraft:emerald'],//绿宝石
        ['minecraft:diamond'],//钻石
        ['minecraft:lapis_lazuli'],//青金石
        ['minecraft:redstone'],//红石
        ['additionaladditions:rope'],//绳子
        ['supplementaries:rope'],//绳索
        ['farmersdelight:rope'],//绳子
        ['additionaladditions:glow_stick'],//荧光棒
        ['muffins_thaidelight:pepper_seeds'],//辣椒种子
        ['minecraft:torch'],//火把
        ['dumplings_delight:chinese_cabbage_seeds'],//白菜种子
        [('minecraft:clock')],//钟
        [Item.of('minecraft:iron_axe')],//铁斧头
        ['farmersdelight:cabbage_seeds'],//卷心菜种子
        ['additionaladditions:rose_gold_upgrade'],//锻造模板
        ['minecraft:pumpkin_seeds'],//南瓜种子
        ['galosphere:silver_upgrade_smithing_template'],//锻造模板
        [Item.of('minecraft:potion', '{Potion:"ars_nouveau:mana_regen_potion_long"}')],//药水
        ['ars_nouveau:music_disc_aria_biblio'],//唱片
        ['minecraft:saddle'],//鞍
        ['touhou_little_maid:power_point'],//p点
        ['minecraft:basalt'],//玄武岩
        ['minecraft:gunpowder'],//火药
        ['minecraft:bone'],//骨头
        ['minecraft:string'],//线
        ['minecraft:music_disc_wait'],//disco
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币
        ['neapolitan:strawberry_banana_smoothie',1],//那不勒斯 草莓冰沙
        ['peculiars:aloe_berry_smoothie',1],//独特风味 芦荟冰沙
        ['collectorsreap:pomegranate_smoothie',1],//collector 石榴冰沙
        ['fruitsdelight:hamimelon_shaved_ice',1],//果园乐事 蜜瓜冰沙
    ]
    let lootItem = [
        ['enigmaticaddons:forgotten_ice', 0.3],//神秘遗物 忘却冰晶
        ['youkaishomecoming:big_popsicle', 0.3],//妖归 大冰棍
        ['enigmaticdelicacy:enigmatic_seed', 0.2],//神秘佳肴 神秘种子
        ['youkaishomecoming:shaved_ice_over_rice',0.3],//妖归 儿童刨冰盖饭
    ]
     //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('bosses_of_mass_destruction:chests/lich_tower')///巫妖塔（祸乱鬼魅）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('bosses_of_mass_destruction:chests/lich_tower')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('bosses_of_mass_destruction:chests/lich_tower')//巫妖塔（祸乱鬼魅）
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})

//巫妖塔2(补)
LootJS.modifiers(event => {//巫妖塔2
    //定义删除物品,[物品id]
    let removeLoot = [
        ['touhou_little_maid:shrine'],//神龛
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:arrow'],//箭
        ['minecraft:dandelion'],//蒲公英
        ['minecraft:gunpowder'],//火药
        ['minecraft:sugar_cane'],//甘蔗
        ['minecraft:bone_meal'],//骨粉
        ['minecraft:flint'],//小麦种子
        ['minecraft:sand'],//沙子
        ['minecraft:torch'],//火把
        ['twilightforest:ironwood_pickaxe'],//铁木稿
        ['minecraft:pumpkin_pie'],//南瓜派
        ['twilightforest:steeleaf_ingot'],//钢叶
        ['minecraft:potato'],//马铃薯
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:feather'],//羽毛
        ['minecraft:cod'],//鱼
        ['minecraft:wheat_seeds'],//小麦种子
        ['minecraft:cactus'],//仙人掌
        ['minecraft:flower_pot'],//花盆
        ['minecraft:bow'],//弓
        ['minecraft:stone_sword'],//石剑
        ['minecraft:wooden_sword'],//木剑
        ['minecraft:iron_sword'],//铁剑
        ['minecraft:iron_leggings'],//铁护腿
        ['minecraft:paper'],//纸
        ['minecraft:ladder'],//梯子
        ['minecraft:fire_charge'],//火焰弹
        ['minecraft:map'],//地图
        ['minecraft:bone'],//骨头
        ['minecraft:clay_ball'],//黏土
        ['minecraft:glass_bottle'],//玻璃瓶
        ['minecraft:book'],//书
        ['minecraft:potion'],//水瓶
        ['minecraft:golden_pickaxe'],//金稿
    ]

     //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['twilightforest:torchberries',5],//暮色森林 火炬浆果
        ['twilightforest:fiddlehead',2],//暮色森林 暮色蕨
        ['twilightdelight:torchberry_cookie',1],//暮色乐事 火炬浆果曲奇
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
        ['arsdelight:neutralized_bombegrante_jam',1],//新生乐事 果酱
        ['arsdelight:activated_mendosteen_jam',1],//新生乐事 果酱
        ['arsdelight:activated_bastion_jam',1],//新生乐事 果酱
        ['arsdelight:neutralized_frostaya_jam',1],//新生乐事 果酱
    ]
    let lootItem = [
        ['twilightdelight:torchberry_cake_slice',0.3],//暮色乐事 火炬浆果蛋糕切片
        ['twilightdelight:torchberry_pie_slice',0.3],//暮色乐事 火炬浆果派切片
        ['arsdelight:arch_sauce',0.1],//新生乐事 至高酱
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/tower_room')//巫妖怪塔2
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/tower_room')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('twilightforest:chests/tower_room')//巫妖怪塔2
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//旷野之息高塔
LootJS.modifiers(event => {//旷野之息高塔
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:feather'],
        ['minecraft:gold_nugget'],
        ['minecraft:map'],
        ['minecraft:compass'],
        ['minecraft:iron_ingot'],
        ['minecraft:ender_pearl'],
        ['touhou_little_maid:power_point'],
]

     //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        [Item.of('minecraft:firework_rocket', '{Fireworks:{Flight:3b}}'),1],//烟花火箭
        ['minecraft:phantom_membrane',3],//幻翼膜
        ['smc:ice_tea',1],//星喵 冰红茶
        ['cosmopolitan:llama_marshmallow',2],
        ['cosmopolitan:llama_marshmallow_brown',2],
        ['cosmopolitan:llama_marshmallow_trader',2],
        ['cosmopolitan:travelers_panini',2],
        ['cosmopolitan:wandering_gelato',2],
    ]
     let lootItem = [
        ['artifacts:umbrella',0.2],//奇异饰品 雨伞
        ['confluence:lucky_horseshoe',0.2]//泰拉饰品 幸运马掌
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('totw_modded:tower_chest')//旷野之息高塔
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 4], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('totw_modded:tower_chest')//旷野之息高塔
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('totw_modded:tower_chest')//旷野之息高塔
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//森林小教堂
LootJS.modifiers(event => {//森林小教堂
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:bread'],
       ['minecraft:iron_sword'],
       ['touhou_little_maid:power_point'],
       ['minecraft:iron_helmet'],
       ['minecraft:apple'],
       ['minecraft:saddle'],
       [Item.of('minecraft:iron_boots', '{Damage:0}')],
       ['minecraft:rose_bush'],
       [Item.of('minecraft:iron_pickaxe', '{Damage:0}')],
       ['minecraft:blue_orchid'],
       ['minecraft:oak_sapling'],
       ['minecraft:obsidian'],
       ['minecraft:lapis_lazuli'],
       [Item.of('minecraft:chainmail_leggings', '{Damage:0}')],
       [Item.of('minecraft:iron_leggings', '{Damage:0}')],
       ['minecraft:moss_block'],
       ['minecraft:slime_ball'],
       ['minecraft:iron_horse_armor'],
       [Item.of('minecraft:iron_chestplate', '{Damage:0}')],
]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
       ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
       ['neapolitan:banana_bread',3],//农夫乐事 箱装洋葱
       ['bountifulfares:artisan_bread',3],//农夫乐事 箱装胡萝卜
       ['supplementaries:pancake',3],//农夫乐事 箱装土豆
       ['farmersdelight:tomato_crate',3],//农夫乐事 箱装番茄
       ['atmospheric:orange_pudding',3],//农夫乐事 箱装茄子
]
     let lootItem = [
        ['whimsy_deco:gatcha_capsule',0.3],//扭蛋胶囊
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/forest_chapel/forest_chapel_normal')//森林小教堂
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/forest_chapel/forest_chapel_normal')//森林小教堂
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('simply_houses:chests/forest_chapel/forest_chapel_normal')//森林小教堂
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})

//森林小教堂（木桶）
LootJS.modifiers(event => {//森林小教堂
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:bread'],
       [Item.of('minecraft:iron_sword', '{Damage:0}')],
       ['touhou_little_maid:power_point'],
       [Item.of('minecraft:iron_helmet', '{Damage:0}')],
       ['minecraft:apple'],
       ['minecraft:saddle'],
       [Item.of('minecraft:iron_boots', '{Damage:0}')],
       ['minecraft:rose_bush'],
       [Item.of('minecraft:iron_pickaxe', '{Damage:0}')],
       ['minecraft:blue_orchid'],
       ['minecraft:oak_sapling'],
       ['minecraft:obsidian'],
       ['minecraft:lapis_lazuli'],
       [Item.of('minecraft:chainmail_leggings', '{Damage:0}')],
       [Item.of('minecraft:iron_leggings', '{Damage:0}')],
       ['minecraft:moss_block'],
       ['minecraft:slime_ball'],
       ['minecraft:iron_horse_armor'],
       [Item.of('minecraft:iron_chestplate', '{Damage:0}')],
]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
       ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
       ['farmersdelight:onion_crate',3],//农夫乐事 箱装洋葱
       ['bountifulfares:mushroom_stuffed_potato',3],//农夫乐事 箱装胡萝卜
       ['bountifulfares:maize_stuffed_potato',3],//农夫乐事 箱装土豆
       ['bountifulfares:berry_stuffed_potato',3],//农夫乐事 箱装番茄
       ['neapolitan:adzuki_bun',3],//农夫乐事 箱装茄子
]
     let lootItem = [
        ['whimsy_deco:gatcha_capsule',0.15],//扭蛋胶囊
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/forest_chapel/forest_chapel_barrels')//森林小教堂 木桶
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/forest_chapel/forest_chapel_barrels')//森林小教堂 木桶
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('simply_houses:chests/forest_chapel/forest_chapel_barrels')//森林小教堂 木桶
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})

//森林房屋
LootJS.modifiers(event => {//森林房屋
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:bread'],
       [Item.of('minecraft:iron_sword', '{Damage:0}')],
       ['touhou_little_maid:power_point'],
       [Item.of('minecraft:iron_helmet', '{Damage:0}')],
       ['minecraft:apple'],
       ['minecraft:saddle'],
       [Item.of('minecraft:iron_boots', '{Damage:0}')],
       ['minecraft:rose_bush'],
       [Item.of('minecraft:iron_pickaxe', '{Damage:0}')],
       ['minecraft:blue_orchid'],
       ['minecraft:oak_sapling'],
       ['minecraft:obsidian'],
       ['minecraft:lapis_lazuli'],
       [Item.of('minecraft:chainmail_leggings', '{Damage:0}')],
       [Item.of('minecraft:iron_leggings', '{Damage:0}')],
       ['minecraft:moss_block'],
       ['minecraft:slime_ball'],
       ['minecraft:iron_horse_armor'],
       [Item.of('minecraft:iron_chestplate', '{Damage:0}')],
       [Item.of('minecraft:stone_shovel', '{Damage:0}')],
]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
       ['lightmanscurrency:coin_gold',1],
       ['galosphere:lichen_cordyceps',3],
       ['bountifulfares:lapisberries',3],
       ['supplementaries:antique_ink',3],
       ['species:wicked_wax',3],
       ['culturaldelights:eggplant_crate',3],//农夫乐事 箱装茄子
]
     let lootItem = [
        ['whimsy_deco:gatcha_capsule',0.15],//扭蛋胶囊
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/forest_house/forest_house_barrels')//森林房屋 木桶
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/forest_house/forest_house_barrels')//森林房屋 木桶
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('simply_houses:chests/forest_house/forest_house_barrels')//森林房屋 木桶
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})

//森林石匠铺
LootJS.modifiers(event => {//森林石匠铺
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:bread'],
       [Item.of('minecraft:iron_sword', '{Damage:0}')],
       ['touhou_little_maid:power_point'],
       [Item.of('minecraft:iron_helmet', '{Damage:0}')],
       ['minecraft:apple'],
       ['minecraft:saddle'],
       [Item.of('minecraft:iron_boots', '{Damage:0}')],
       ['minecraft:rose_bush'],
       [Item.of('minecraft:iron_pickaxe', '{Damage:0}')],
       ['minecraft:blue_orchid'],
       ['minecraft:oak_sapling'],
       ['minecraft:obsidian'],
       ['minecraft:lapis_lazuli'],
       [Item.of('minecraft:chainmail_leggings', '{Damage:0}')],
       [Item.of('minecraft:iron_leggings', '{Damage:0}')],
       ['minecraft:moss_block'],
       ['minecraft:slime_ball'],
       ['minecraft:iron_horse_armor'],
       [Item.of('minecraft:iron_chestplate', '{Damage:0}')],
       [Item.of('minecraft:stone_shovel', '{Damage:0}')],
]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
       ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
       ['braziliandelight:cassava_crate',3],
       ['braziliandelight:collard_greens_crate',3],
       ['quark:ancient_fruit',1],
       ['farmersdelight:tomato_crate',3],
       ['veggiesdelight:cauliflower',3],
]
     let lootItem = [
        ['whimsy_deco:gatcha_capsule',0.3],//扭蛋胶囊
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/forest_stonemason/forest_stonemason_normal')//森林房屋 
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/forest_stonemason/forest_stonemason_normal')//森林石匠铺
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('simply_houses:chests/forest_stonemason/forest_stonemason_normal')//森林石匠铺
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})

//森林城堡
LootJS.modifiers(event => {//森林城堡
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:bread'],
       [Item.of('minecraft:iron_sword', '{Damage:0}')],
       ['touhou_little_maid:power_point'],
       [Item.of('minecraft:iron_helmet', '{Damage:0}')],
       ['minecraft:apple'],
       ['minecraft:saddle'],
       [Item.of('minecraft:iron_boots', '{Damage:0}')],
       ['minecraft:rose_bush'],
       [Item.of('minecraft:iron_pickaxe', '{Damage:0}')],
       ['minecraft:blue_orchid'],
       ['minecraft:oak_sapling'],
       ['minecraft:obsidian'],
       ['minecraft:lapis_lazuli'],
       [Item.of('minecraft:chainmail_leggings', '{Damage:0}')],
       [Item.of('minecraft:iron_leggings', '{Damage:0}')],
       ['minecraft:moss_block'],
       ['minecraft:slime_ball'],
       ['minecraft:iron_horse_armor'],
       [Item.of('minecraft:iron_chestplate', '{Damage:0}')],
       [Item.of('minecraft:stone_shovel', '{Damage:0}')],
]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
       ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
       ['farmersdelight:onion_crate',3],//农夫乐事 箱装洋葱
       ['farmersdelight:carrot_crate',3],//农夫乐事 箱装胡萝卜
       ['farmersdelight:potato_crate',3],//农夫乐事 箱装土豆
       ['farmersdelight:tomato_crate',3],//农夫乐事 箱装番茄
       ['culturaldelights:eggplant_crate',3],//农夫乐事 箱装茄子
]
     let lootItem = [
        ['whimsy_deco:gatcha_capsule',0.3],//扭蛋胶囊
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/forest_fort/forest_fort_normal')//森林城堡
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/forest_fort/forest_fort_normal')//森林城堡
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('simply_houses:chests/forest_fort/forest_fort_normal')//森林石匠铺
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//森林城堡 木桶
LootJS.modifiers(event => {//森林城堡 木桶
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:bread'],
       [Item.of('minecraft:iron_sword', '{Damage:0}')],
       ['touhou_little_maid:power_point'],
       [Item.of('minecraft:iron_helmet', '{Damage:0}')],
       ['minecraft:apple'],
       ['minecraft:saddle'],
       [Item.of('minecraft:iron_boots', '{Damage:0}')],
       ['minecraft:rose_bush'],
       [Item.of('minecraft:iron_pickaxe', '{Damage:0}')],
       ['minecraft:blue_orchid'],
       ['minecraft:oak_sapling'],
       ['minecraft:obsidian'],
       ['minecraft:lapis_lazuli'],
       [Item.of('minecraft:chainmail_leggings', '{Damage:0}')],
       [Item.of('minecraft:iron_leggings', '{Damage:0}')],
       ['minecraft:moss_block'],
       ['minecraft:slime_ball'],
       ['minecraft:iron_horse_armor'],
       [Item.of('minecraft:iron_chestplate', '{Damage:0}')],
       [Item.of('minecraft:stone_shovel', '{Damage:0}')],
]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
       ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
       ['farmersdelight:onion_crate',3],//农夫乐事 箱装洋葱
       ['meadow:wooden_warped_milk_bucket',3],
       ['cosmopolitan:strawberry_gulime',3],
       ['farmersdelight:tomato_crate',3],//农夫乐事 箱装番茄
       ['culturaldelights:eggplant_crate',3],//农夫乐事 箱装茄子
]
     let lootItem = [
        ['whimsy_deco:gatcha_capsule',0.15],//扭蛋胶囊
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/forest_fort/forest_fort_barrels')//森林城堡 木桶
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/forest_fort/forest_fort_barrels')//森林城堡 木桶 
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('simply_houses:chests/forest_fort/forest_fort_barrels')//森林石匠铺 木桶
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})

//针叶林铁匠铺 木桶
LootJS.modifiers(event => {//针叶林铁匠铺 木桶
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:bread'],
       [Item.of('minecraft:iron_sword', '{Damage:0}')],
       ['touhou_little_maid:power_point'],
       [Item.of('minecraft:iron_helmet', '{Damage:0}')],
       ['minecraft:apple'],
       ['minecraft:saddle'],
       [Item.of('minecraft:iron_boots', '{Damage:0}')],
       ['minecraft:rose_bush'],
       [Item.of('minecraft:iron_pickaxe', '{Damage:0}')],
       ['minecraft:blue_orchid'],
       ['minecraft:oak_sapling'],
       ['minecraft:obsidian'],
       ['minecraft:lapis_lazuli'],
       [Item.of('minecraft:chainmail_leggings', '{Damage:0}')],
       [Item.of('minecraft:iron_leggings', '{Damage:0}')],
       ['minecraft:moss_block'],
       ['minecraft:slime_ball'],
       ['minecraft:iron_horse_armor'],
       [Item.of('minecraft:iron_chestplate', '{Damage:0}')],
       [Item.of('minecraft:stone_shovel', '{Damage:0}')],
]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['farmersplus:sweet_berry_bag',3],//农夫增强 浆果袋
        ['exquisito:jelly_ring_crate',1],//果园 箱装苹果
        ['fruitsdelight:pear_crate',3],//果园 箱装李子
        ['fruitsdelight:persimmon_crate',3],//果园 箱装柿子
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
 let lootItem = [
        ['whimsy_deco:gatcha_capsule',0.15],//扭蛋胶囊
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/taiga_forge/taiga_forge_barrels')////针叶林铁匠铺 木桶
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/taiga_forge/taiga_forge_barrels')////针叶林铁匠铺 木桶
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('simply_houses:chests/taiga_forge/taiga_forge_barrels')////针叶林铁匠铺 木桶
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})

//针叶林酒馆 木桶
LootJS.modifiers(event => {//针叶林铁匠铺 木桶
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:bread'],
       [Item.of('minecraft:iron_sword', '{Damage:0}')],
       ['touhou_little_maid:power_point'],
       [Item.of('minecraft:iron_helmet', '{Damage:0}')],
       ['minecraft:apple'],
       ['minecraft:saddle'],
       [Item.of('minecraft:iron_boots', '{Damage:0}')],
       ['minecraft:rose_bush'],
       [Item.of('minecraft:iron_pickaxe', '{Damage:0}')],
       ['minecraft:blue_orchid'],
       ['minecraft:oak_sapling'],
       ['minecraft:obsidian'],
       ['minecraft:lapis_lazuli'],
       [Item.of('minecraft:chainmail_leggings', '{Damage:0}')],
       [Item.of('minecraft:iron_leggings', '{Damage:0}')],
       ['minecraft:moss_block'],
       ['minecraft:slime_ball'],
       ['minecraft:iron_horse_armor'],
       [Item.of('minecraft:iron_chestplate', '{Damage:0}')],
       [Item.of('minecraft:stone_shovel', '{Damage:0}')],
]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['kitchenkarrot:rum',3],//朗姆酒
        ['kitchenkarrot:acorn_wine',3],//橡子酒
        ['kitchenkarrot:mead',3],//蜜酒
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
 let lootItem = [
        ['whimsy_deco:gatcha_capsule',0.15],//扭蛋胶囊
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/taiga_inn/taiga_inn_barrels')////针叶林小酒馆 木桶
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/taiga_inn/taiga_inn_barrels')////针叶林小酒馆 木桶
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('simply_houses:chests/taiga_inn/taiga_inn_barrels')////针叶小酒馆 木桶
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})

//针叶林小酒馆 木桶
LootJS.modifiers(event => {//针叶林铁匠铺 木桶
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:bread'],
       [Item.of('minecraft:iron_sword', '{Damage:0}')],
       ['touhou_little_maid:power_point'],
       [Item.of('minecraft:iron_helmet', '{Damage:0}')],
       ['minecraft:apple'],
       ['minecraft:saddle'],
       [Item.of('minecraft:iron_boots', '{Damage:0}')],
       ['minecraft:rose_bush'],
       [Item.of('minecraft:iron_pickaxe', '{Damage:0}')],
       ['minecraft:blue_orchid'],
       ['minecraft:oak_sapling'],
       ['minecraft:obsidian'],
       ['minecraft:lapis_lazuli'],
       [Item.of('minecraft:chainmail_leggings', '{Damage:0}')],
       [Item.of('minecraft:iron_leggings', '{Damage:0}')],
       ['minecraft:moss_block'],
       ['minecraft:slime_ball'],
       ['minecraft:iron_horse_armor'],
       [Item.of('minecraft:iron_chestplate', '{Damage:0}')],
       [Item.of('minecraft:stone_shovel', '{Damage:0}')],
]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['farmersplus:sweet_berry_bag',3],//农夫增强 浆果袋
        ['fruitsdelight:apple_crate',3],//果园 箱装苹果
        ['fruitsdelight:pear_crate',3],//果园 箱装李子
        ['fruitsdelight:persimmon_crate',3],//果园 箱装柿子
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
 let lootItem = [
        ['whimsy_deco:gatcha_capsule',0.15],//扭蛋胶囊
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/taiga_house/taiga_house_barrels')////针叶林房屋 木桶
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/taiga_house/taiga_house_barrels')////针叶林房屋 木桶
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('simply_houses:chests/taiga_house/taiga_house_barrels')////针叶林房屋 木桶
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})

//针叶林伐木场 木桶
LootJS.modifiers(event => {//针叶林伐木场 木桶
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:bread'],
       [Item.of('minecraft:iron_sword', '{Damage:0}')],
       ['touhou_little_maid:power_point'],
       [Item.of('minecraft:iron_helmet', '{Damage:0}')],
       ['minecraft:apple'],
       ['minecraft:saddle'],
       [Item.of('minecraft:iron_boots', '{Damage:0}')],
       ['minecraft:rose_bush'],
       [Item.of('minecraft:iron_pickaxe', '{Damage:0}')],
       ['minecraft:blue_orchid'],
       ['minecraft:oak_sapling'],
       ['minecraft:obsidian'],
       ['minecraft:lapis_lazuli'],
       [Item.of('minecraft:chainmail_leggings', '{Damage:0}')],
       [Item.of('minecraft:iron_leggings', '{Damage:0}')],
       ['minecraft:moss_block'],
       ['minecraft:slime_ball'],
       ['minecraft:iron_horse_armor'],
       [Item.of('minecraft:iron_chestplate', '{Damage:0}')],
       [Item.of('minecraft:stone_shovel', '{Damage:0}')],
]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['farmersplus:sweet_berry_bag',3],//农夫增强 浆果袋
        ['fruitsdelight:apple_crate',3],//果园 箱装苹果
        ['fruitsdelight:pear_crate',3],//果园 箱装李子
        ['fruitsdelight:persimmon_crate',3],//果园 箱装柿子
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
 let lootItem = [
        ['whimsy_deco:gatcha_capsule',0.15],//扭蛋胶囊
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/taiga_woodcutter/taiga_woodcutter_barrels')////针叶伐木场 木桶
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/taiga_woodcutter/taiga_woodcutter_barrels')////针叶伐木场 木桶
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('simply_houses:chests/taiga_woodcutter/taiga_woodcutter_barrels')////针叶林房屋 木桶
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})

//平原房屋 木桶
LootJS.modifiers(event => {//平原房屋 木桶
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:bread'],
       [Item.of('minecraft:iron_sword', '{Damage:0}')],
       ['touhou_little_maid:power_point'],
       [Item.of('minecraft:iron_helmet', '{Damage:0}')],
       ['minecraft:apple'],
       ['minecraft:saddle'],
       [Item.of('minecraft:iron_boots', '{Damage:0}')],
       ['minecraft:rose_bush'],
       [Item.of('minecraft:iron_pickaxe', '{Damage:0}')],
       ['minecraft:blue_orchid'],
       ['minecraft:oak_sapling'],
       ['minecraft:obsidian'],
       ['minecraft:lapis_lazuli'],
       [Item.of('minecraft:chainmail_leggings', '{Damage:0}')],
       [Item.of('minecraft:iron_leggings', '{Damage:0}')],
       ['minecraft:moss_block'],
       ['minecraft:slime_ball'],
       ['minecraft:iron_horse_armor'],
       [Item.of('minecraft:iron_chestplate', '{Damage:0}')],
       [Item.of('minecraft:stone_shovel', '{Damage:0}')],
]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['incubation:chicken_egg_crate',3],//箱装鸡蛋
        ['rusticdelight:bell_pepper_green_crate',3],
        ['rusticdelight:bell_pepper_red_crate',3],
        ['rusticdelight:bell_pepper_yellow_crate',3],
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
 let lootItem = [
        ['whimsy_deco:gatcha_capsule',0.15],//扭蛋胶囊
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/plains_house/plains_house_barrels')////平原房屋 木桶
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/plains_house/plains_house_barrels')//平原房屋 木桶
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('simply_houses:chests/plains_house/plains_house_barrels')//平原房屋 木桶
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})


//平原房屋
LootJS.modifiers(event => {//平原房屋
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:bread'],
       [Item.of('minecraft:iron_sword', '{Damage:0}')],
       ['touhou_little_maid:power_point'],
       [Item.of('minecraft:iron_helmet', '{Damage:0}')],
       ['minecraft:apple'],
       ['minecraft:saddle'],
       [Item.of('minecraft:iron_boots', '{Damage:0}')],
       ['minecraft:rose_bush'],
       [Item.of('minecraft:iron_pickaxe', '{Damage:0}')],
       ['minecraft:blue_orchid'],
       ['minecraft:oak_sapling'],
       ['minecraft:obsidian'],
       ['minecraft:lapis_lazuli'],
       [Item.of('minecraft:chainmail_leggings', '{Damage:0}')],
       [Item.of('minecraft:iron_leggings', '{Damage:0}')],
       ['minecraft:moss_block'],
       ['minecraft:slime_ball'],
       ['minecraft:iron_horse_armor'],
       [Item.of('minecraft:iron_chestplate', '{Damage:0}')],
       [Item.of('minecraft:stone_shovel', '{Damage:0}')],
]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['incubation:chicken_egg_crate',3],//箱装鸡蛋
        ['atmospheric:currant_crate',3],
        ['culturaldelights:white_eggplant_crate',3],
        ['atmospheric:currant_crate',3],
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
 let lootItem = [
        ['whimsy_deco:gatcha_capsule',0.3],//扭蛋胶囊
        ['additionaladditions:rose_gold_alloy',0.15],
        ['minecraft:firework_star',0.15],
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/plains_house/plains_house_normal')////平原房屋
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/plains_house/plains_house_normal')//平原房屋
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('simply_houses:chests/plains_house/plains_house_normal')//平原房屋
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})

//平原府邸
LootJS.modifiers(event => {//平原房屋
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:bread'],
       [Item.of('minecraft:iron_sword', '{Damage:0}')],
       ['touhou_little_maid:power_point'],
       [Item.of('minecraft:iron_helmet', '{Damage:0}')],
       ['minecraft:apple'],
       ['minecraft:saddle'],
       [Item.of('minecraft:iron_boots', '{Damage:0}')],
       ['minecraft:rose_bush'],
       [Item.of('minecraft:iron_pickaxe', '{Damage:0}')],
       ['minecraft:blue_orchid'],
       ['minecraft:oak_sapling'],
       ['minecraft:obsidian'],
       ['minecraft:lapis_lazuli'],
       [Item.of('minecraft:chainmail_leggings', '{Damage:0}')],
       [Item.of('minecraft:iron_leggings', '{Damage:0}')],
       ['minecraft:moss_block'],
       ['minecraft:slime_ball'],
       ['minecraft:iron_horse_armor'],
       [Item.of('minecraft:iron_chestplate', '{Damage:0}')],
       [Item.of('minecraft:stone_shovel', '{Damage:0}')],
]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['incubation:turtle_egg_crate',3],
        ['vintagedelight:gearo_berry_bag',3],
        ['ubesdelight:lemongrass_crate',3],
        ['trailandtales_delight:pitcher_taro_crate',3],
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
 let lootItem = [
        ['whimsy_deco:gatcha_capsule',0.3],//扭蛋胶囊
        ['additionaladditions:rose_gold_alloy',0.15],
        ['minecraft:firework_star',0.15],
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/plains_mansion/plains_mansion_treasure')////平原府邸
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/plains_mansion/plains_mansion_treasure')//平原府邸
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('simply_houses:chests/plains_mansion/plains_mansion_treasure')//平原府邸
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})

//平原府邸 木桶
LootJS.modifiers(event => {//平原房屋
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:bread'],
       [Item.of('minecraft:iron_sword', '{Damage:0}')],
       ['touhou_little_maid:power_point'],
       [Item.of('minecraft:iron_helmet', '{Damage:0}')],
       ['minecraft:apple'],
       ['minecraft:saddle'],
       [Item.of('minecraft:iron_boots', '{Damage:0}')],
       ['minecraft:rose_bush'],
       [Item.of('minecraft:iron_pickaxe', '{Damage:0}')],
       ['minecraft:blue_orchid'],
       ['minecraft:oak_sapling'],
       ['minecraft:obsidian'],
       ['minecraft:lapis_lazuli'],
       [Item.of('minecraft:chainmail_leggings', '{Damage:0}')],
       [Item.of('minecraft:iron_leggings', '{Damage:0}')],
       ['minecraft:moss_block'],
       ['minecraft:slime_ball'],
       ['minecraft:iron_horse_armor'],
       [Item.of('minecraft:iron_chestplate', '{Damage:0}')],
       [Item.of('minecraft:stone_shovel', '{Damage:0}')],
]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['incubation:chicken_egg_crate',3],//箱装鸡蛋
        ['braziliandelight:green_coconut_crate',3],
        ['braziliandelight:guarana_fruit_crate',3],
        ['veggiesdelight:turnip_crate',3],
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
 let lootItem = [
        ['whimsy_deco:gatcha_capsule',0.15],//扭蛋胶囊
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/plains_mansion/plains_mansion_barrels')////平原府邸 木桶
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/plains_mansion/plains_mansion_barrels')//平原府邸
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('simply_houses:chests/plains_mansion/plains_mansion_barrels')//平原府邸 木桶
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})

//要塞走廊
LootJS.modifiers(event => {//要塞走廊
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:coal'],//煤炭
        ['minecraft:glow_berries'],//发光浆果
        ['minecraft:compass'],//指南针
        ['minecraft:beetroot_seeds'],//甜菜种子
        ['minecraft:melon_seeds'],//西瓜种子
        ['minecraft:rail'],//铁轨
        ['minecraft:powered_rail'],//动力铁轨
        ['minecraft:activator_rail'],//激活铁轨
        ['minecraft:detector_rail'],//探测铁轨
        ['minecraft:leather'],//皮革
        ['minecraft:iron_ingot'],//铁
        ['minecraft:gold_ingot'],//金
        ['minecraft:emerald'],//绿宝石
        ['minecraft:diamond'],//钻石
        ['minecraft:lapis_lazuli'],//青金石
        ['minecraft:redstone'],//红石
        ['additionaladditions:rope'],//绳子
        ['supplementaries:rope'],//绳索
        ['farmersdelight:rope'],//绳子
        ['additionaladditions:glow_stick'],//荧光棒
        ['muffins_thaidelight:pepper_seeds'],//辣椒种子
        ['minecraft:torch'],//火把
        ['dumplings_delight:chinese_cabbage_seeds'],//白菜种子
        [('minecraft:clock')],//钟
        [Item.of('minecraft:iron_axe')],//铁斧头
        ['farmersdelight:cabbage_seeds'],//卷心菜种子
        ['additionaladditions:rose_gold_upgrade'],//锻造模板
        ['minecraft:pumpkin_seeds'],//南瓜种子
        ['galosphere:silver_upgrade_smithing_template'],//锻造模板
        [Item.of('minecraft:potion', '{Potion:"ars_nouveau:mana_regen_potion_long"}')],//药水
        ['ars_nouveau:music_disc_aria_biblio'],//唱片
         ['minecraft:coal'],//煤炭
        ['minecraft:stone_axe'],//石斧
        ['minecraft:wheat'],//小麦
        ['minecraft:rotten_flesh'],//腐肉
        ['minecraft:leather_chestplate'],//皮革外套
        ['minecraft:leather'],//皮革
        ['minecraft:iron_nugget'],//铁粒
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:emerald'],//绿宝石
        ['minecraft:gold_ingot'],//金
        ['minecraft:iron_ingot'],//铁
        ['additionaladditions:rose_gold_upgrade'],//锻造模板
        [Item.of('beachparty:rubber_ring_pelican', '{Damage:0}')],//泳圈
        ['beachparty:overgrown_disc'],//唱片
        ['minecraft:coast_armor_trim_smithing_template'],//锻造模板
        ['minecraft:lapis_lazuli'],//青金石
        ['rustic_engineer:book_abyssal_submarine'],//书
        ['ars_nouveau:pierce_arrow'],//箭
        [Item.of('minecraft:potion', '{Potion:"ars_nouveau:mana_regen_potion"}')],//药水
        ['ars_nouveau:amplify_arrow'],//强化箭
        [Item.of('minecraft:iron_pickaxe', '{Damage:0}')],
        [Item.of('minecraft:iron_pickaxe', '{Damage:0}')],
        ['ars_nouveau:split_arrow'],
        [Item.of('minecraft:iron_sword', '{Damage:0}')],
        ['touhou_little_maid:power_point'],
        [Item.of('minecraft:iron_chestplate', '{Damage:0}')],
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['miners_delight:silverfish_eggs',1],//矿工乐事 蠹虫卵
        ['incubation:turtle_egg_crate',1],
        ['dungeonsdelight:silverfish_abdomen',2],//地牢乐事 蠹虫胸肉
        ['alexsmobs:cockroach_ootheca',2],//alex生物 蟑螂卵
        ['alexsmobs:leafcutter_ant_pupa',2],//alex生物 切叶蚁卵
        ['lightmanscurrency:coin_gold',5],//硬币与物品 金币
        ['alexsmobs:maggot',3],//alex生物 蛆
    ]
 let lootItem = [
        ['dungeonsdelight:silverfish_fried_rice',0.2],//地牢乐事 蠹虫炒饭
        ['dungeonsdelight:candied_silverfish_sucker',0.2],//地牢乐事 糖渍蠹虫棒棒糖
]
 //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/stronghold_corridor')//要塞走廊
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/stronghold_corridor')//要塞走廊
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/stronghold_corridor')//要塞走廊
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})



















    











